/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 06/28/2007
 */

package freak.gui.scheduleeditor;

import freak.core.graph.*;
import freak.core.modulesupport.*;
import freak.core.populationmanager.*;
import freak.gui.*;

/**
 * @author  Oliver
 */
public class PanelPopulation extends ScheduleEditorPanel {

	/**
	 * @uml.property  name="populationManagers"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private Module[] populationManagers;
	/**
	 * @uml.property  name="initializationOperators"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private Module[] initializationOperators;

	/** Creates new JPanel */
	public PanelPopulation(ScheduleEditor scheduleEditor) {
		super(scheduleEditor);
		initComponents();
	}

	public static String getDescription() {
		return "Setup Initial Population";
	}

	public String getHelpURL() {
		return "node4.html#SECTION00446000000000000000";
	}

	protected void initForStartedSchedule() {
		listPopulationManager.setEnabled(false);
		listInitializationOperators.setEnabled(false);
		buConfigPopulationManager.setVisible(false);
		buConfigInitializationOperator.setVisible(false);
	}

	public boolean mayAdvance() {
		return schedule.getPopulationManager() != null && schedule.getInitialization() != null;
	}

	public void enter() {
		super.enter();
		populationManagers = moduleCollector.getPopulationManagers();
		((ModuleList)listPopulationManager).setModules(populationManagers, schedule.getPopulationManager());
		initializationOperators = moduleCollector.getInitializationOperators();
		((ModuleList)listInitializationOperators).setModules(initializationOperators, schedule.getInitialization());
	}

	private void parsePopulationManager() {
		Module m = schedule.getPopulationManager();
		Util.displayText(taDescrPopulationManager, m.getDescription());
		if (m instanceof Configurable)
			Util.displayText(tfOptionsPopulationManager, ((Configurable)m).getConfiguration().getDescription());
		else
			Util.displayText(tfOptionsPopulationManager, "<not configurable>");
		buConfigPopulationManager.setEnabled(m instanceof Configurable);
	}

	private void parseInitializationOperator() {
		Module m = schedule.getInitialization();
		Util.displayText(taDescrInitializationOperator, m.getDescription());
		if (m instanceof Configurable)
			Util.displayText(tfOptionsInitializationOperator, ((Configurable)m).getConfiguration().getDescription());
		else
			Util.displayText(tfOptionsInitializationOperator, "<not configurable>");
		buConfigInitializationOperator.setEnabled(m instanceof Configurable);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jScrollPane9 = new javax.swing.JScrollPane();
        listPopulationManager = new ModuleList();
        jScrollPane10 = new javax.swing.JScrollPane();
        taDescrPopulationManager = new javax.swing.JTextArea();
        jLabel22 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        jLabel24 = new javax.swing.JLabel();
        tfOptionsPopulationManager = new javax.swing.JTextField();
        buConfigPopulationManager = new javax.swing.JButton();
        jPanel11 = new javax.swing.JPanel();
        jScrollPane13 = new javax.swing.JScrollPane();
        listInitializationOperators = new ModuleList();
        jScrollPane14 = new javax.swing.JScrollPane();
        taDescrInitializationOperator = new javax.swing.JTextArea();
        jLabel33 = new javax.swing.JLabel();
        jLabel34 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        tfOptionsInitializationOperator = new javax.swing.JTextField();
        buConfigInitializationOperator = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.TitledBorder("Select Population Model & Initialization"));
        jPanel1.setLayout(new java.awt.GridLayout(2, 1));

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jScrollPane9.setMinimumSize(new java.awt.Dimension(220, 0));
        jScrollPane9.setPreferredSize(new java.awt.Dimension(220, 0));
        listPopulationManager.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        listPopulationManager.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                listPopulationManagerValueChanged(evt);
            }
        });

        jScrollPane9.setViewportView(listPopulationManager);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel5.add(jScrollPane9, gridBagConstraints);

        taDescrPopulationManager.setEditable(false);
        taDescrPopulationManager.setLineWrap(true);
        taDescrPopulationManager.setText("<no population model selected>");
        taDescrPopulationManager.setWrapStyleWord(true);
        jScrollPane10.setViewportView(taDescrPopulationManager);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel5.add(jScrollPane10, gridBagConstraints);

        jLabel22.setText("Population Models:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jLabel22, gridBagConstraints);

        jLabel23.setText("Description:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel5.add(jLabel23, gridBagConstraints);

        jLabel24.setText("Options:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel5.add(jLabel24, gridBagConstraints);

        tfOptionsPopulationManager.setEditable(false);
        tfOptionsPopulationManager.setText("<no population model selected>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanel5.add(tfOptionsPopulationManager, gridBagConstraints);

        buConfigPopulationManager.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        buConfigPopulationManager.setMnemonic('o');
        buConfigPopulationManager.setText("Configure...");
        buConfigPopulationManager.setEnabled(false);
        buConfigPopulationManager.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buConfigPopulationManagerActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel5.add(buConfigPopulationManager, gridBagConstraints);

        jPanel1.add(jPanel5);

        jPanel11.setLayout(new java.awt.GridBagLayout());

        jScrollPane13.setMinimumSize(new java.awt.Dimension(220, 0));
        jScrollPane13.setPreferredSize(new java.awt.Dimension(220, 0));
        listInitializationOperators.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        listInitializationOperators.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                listInitializationOperatorsValueChanged(evt);
            }
        });

        jScrollPane13.setViewportView(listInitializationOperators);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel11.add(jScrollPane13, gridBagConstraints);

        taDescrInitializationOperator.setEditable(false);
        taDescrInitializationOperator.setLineWrap(true);
        taDescrInitializationOperator.setText("<no initialization operator selected>");
        taDescrInitializationOperator.setWrapStyleWord(true);
        jScrollPane14.setViewportView(taDescrInitializationOperator);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel11.add(jScrollPane14, gridBagConstraints);

        jLabel33.setText("Initialization Modules:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(jLabel33, gridBagConstraints);

        jLabel34.setText("Description:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(jLabel34, gridBagConstraints);

        jLabel16.setText("Options:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        jPanel11.add(jLabel16, gridBagConstraints);

        tfOptionsInitializationOperator.setEditable(false);
        tfOptionsInitializationOperator.setText("<no initialization operator selected>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanel11.add(tfOptionsInitializationOperator, gridBagConstraints);

        buConfigInitializationOperator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        buConfigInitializationOperator.setMnemonic('o');
        buConfigInitializationOperator.setText("Configure...");
        buConfigInitializationOperator.setEnabled(false);
        buConfigInitializationOperator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buConfigInitializationOperatorActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel11.add(buConfigInitializationOperator, gridBagConstraints);

        jPanel1.add(jPanel11);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        add(jPanel1, gridBagConstraints);

    }//GEN-END:initComponents

	private void buConfigInitializationOperatorActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_buConfigInitializationOperatorActionPerformed
		String s = Util.configureModule(scheduleEditor, schedule.getInitialization(), schedule);
		if (s != null)
			Util.displayText(tfOptionsInitializationOperator, s);
		scheduleDependencyChecker.processNewModuleConfiguration(schedule.getInitialization());
		scheduleEditor.updateComponents();
	} //GEN-LAST:event_buConfigInitializationOperatorActionPerformed

	private void buConfigPopulationManagerActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_buConfigPopulationManagerActionPerformed
		String s = Util.configureModule(scheduleEditor, schedule.getPopulationManager(), schedule);
		if (s != null)
			Util.displayText(tfOptionsPopulationManager, s);
		scheduleDependencyChecker.processNewModuleConfiguration(schedule.getPopulationManager());
		scheduleEditor.updateComponents();
	} //GEN-LAST:event_buConfigPopulationManagerActionPerformed

	private void listInitializationOperatorsValueChanged(javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_listInitializationOperatorsValueChanged
		if (evt.getValueIsAdjusting())
			return;
		Initialization oldObj = schedule.getInitialization();
		Initialization newObj = (Initialization)listInitializationOperators.getSelectedValue();
		if (newObj != oldObj) {
			if (oldObj != null) {
				eventController.replaceGlobalEventSource(oldObj, newObj);
				eventController.removeModule(oldObj);
			}
			schedule.setInitialization(newObj);
			scheduleDependencyChecker.processNewInitializationOperator();
			newObj.createEvents();
			scheduleEditor.updateComponents();
		}
		parseInitializationOperator();
	} //GEN-LAST:event_listInitializationOperatorsValueChanged

	private void listPopulationManagerValueChanged(javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_listPopulationManagerValueChanged
		if (evt.getValueIsAdjusting())
			return;
		PopulationManager oldObj = schedule.getPopulationManager();
		PopulationManager newObj = (PopulationManager)listPopulationManager.getSelectedValue();
		if (newObj != oldObj) {
			if (oldObj != null) {
				eventController.replaceGlobalEventSource(oldObj, newObj);
				eventController.removeModule(oldObj);
			}
			schedule.setPopulationManager(newObj);
			scheduleDependencyChecker.processNewPopulationManager();
			newObj.createEvents();
			scheduleEditor.updateComponents();
		}
		parsePopulationManager();
	} //GEN-LAST:event_listPopulationManagerValueChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buConfigInitializationOperator;
    private javax.swing.JButton buConfigPopulationManager;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane10;
    private javax.swing.JScrollPane jScrollPane13;
    private javax.swing.JScrollPane jScrollPane14;
    private javax.swing.JScrollPane jScrollPane9;
    private javax.swing.JList listInitializationOperators;
    private javax.swing.JList listPopulationManager;
    private javax.swing.JTextArea taDescrInitializationOperator;
    private javax.swing.JTextArea taDescrPopulationManager;
    private javax.swing.JTextField tfOptionsInitializationOperator;
    private javax.swing.JTextField tfOptionsPopulationManager;
    // End of variables declaration//GEN-END:variables

}
