/*
 * Decompiled with CFR 0.152.
 */
package freak.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class GraphViz {
    private static String TEMP_DIR = "/tmp";
    public static String DOT = "/usr/bin/dot";
    private StringBuffer graph = new StringBuffer();

    public String getDotSource() {
        return this.graph.toString();
    }

    public void add(String line) {
        this.graph.append(line);
    }

    public void addln(String line) {
        this.graph.append(String.valueOf(line) + "\n");
    }

    public void addln() {
        this.graph.append('\n');
    }

    public byte[] getGraph(String dot_source) {
        byte[] img_stream = null;
        try {
            File dot = this.writeDotSourceToFile(dot_source);
            if (dot != null) {
                img_stream = this.get_img_stream(dot);
                if (!dot.delete()) {
                    System.err.println("Warning: " + dot.getAbsolutePath() + " could not be deleted!");
                }
                return img_stream;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public int writeGraphToFile(byte[] img, String file) {
        File to = new File(file);
        return this.writeGraphToFile(img, to);
    }

    public int writeGraphToFile(byte[] img, File to) {
        try {
            FileOutputStream fos = new FileOutputStream(to);
            fos.write(img);
            fos.close();
        }
        catch (IOException ioe) {
            return -1;
        }
        return 1;
    }

    private byte[] get_img_stream(File dot) {
        byte[] img_stream = null;
        try {
            File img = File.createTempFile("graph_", ".gif", new File(TEMP_DIR));
            String temp = img.getAbsolutePath();
            Runtime rt = Runtime.getRuntime();
            String cmd = String.valueOf(DOT) + " -Tgif " + dot.getAbsolutePath() + " -o" + img.getAbsolutePath();
            Process p = rt.exec(cmd);
            p.waitFor();
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            if (in != null) {
                in.close();
            }
            if (!img.delete()) {
                System.err.println("Warning: " + img.getAbsolutePath() + " could not be deleted!");
            }
        }
        catch (IOException temp) {
        }
        catch (InterruptedException ie) {
            System.err.println("Error: the execution of the external program was interrupted");
            ie.printStackTrace();
        }
        return img_stream;
    }

    private File writeDotSourceToFile(String str) throws IOException {
        File temp;
        try {
            temp = File.createTempFile("graph_", ".dot.tmp", new File(TEMP_DIR));
            FileWriter fout = new FileWriter(temp);
            fout.write(str);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source to temp file!");
            return null;
        }
        return temp;
    }

    public String start_graph() {
        return "digraph G {";
    }

    public String end_graph() {
        return "}";
    }
}

