/*
 * Decompiled with CFR 0.152.
 */
package freak.core.graph;

import freak.core.graph.GraphSyntaxException;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.MissingEdgeException;
import freak.core.graph.Operator;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.ArrayList;

public class InPort
extends Port {
    private ArrayList cache = new ArrayList();

    public InPort(Operator operator, int number) {
        super(operator, number);
    }

    public void addPartner(Port partner) {
        if (partner != null && !(partner instanceof OutPort)) {
            throw new UnsupportedOperationException("Can't connect two inPorts.");
        }
        super.addPartner(partner);
    }

    public void put(IndividualList individuals) {
        if (individuals == null) {
            throw new UnsupportedOperationException("Tried to send null to inPort.");
        }
        this.cache.add(individuals);
    }

    public IndividualList get() {
        if (this.cache.size() == 1) {
            return (IndividualList)this.cache.get(0);
        }
        if (this.cache.size() > 1) {
            int sum = 0;
            int i = this.cache.size() - 1;
            while (i >= 0) {
                sum += ((IndividualList)this.cache.get(i)).size();
                --i;
            }
            Population result = new Population(this.getOperator().getOperatorGraph().getSchedule(), sum);
            int i2 = this.cache.size() - 1;
            while (i2 >= 0) {
                result.addAllIndividuals((IndividualList)this.cache.get(i2));
                --i2;
            }
            return result;
        }
        return new Population(this.getOperator().getOperatorGraph().getSchedule());
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void checkSyntax() throws GraphSyntaxException {
        if (!(this.getOperator() instanceof HasFloatingNumberOfInPorts) && this.getNumberOfPartners() == 0) {
            throw new MissingEdgeException("thrown by: " + this + "inport");
        }
    }
}

