/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.Freak;
import freak.core.control.Schedule;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.inspector.InspectorVetoException;
import freak.gui.ConfigurationPanel;
import freak.gui.JButtonFactory;
import freak.gui.graph.FreakPortView;
import freak.gui.graph.ParameterControllerDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.DefaultTreeModel;
import org.jgraph.JGraph;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

public abstract class EditorDialogUI
extends JDialog
implements GraphSelectionListener {
    protected FreakGraphModel graphModel;
    protected Schedule schedule;
    protected ModuleCollector manager;
    protected JGraph graph;
    protected Action delete;
    protected Action zoom;
    protected Action zoomIn;
    protected Action zoomOut;
    protected Action newGraph;
    protected Action save;
    protected Action saveAs;
    protected Action open;
    protected Action close;
    protected Action editParameterControllers;
    protected JButton insertButton;
    protected JTree operatorTree;
    protected ParameterControllerDialog parameterControllerPanel;
    private EditorPanel editor;
    private ConfigurationPanel displayedConfigurationPanel;

    public EditorDialogUI(Dialog owner, Schedule schedule) {
        super(owner, "Edit Operator Graph", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorDialogUI.this.close(null);
            }
        });
        super.setDefaultCloseOperation(0);
        this.schedule = schedule;
        this.graphModel = this.schedule.getFreakGraphModel();
        this.graphModel.refreshFloatingPorts();
        this.manager = new ModuleCollector(this.schedule);
        this.editor = new EditorPanel();
        this.getContentPane().add((Component)this.editor, "Center");
        this.setJMenuBar(this.createMenuBar());
        this.setSize(880, 580);
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    public OperatorGraph getOperatorGraph() {
        return this.graphModel.getOperatorGraph();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif"));
        this.newGraph = new AbstractAction("New", icon){

            public void actionPerformed(ActionEvent e) {
                EditorDialogUI.this.newGraph(e);
            }
        };
        this.newGraph.putValue("SmallIcon", icon);
        this.newGraph.putValue("MnemonicKey", new Integer(78));
        this.newGraph.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, Freak.getActionModifierKey()));
        this.newGraph.setEnabled(true);
        fileMenu.add(this.newGraph);
        fileMenu.addSeparator();
        icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
        this.open = new AbstractAction("Open...", icon){

            public void actionPerformed(ActionEvent e) {
                EditorDialogUI.this.open(e);
            }
        };
        this.open.putValue("SmallIcon", icon);
        this.open.putValue("MnemonicKey", new Integer(79));
        this.open.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, Freak.getActionModifierKey()));
        this.open.setEnabled(true);
        fileMenu.add(this.open);
        icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"));
        this.save = new AbstractAction("Save", icon){

            public void actionPerformed(ActionEvent e) {
                EditorDialogUI.this.save(e);
            }
        };
        this.save.putValue("SmallIcon", icon);
        this.save.putValue("MnemonicKey", new Integer(83));
        this.save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Freak.getActionModifierKey()));
        this.save.setEnabled(true);
        fileMenu.add(this.save);
        icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"));
        this.saveAs = new AbstractAction("Save As...", icon){

            public void actionPerformed(ActionEvent e) {
                EditorDialogUI.this.saveAs(e);
            }
        };
        this.saveAs.putValue("SmallIcon", icon);
        this.saveAs.putValue("MnemonicKey", new Integer(65));
        this.saveAs.setEnabled(true);
        fileMenu.add(this.saveAs);
        fileMenu.addSeparator();
        this.close = new AbstractAction("Close"){

            public void actionPerformed(ActionEvent e) {
                EditorDialogUI.this.close(e);
            }
        };
        this.close.putValue("MnemonicKey", new Integer(67));
        this.close.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, Freak.getActionModifierKey()));
        this.close.setEnabled(true);
        fileMenu.add(this.close);
        menu.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        editMenu.add(this.delete);
        editMenu.addSeparator();
        editMenu.add(this.editParameterControllers);
        menu.add(editMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        viewMenu.add(this.zoom);
        viewMenu.add(this.zoomIn);
        viewMenu.add(this.zoomOut);
        menu.add(viewMenu);
        return menu;
    }

    protected abstract void newGraph(ActionEvent var1);

    protected abstract void open(ActionEvent var1);

    protected abstract void save(ActionEvent var1);

    protected abstract void saveAs(ActionEvent var1);

    protected void close(ActionEvent e) {
        super.setVisible(false);
    }

    protected abstract void insert(ActionEvent var1);

    protected abstract void connect(Port var1, Port var2);

    protected abstract void delete(ActionEvent var1);

    protected abstract void editParameterControllers(ActionEvent var1);

    protected void zoom(ActionEvent e) {
        this.graph.setScale(1.0);
    }

    protected void zoomIn(ActionEvent e) {
        this.graph.setScale(2.0 * this.graph.getScale());
    }

    protected void zoomOut(ActionEvent e) {
        this.graph.setScale(this.graph.getScale() / 2.0);
    }

    protected abstract DefaultTreeModel createOperatorTreeModel();

    public abstract void valueChanged(GraphSelectionEvent var1);

    protected void displayToRight(ConfigurationPanel panelToDisplay) {
        try {
            if (this.displayedConfigurationPanel != null) {
                this.displayedConfigurationPanel.finishEditing();
            }
        }
        catch (InspectorVetoException ex) {
            String message = "The properties of module " + this.displayedConfigurationPanel.getConfiguredModule().getName() + " are invalid.\n" + ex.getMessage();
            JOptionPane.showMessageDialog(this, message, "Invalid Property Settings", 0);
            return;
        }
        this.displayedConfigurationPanel = panelToDisplay;
        this.editor.inspectorScrollPane.setViewportView(panelToDisplay);
    }

    ConfigurationPanel getDisplayedConfigurationPanel() {
        return this.displayedConfigurationPanel;
    }

    void clearDisplayedConfigurationPanel() {
        this.displayedConfigurationPanel = null;
    }

    protected class EditorPanel
    extends JPanel {
        protected GraphUndoManager undoManager;
        private JToolBar editToolbar;
        private JScrollPane jScrollPane1;
        private JSplitPane outerSplitPane;
        private JSplitPane innerSplitPane;
        JScrollPane inspectorScrollPane;
        private JPanel jPanel5;
        private JToolBar zoomToolbar;
        private JPanel toolbarPanel;
        private JPanel jPanel1;
        private JToolBar freakToolbar;

        public EditorPanel() {
            this.initComponents();
            EditorDialogUI.this.graph = new JGraph(EditorDialogUI.this.graphModel){

                protected PortView createPortView(Object p, CellMapper cm) {
                    return new FreakPortView(p, this, cm);
                }
            };
            EditorDialogUI.this.graph.setBendable(false);
            EditorDialogUI.this.graph.setEditable(false);
            EditorDialogUI.this.graph.setConnectable(true);
            EditorDialogUI.this.graph.setDisconnectable(false);
            EditorDialogUI.this.graph.setDisconnectOnMove(true);
            EditorDialogUI.this.graph.setTolerance(6);
            EditorDialogUI.this.graph.setGridEnabled(false);
            EditorDialogUI.this.graph.setGridVisible(false);
            EditorDialogUI.this.graph.setPortsVisible(true);
            this.innerSplitPane.setLeftComponent(new JScrollPane(EditorDialogUI.this.graph));
            EditorDialogUI.this.operatorTree.setModel(EditorDialogUI.this.createOperatorTreeModel());
            EditorDialogUI.this.operatorTree.getSelectionModel().setSelectionMode(1);
            this.undoManager = new GraphUndoManager(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    super.undoableEditHappened(e);
                }
            };
            EditorDialogUI.this.graph.getSelectionModel().addGraphSelectionListener(EditorDialogUI.this);
            EditorDialogUI.this.graph.getModel().addUndoableEditListener(this.undoManager);
            this.addActions();
        }

        private void addActions() {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif"));
            EditorDialogUI.this.delete = new AbstractAction("Delete", icon){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.delete(e);
                }
            };
            EditorDialogUI.this.delete.putValue("MnemonicKey", new Integer(68));
            EditorDialogUI.this.delete.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.editToolbar.add(EditorDialogUI.this.delete);
            EditorDialogUI.this.delete.setEnabled(false);
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Zoom16.gif"));
            EditorDialogUI.this.zoom = new AbstractAction("Zoom", icon){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.zoom(e);
                }
            };
            EditorDialogUI.this.zoom.putValue("AcceleratorKey", KeyStroke.getKeyStroke(49, Freak.getActionModifierKey()));
            EditorDialogUI.this.zoom.putValue("MnemonicKey", new Integer(90));
            this.zoomToolbar.add(EditorDialogUI.this.zoom);
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomIn16.gif"));
            EditorDialogUI.this.zoomIn = new AbstractAction("Zoom In", icon){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.zoomIn(e);
                }
            };
            EditorDialogUI.this.zoomIn.putValue("AcceleratorKey", KeyStroke.getKeyStroke(521, Freak.getActionModifierKey()));
            EditorDialogUI.this.zoomIn.putValue("MnemonicKey", new Integer(73));
            this.zoomToolbar.add(EditorDialogUI.this.zoomIn);
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/ZoomOut16.gif"));
            EditorDialogUI.this.zoomOut = new AbstractAction("Zoom Out", icon){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.zoomOut(e);
                }
            };
            EditorDialogUI.this.zoomOut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, Freak.getActionModifierKey()));
            EditorDialogUI.this.zoomOut.putValue("MnemonicKey", new Integer(79));
            this.zoomToolbar.add(EditorDialogUI.this.zoomOut);
            EditorDialogUI.this.editParameterControllers = new AbstractAction("Edit Parameter Controllers", null){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.editParameterControllers(e);
                }
            };
            EditorDialogUI.this.editParameterControllers.putValue("MnemonicKey", new Integer(69));
            EditorDialogUI.this.editParameterControllers.setEnabled(true);
            this.freakToolbar.add(EditorDialogUI.this.editParameterControllers);
        }

        private void initComponents() {
            this.toolbarPanel = new JPanel();
            this.editToolbar = new JToolBar();
            this.zoomToolbar = new JToolBar();
            this.freakToolbar = new JToolBar();
            this.outerSplitPane = new JSplitPane();
            this.innerSplitPane = new JSplitPane();
            this.jPanel1 = new JPanel();
            this.jScrollPane1 = new JScrollPane();
            EditorDialogUI.this.operatorTree = new JTree();
            this.jPanel5 = new JPanel();
            EditorDialogUI.this.insertButton = JButtonFactory.newButton();
            this.inspectorScrollPane = new JScrollPane();
            this.inspectorScrollPane.setPreferredSize(new Dimension(240, 200));
            this.inspectorScrollPane.setMinimumSize(new Dimension(240, 200));
            this.setLayout(new BorderLayout());
            this.toolbarPanel.setLayout(new FlowLayout(0));
            this.toolbarPanel.add(this.editToolbar);
            this.toolbarPanel.add(this.zoomToolbar);
            this.toolbarPanel.add(this.freakToolbar);
            this.add((Component)this.toolbarPanel, "North");
            this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
            this.jScrollPane1.setViewportView(EditorDialogUI.this.operatorTree);
            this.jPanel1.add(this.jScrollPane1);
            EditorDialogUI.this.insertButton.setText("Insert Selected");
            EditorDialogUI.this.insertButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditorDialogUI.this.insert(e);
                }
            });
            EditorDialogUI.this.insertButton.setEnabled(false);
            this.jPanel5.add(EditorDialogUI.this.insertButton);
            this.jPanel1.add(this.jPanel5);
            this.jPanel1.setPreferredSize(new Dimension(200, 200));
            this.outerSplitPane.setLeftComponent(this.jPanel1);
            this.outerSplitPane.setRightComponent(this.innerSplitPane);
            this.outerSplitPane.setOneTouchExpandable(true);
            this.innerSplitPane.setRightComponent(this.inspectorScrollPane);
            this.innerSplitPane.setOneTouchExpandable(true);
            this.innerSplitPane.setResizeWeight(1.0);
            this.add((Component)this.outerSplitPane, "Center");
        }
    }
}

