/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class PathToJump
extends AbstractStaticSingleObjectiveFitnessFunction {
    public PathToJump(Schedule schedule) {
        super(schedule);
    }

    private boolean onIsland(BitSet bs) {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int onemax = bs.cardinality();
        if (onemax < 3 * n / 4 || onemax > 7 * n / 8) {
            return false;
        }
        int onesInFirstPart = 0;
        int i = 0;
        while (i < n) {
            int zeroesInFirstPart = i - onesInFirstPart;
            int differenceInSecondPart = onemax - onesInFirstPart;
            if (zeroesInFirstPart + differenceInSecondPart < n / 16) {
                return false;
            }
            if (bs.get(i)) {
                ++onesInFirstPart;
            }
            ++i;
        }
        return true;
    }

    protected double evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        boolean onPath = true;
        boolean firstPart = true;
        int leadingOnes = 0;
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int i = 0;
        while (i < dimension) {
            boolean bit = bs.get(i);
            if (!firstPart && bit) {
                onPath = false;
                break;
            }
            if (!bit) {
                firstPart = false;
            } else {
                ++leadingOnes;
            }
            ++i;
        }
        if (onPath) {
            return dimension + leadingOnes;
        }
        if (this.onIsland(bs)) {
            return 3 * dimension;
        }
        return dimension - bs.cardinality();
    }

    public String getName() {
        return "Path To Jump";
    }

    public String getDescription() {
        return "A function to demonstrate that the dynamic (1+1)EA can outperform each static (1+1) EA drastically. The individuals have to climb a path and then jump into an area of global optima. These two tasks require different mutation probabilities.";
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return 3 * ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }
}

