/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.services.Client2Hsp;
import edu.ucsb.cs.jicos.services.ClientToHsp;
import edu.ucsb.cs.jicos.services.Host;
import edu.ucsb.cs.jicos.services.Hsp;
import edu.ucsb.cs.jicos.services.TaskServer;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;

public final class HspAgent {
    private Service hsp;
    private Service taskServer;
    private Service host;
    private Client2Hsp client2Hsp;
    private String hspDomainName;

    public HspAgent(String string) {
        System.setSecurityManager(new RMISecurityManager());
        this.hspDomainName = string;
        try {
            if (string.equals("test")) {
                this.hsp = new Hsp();
                this.taskServer = new TaskServer(this.hsp, "Embedded TaskServer");
                this.host = new Host(this.hsp, "Embedded Host", null);
            } else {
                this.hsp = (Service)Naming.lookup("//" + string + ":5237/" + "Service");
            }
            this.client2Hsp = new Client2Hsp((ClientToHsp)((Object)this.hsp), this);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public Client2Hsp getClient2Hsp() {
        return this.client2Hsp;
    }

    String getHspDomainName() {
        return this.hspDomainName;
    }

    Service getHost() {
        return this.host;
    }

    Service getHsp() {
        return this.hsp;
    }

    Service getTaskServer() {
        return this.taskServer;
    }
}

