/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.FFTFilter;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class FFTCustomFilter
implements PlugInFilter,
Measurements {
    private ImagePlus imp;
    private static int filterIndex = 1;
    private int slice;
    private int stackSize;
    private boolean done;
    private ImageProcessor filter;
    private static boolean processStack;
    private boolean padded;
    private int originalWidth;
    private int originalHeight;
    private Rectangle rect = new Rectangle();

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        this.stackSize = imagePlus.getStackSize();
        if (imagePlus.getProperty("FHT") != null) {
            IJ.error("FFT Custom Filter", "Spatial domain (non-FFT) image required");
            return 4096;
        }
        return processStack ? 63 : 31;
    }

    public void run(ImageProcessor imageProcessor) {
        ++this.slice;
        if (this.done) {
            return;
        }
        FHT fHT = this.newFHT(imageProcessor);
        if (this.slice == 1) {
            this.filter = this.getFilter(fHT.getWidth());
            if (this.filter == null) {
                this.done = true;
                return;
            }
        }
        fHT.transform();
        this.customFilter(fHT);
        this.doInverseTransform(fHT, imageProcessor);
        if (this.slice == 1) {
            imageProcessor.resetMinAndMax();
        }
        if (this.slice == this.stackSize) {
            new ContrastEnhancer().stretchHistogram(this.imp, 0.0);
            this.imp.updateAndDraw();
        }
        IJ.showProgress(1.0);
    }

    void doInverseTransform(FHT fHT, ImageProcessor imageProcessor) {
        this.showStatus("Inverse transform");
        fHT.inverseTransform();
        fHT.resetMinAndMax();
        ImageProcessor imageProcessor2 = fHT;
        fHT.setRoi(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
        imageProcessor2 = fHT.crop();
        int n = fHT.originalBitDepth > 0 ? fHT.originalBitDepth : this.imp.getBitDepth();
        switch (n) {
            case 8: {
                imageProcessor2 = imageProcessor2.convertToByte(true);
                break;
            }
            case 16: {
                imageProcessor2 = imageProcessor2.convertToShort(true);
                break;
            }
            case 24: {
                this.showStatus("Setting brightness");
                fHT.rgb.setBrightness((FloatProcessor)imageProcessor2);
                imageProcessor2 = fHT.rgb;
                fHT.rgb = null;
                break;
            }
        }
        imageProcessor.insert(imageProcessor2, 0, 0);
    }

    FHT newFHT(ImageProcessor imageProcessor) {
        FHT fHT;
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = Math.max(n, n2);
        int n4 = 2;
        while ((double)n4 < 1.5 * (double)n3) {
            n4 *= 2;
        }
        this.rect.x = (int)Math.round((double)(n4 - n) / 2.0);
        this.rect.y = (int)Math.round((double)(n4 - n2) / 2.0);
        this.rect.width = n;
        this.rect.height = n2;
        FFTFilter fFTFilter = new FFTFilter();
        if (imageProcessor instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            FloatProcessor floatProcessor = ((ColorProcessor)imageProcessor).getBrightness();
            fHT = new FHT(fFTFilter.tileMirror(floatProcessor, n4, n4, this.rect.x, this.rect.y));
            fHT.rgb = (ColorProcessor)imageProcessor.duplicate();
        } else {
            fHT = new FHT(fFTFilter.tileMirror(imageProcessor, n4, n4, this.rect.x, this.rect.y));
        }
        fHT.originalWidth = this.originalWidth;
        fHT.originalHeight = this.originalHeight;
        fHT.originalBitDepth = this.imp.getBitDepth();
        return fHT;
    }

    void showStatus(String string) {
        if (this.stackSize > 1) {
            IJ.showStatus("FFT: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(string);
        }
    }

    void customFilter(FHT fHT) {
        int n = fHT.getWidth();
        this.showStatus("Filtering");
        fHT.swapQuadrants(this.filter);
        float[] fArray = (float[])fHT.getPixels();
        byte[] byArray = (byte[])this.filter.getPixels();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)((double)(fArray[i] * (float)(byArray[i] & 0xFF)) / 255.0);
        }
        fHT.swapQuadrants(this.filter);
    }

    ImageProcessor getFilter(int n) {
        ImagePlus imagePlus;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null || nArray.length < 2) {
            IJ.error("FFT", "A filter (as an open image) is required.");
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage(nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        if (filterIndex < 0 || filterIndex >= stringArray.length) {
            filterIndex = 1;
        }
        GenericDialog genericDialog = new GenericDialog("FFT Filter");
        genericDialog.addChoice("Filter:", stringArray, stringArray[filterIndex]);
        if (this.stackSize > 1) {
            genericDialog.addCheckbox("Process entire stack", processStack);
        }
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#fft-filter");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return null;
        }
        filterIndex = genericDialog.getNextChoiceIndex();
        if (this.stackSize > 1) {
            processStack = genericDialog.getNextBoolean();
        }
        if ((imagePlus = WindowManager.getImage(nArray[filterIndex])) == this.imp) {
            IJ.error("FFT", "The filter cannot be the same as the image being filtered.");
            return null;
        }
        if (imagePlus.getStackSize() > 1) {
            IJ.error("FFT", "The filter cannot be a stack.");
            return null;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        imageProcessor = imageProcessor.convertToByte(true);
        imageProcessor = this.resizeFilter(imageProcessor, n);
        return imageProcessor;
    }

    ImageProcessor resizeFilter(ImageProcessor imageProcessor, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        if (n2 == n && n3 == n) {
            return imageProcessor;
        }
        this.showStatus("Scaling filter to " + n + "x" + n);
        return imageProcessor.resize(n, n);
    }
}

