/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Projector
implements PlugInFilter {
    static final int xAxis = 0;
    static final int yAxis = 1;
    static final int zAxis = 2;
    static final int nearestPoint = 0;
    static final int brightestPoint = 1;
    static final int meanValue = 2;
    static final int BIGPOWEROF2 = 8192;
    String[] axisList = new String[]{"X-Axis", "Y-Axis", "Z-Axis"};
    String[] methodList = new String[]{"Nearest Point", "Brightest Point", "Mean Value"};
    private static int axisOfRotation = 1;
    private static int projectionMethod = 1;
    private double sliceInterval = 1.0;
    private static int initAngle = 0;
    private static int totalAngle = 360;
    private static int angleInc = 10;
    private static int opacity = 0;
    private static int depthCueSurf = 0;
    private static int depthCueInt = 50;
    private static boolean interpolate;
    private static boolean debugMode;
    private int transparencyLower = 1;
    private int transparencyUpper = 255;
    ImagePlus imp;
    ImageStack stack;
    ImageStack stack2;
    int width;
    int height;
    int imageWidth;
    int left;
    int right;
    int top;
    int bottom;
    byte[] projArray;
    byte[] opaArray;
    byte[] brightCueArray;
    short[] zBuffer;
    short[] cueZBuffer;
    short[] countBuffer;
    int[] sumBuffer;
    boolean isRGB;
    String label = "";
    boolean done;
    boolean batchMode = Interpreter.isBatchMode();

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (imagePlus != null && imagePlus.isHyperStack()) {
            IJ.error("3D Project", "Hyperstacks are currently not supported. Convert to\nRGB using Image>Type>RGB Color and try again.");
            return 4096;
        }
        return 2193;
    }

    public void run(ImageProcessor imageProcessor) {
        if (imageProcessor.isInvertedLut() && !IJ.showMessageWithCancel("3D Project", "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).")) {
            return;
        }
        if (!this.showDialog()) {
            return;
        }
        this.imp.startTiming();
        boolean bl = this.isRGB = this.imp.getType() == 4;
        if (interpolate && this.sliceInterval > 1.0) {
            this.imp = this.zScale(this.imp);
            if (this.imp == null) {
                return;
            }
            this.sliceInterval = 1.0;
        }
        if (this.isRGB) {
            this.doRGBProjections(this.imp);
        } else {
            this.doProjections(this.imp);
        }
    }

    public boolean showDialog() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMinThreshold();
        if (d != -808080.0) {
            this.transparencyLower = (int)d;
            this.transparencyUpper = (int)imageProcessor.getMaxThreshold();
        }
        Calibration calibration = this.imp.getCalibration();
        GenericDialog genericDialog = new GenericDialog("3D Projection");
        genericDialog.addChoice("Projection Method:", this.methodList, this.methodList[projectionMethod]);
        genericDialog.addChoice("Axis of Rotation:", this.axisList, this.axisList[axisOfRotation]);
        genericDialog.addNumericField("Slice Spacing (" + calibration.getUnits() + "):", calibration.pixelDepth, 2);
        genericDialog.addNumericField("Initial Angle (0-359 degrees):", initAngle, 0);
        genericDialog.addNumericField("Total Rotation (0-359 degrees):", totalAngle, 0);
        genericDialog.addNumericField("Rotation Angle Increment:", angleInc, 0);
        genericDialog.addNumericField("Lower Transparency Bound:", this.transparencyLower, 0);
        genericDialog.addNumericField("Upper Transparency Bound:", this.transparencyUpper, 0);
        genericDialog.addNumericField("Opacity (0-100%):", opacity, 0);
        genericDialog.addNumericField("Surface Depth-Cueing (0-100%):", 100 - depthCueSurf, 0);
        genericDialog.addNumericField("Interior Depth-Cueing (0-100%):", 100 - depthCueInt, 0);
        genericDialog.addCheckbox("Interpolate", interpolate);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        projectionMethod = genericDialog.getNextChoiceIndex();
        axisOfRotation = genericDialog.getNextChoiceIndex();
        calibration.pixelDepth = genericDialog.getNextNumber();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        this.sliceInterval = calibration.pixelDepth / calibration.pixelWidth;
        initAngle = (int)genericDialog.getNextNumber();
        totalAngle = (int)genericDialog.getNextNumber();
        angleInc = (int)genericDialog.getNextNumber();
        this.transparencyLower = (int)genericDialog.getNextNumber();
        this.transparencyUpper = (int)genericDialog.getNextNumber();
        opacity = (int)genericDialog.getNextNumber();
        depthCueSurf = 100 - (int)genericDialog.getNextNumber();
        depthCueInt = 100 - (int)genericDialog.getNextNumber();
        interpolate = genericDialog.getNextBoolean();
        return true;
    }

    public void doRGBProjections(ImagePlus imagePlus) {
        boolean bl = Prefs.useInvertingLut;
        Prefs.useInvertingLut = false;
        RGBStackSplitter rGBStackSplitter = new RGBStackSplitter();
        rGBStackSplitter.split(imagePlus.getStack(), true);
        ImagePlus imagePlus2 = new ImagePlus("Red", rGBStackSplitter.red);
        ImagePlus imagePlus3 = new ImagePlus("Green", rGBStackSplitter.green);
        ImagePlus imagePlus4 = new ImagePlus("Blue", rGBStackSplitter.blue);
        Calibration calibration = imagePlus.getCalibration();
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            imagePlus2.setRoi(roi);
            imagePlus3.setRoi(roi);
            imagePlus4.setRoi(roi);
        }
        imagePlus2.setCalibration(calibration);
        imagePlus3.setCalibration(calibration);
        imagePlus4.setCalibration(calibration);
        this.label = "Red: ";
        imagePlus2 = this.doProjections(imagePlus2);
        if (imagePlus2 == null || this.done) {
            return;
        }
        imagePlus2.hide();
        this.label = "Green: ";
        imagePlus3 = this.doProjections(imagePlus3);
        if (imagePlus3 == null || this.done) {
            return;
        }
        imagePlus3.hide();
        this.label = "Blue: ";
        imagePlus4 = this.doProjections(imagePlus4);
        if (imagePlus4 == null || this.done) {
            return;
        }
        imagePlus4.hide();
        int n = imagePlus2.getWidth();
        int n2 = imagePlus2.getHeight();
        int n3 = imagePlus2.getStackSize();
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        ImageStack imageStack = rGBStackMerge.mergeStacks(n, n2, n3, imagePlus2.getStack(), imagePlus3.getStack(), imagePlus4.getStack(), true);
        new ImagePlus("Projection of  " + imagePlus.getShortTitle(), imageStack).show();
        Prefs.useInvertingLut = bl;
    }

    public ImagePlus doProjections(ImagePlus imagePlus) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = true;
        this.stack = imagePlus.getStack();
        if (angleInc == 0 && totalAngle != 0) {
            angleInc = 5;
        }
        boolean bl3 = bl = angleInc < 0;
        if (bl) {
            angleInc = -angleInc;
        }
        int n3 = 0;
        if (angleInc == 0) {
            n3 = 1;
        } else {
            for (n2 = 0; n2 <= totalAngle; n2 += angleInc) {
                ++n3;
            }
        }
        if (n2 > 360) {
            --n3;
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (bl) {
            angleInc = -angleInc;
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        Rectangle rectangle = imageProcessor.getRoi();
        this.left = rectangle.x;
        this.top = rectangle.y;
        this.right = rectangle.x + rectangle.width;
        this.bottom = rectangle.y + rectangle.height;
        int n4 = imagePlus.getStackSize();
        this.imageWidth = imagePlus.getWidth();
        this.width = this.right - this.left;
        this.height = this.bottom - this.top;
        int n5 = (this.left + this.right) / 2;
        int n6 = (this.top + this.bottom) / 2;
        int n7 = (int)((double)n4 * this.sliceInterval / 2.0 + 0.5);
        int n8 = 0;
        int n9 = 0;
        if (bl2 && axisOfRotation != 2) {
            switch (axisOfRotation) {
                case 0: {
                    n9 = (int)(Math.sqrt((double)n4 * this.sliceInterval * (double)n4 * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
                    n8 = this.width;
                    break;
                }
                case 1: {
                    n8 = (int)(Math.sqrt((double)n4 * this.sliceInterval * (double)n4 * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
                    n9 = this.height;
                }
            }
        } else {
            n8 = (int)(Math.sqrt((double)n4 * this.sliceInterval * (double)n4 * this.sliceInterval + (double)(this.width * this.width)) + 0.5);
            n9 = (int)(Math.sqrt((double)n4 * this.sliceInterval * (double)n4 * this.sliceInterval + (double)(this.height * this.height)) + 0.5);
        }
        if (n8 % 2 == 1) {
            ++n8;
        }
        int n10 = n8 * n9;
        if (n8 <= 0 || n9 <= 0) {
            IJ.error("'projwidth' or 'projheight' <= 0");
            return null;
        }
        try {
            this.allocateArrays(n3, n8, n9);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Object[] objectArray = this.stack2.getImageArray();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = null;
                }
            }
            this.stack2 = null;
            IJ.error("Projector - Out of Memory", "To use less memory, use a rectanguar\nselection,  reduce \"Total Rotation\",\nand/or increase \"Angle Increment\".");
            return null;
        }
        ImagePlus imagePlus2 = new ImagePlus("Projections of " + imagePlus.getShortTitle(), this.stack2);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        imagePlus2.show();
        IJ.resetEscape();
        int n11 = initAngle;
        IJ.resetEscape();
        for (int i = 0; i < n3; ++i) {
            int n12;
            IJ.showStatus(i + "/" + n3);
            if (!this.batchMode) {
                IJ.showProgress((double)i / (double)n3);
            }
            double d = (double)n11 * Math.PI / 180.0;
            int n13 = (int)(8192.0 * Math.cos(d) + 0.5);
            int n14 = (int)(8192.0 * Math.sin(d) + 0.5);
            this.projArray = (byte[])this.stack2.getPixels(i + 1);
            if (this.projArray == null) break;
            if (projectionMethod == 0 || opacity > 0) {
                for (n12 = 0; n12 < n10; ++n12) {
                    this.zBuffer[n12] = Short.MAX_VALUE;
                }
            }
            if (opacity > 0 && projectionMethod != 0) {
                for (n12 = 0; n12 < n10; ++n12) {
                    this.opaArray[n12] = 0;
                }
            }
            if (projectionMethod == 1 && depthCueInt < 100) {
                for (n12 = 0; n12 < n10; ++n12) {
                    this.brightCueArray[n12] = 0;
                }
                for (n12 = 0; n12 < n10; ++n12) {
                    this.cueZBuffer[n12] = 0;
                }
            }
            if (projectionMethod == 2) {
                for (n12 = 0; n12 < n10; ++n12) {
                    this.sumBuffer[n12] = 0;
                }
                for (n12 = 0; n12 < n10; ++n12) {
                    this.countBuffer[n12] = 0;
                }
            }
            switch (axisOfRotation) {
                case 0: {
                    this.doOneProjectionX(n4, n6, n7, n8, n9, n13, n14);
                    break;
                }
                case 1: {
                    this.doOneProjectionY(n4, n5, n7, n8, n9, n13, n14);
                    break;
                }
                case 2: {
                    this.doOneProjectionZ(n4, n5, n6, n7, n8, n9, n13, n14);
                }
            }
            if (projectionMethod == 2) {
                for (n = 0; n < n10; ++n) {
                    n12 = this.countBuffer[n];
                    if (n12 == 0) continue;
                    this.projArray[n] = (byte)(this.sumBuffer[n] / n12);
                }
            }
            if (opacity > 0 && projectionMethod != 0) {
                for (n12 = 0; n12 < n10; ++n12) {
                    this.projArray[n12] = (byte)((opacity * (this.opaArray[n12] & 0xFF) + (100 - opacity) * (this.projArray[n12] & 0xFF)) / 100);
                }
            }
            if (axisOfRotation == 2) {
                for (n12 = n8; n12 < n10 - n8; ++n12) {
                    int n15 = this.projArray[n12] & 0xFF;
                    int n16 = this.projArray[n12 - 1] & 0xFF;
                    int n17 = this.projArray[n12 + 1] & 0xFF;
                    int n18 = this.projArray[n12 - n8] & 0xFF;
                    int n19 = this.projArray[n12 + n8] & 0xFF;
                    if (n15 != 0 || n16 == 0 || n17 == 0 || n18 == 0 || n19 == 0) continue;
                    this.projArray[n12] = (byte)((n16 + n17 + n18 + n19) / 4);
                }
            }
            n11 = (n11 + angleInc) % 360;
            if (imagePlus2.getWindow() == null && IJ.getInstance() != null && !this.batchMode) {
                this.done = true;
                break;
            }
            if (IJ.escapePressed()) {
                this.done = true;
                break;
            }
            imagePlus2.setSlice(i + 1);
            if (!IJ.escapePressed()) continue;
            IJ.beep();
            break;
        }
        if (!this.batchMode) {
            IJ.showProgress(1.0);
        }
        if (debugMode) {
            if (this.projArray != null) {
                new ImagePlus("projArray", new ByteProcessor(n8, n9, this.projArray, null)).show();
            }
            if (this.opaArray != null) {
                new ImagePlus("opaArray", new ByteProcessor(n8, n9, this.opaArray, null)).show();
            }
            if (this.brightCueArray != null) {
                new ImagePlus("brightCueArray", new ByteProcessor(n8, n9, this.brightCueArray, null)).show();
            }
            if (this.zBuffer != null) {
                new ImagePlus("zBuffer", new ShortProcessor(n8, n9, this.zBuffer, null)).show();
            }
            if (this.cueZBuffer != null) {
                new ImagePlus("cueZBuffer", new ShortProcessor(n8, n9, this.cueZBuffer, null)).show();
            }
            if (this.countBuffer != null) {
                new ImagePlus("countBuffer", new ShortProcessor(n8, n9, this.countBuffer, null)).show();
            }
            if (this.sumBuffer != null) {
                float[] fArray = new float[n8 * n9];
                for (n = 0; n < n8 * n9; ++n) {
                    fArray[n] = this.sumBuffer[n];
                }
                new ImagePlus("sumBuffer", new FloatProcessor(n8, n9, fArray, null)).show();
            }
        }
        return imagePlus2;
    }

    void allocateArrays(int n, int n2, int n3) {
        int n4 = n2 * n3;
        ColorModel colorModel = this.imp.getProcessor().getColorModel();
        if (this.isRGB) {
            colorModel = null;
        }
        this.stack2 = new ImageStack(n2, n3, colorModel);
        this.projArray = new byte[n4];
        for (int i = 0; i < n; ++i) {
            this.stack2.addSlice(null, new byte[n4]);
        }
        if (projectionMethod == 0 || opacity > 0) {
            this.zBuffer = new short[n4];
        }
        if (opacity > 0 && projectionMethod != 0) {
            this.opaArray = new byte[n4];
        }
        if (projectionMethod == 1 && depthCueInt < 100) {
            this.brightCueArray = new byte[n4];
            this.cueZBuffer = new short[n4];
        }
        if (projectionMethod == 2) {
            this.sumBuffer = new int[n4];
            this.countBuffer = new short[n4];
        }
    }

    void doOneProjectionX(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 * n5;
        int n9 = n3 + n5 / 2;
        int n10 = n3 - n5 / 2;
        int n11 = 100 * (n9 - n10);
        int n12 = 100 - depthCueInt;
        int n13 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n14 = (this.top - n2 - 1) * n6;
        int n15 = (this.top - n2 - 1) * n7;
        int n16 = (n5 - this.bottom + this.top) / 2 * n4 + (n4 - this.right + this.left) / 2 - 1;
        for (int i = 1; i <= n; ++i) {
            byte[] byArray = (byte[])this.stack.getPixels(i);
            int n17 = (int)((double)(i - 1) * this.sliceInterval + 0.5) - n3;
            int n18 = n17 * n6;
            int n19 = n17 * n7;
            int n20 = n14;
            int n21 = n15;
            for (int j = this.top; j < this.bottom; ++j) {
                int n22 = ((n20 += n6) - n19) / 8192 + n2 - this.top;
                int n23 = ((n21 += n7) + n18) / 8192 + n3;
                int n24 = n16 + n22 * n4;
                int n25 = j * this.imageWidth;
                for (int k = this.left; k < this.right; ++k) {
                    int n26 = byArray[n25 + k] & 0xFF;
                    if (++n24 >= n8 || n24 < 0) {
                        n24 = 0;
                    }
                    if (n26 > this.transparencyUpper || n26 < this.transparencyLower) continue;
                    if (bl3 && n23 < this.zBuffer[n24]) {
                        this.zBuffer[n24] = (short)n23;
                        if (bl4) {
                            this.opaArray[n24] = bl2 ? (byte)(depthCueSurf * n26 / 100 + n13 * n26 * (n9 - n23) / n11) : (byte)n26;
                        } else {
                            this.projArray[n24] = bl2 ? (byte)(depthCueSurf * n26 / 100 + n13 * n26 * (n9 - n23) / n11) : (byte)n26;
                        }
                    }
                    if (bl5) {
                        int n27 = n24;
                        this.sumBuffer[n27] = this.sumBuffer[n27] + n26;
                        int n28 = n24;
                        this.countBuffer[n28] = (short)(this.countBuffer[n28] + 1);
                        continue;
                    }
                    if (!bl6) continue;
                    if (bl) {
                        if (n26 <= (this.brightCueArray[n24] & 0xFF) && (n26 != (this.brightCueArray[n24] & 0xFF) || n23 <= this.cueZBuffer[n24])) continue;
                        this.brightCueArray[n24] = (byte)n26;
                        this.cueZBuffer[n24] = (short)n23;
                        this.projArray[n24] = (byte)(depthCueInt * n26 / 100 + n12 * n26 * (n9 - n23) / n11);
                        continue;
                    }
                    if (n26 <= (this.projArray[n24] & 0xFF)) continue;
                    this.projArray[n24] = (byte)n26;
                }
            }
        }
    }

    void doOneProjectionY(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n4 * n5;
        int n9 = n3 + n4 / 2;
        int n10 = n3 - n4 / 2;
        int n11 = 100 * (n9 - n10);
        int n12 = 100 - depthCueInt;
        int n13 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n14 = (this.left - n2 - 1) * n6;
        int n15 = (this.left - n2 - 1) * n7;
        for (int i = 1; i <= n; ++i) {
            byte[] byArray = (byte[])this.stack.getPixels(i);
            int n16 = (int)((double)(i - 1) * this.sliceInterval + 0.5) - n3;
            int n17 = n16 * n6;
            int n18 = n16 * n7;
            int n19 = (n5 - this.bottom + this.top) / 2 * n4 + (n4 - this.right + this.left) / 2 - n4;
            for (int j = this.top; j < this.bottom; ++j) {
                int n20 = n14;
                int n21 = n15;
                n19 += n4;
                int n22 = j * this.imageWidth;
                for (int k = this.left; k < this.right; ++k) {
                    int n23 = byArray[n22 + k] & 0xFF;
                    n20 += n6;
                    n21 += n7;
                    if (n23 > this.transparencyUpper || n23 < this.transparencyLower) continue;
                    int n24 = (n20 + n18) / 8192 + n2 - this.left;
                    int n25 = (n17 - n21) / 8192 + n3;
                    int n26 = n19 + n24;
                    if (n26 >= n8 || n26 < 0) {
                        n26 = 0;
                    }
                    if (bl3 && n25 < this.zBuffer[n26]) {
                        this.zBuffer[n26] = (short)n25;
                        if (bl4) {
                            this.opaArray[n26] = bl2 ? (byte)(depthCueSurf * n23 / 100 + n13 * n23 * (n9 - n25) / n11) : (byte)n23;
                        } else {
                            this.projArray[n26] = bl2 ? (byte)(depthCueSurf * n23 / 100 + n13 * n23 * (n9 - n25) / n11) : (byte)n23;
                        }
                    }
                    if (bl5) {
                        int n27 = n26;
                        this.sumBuffer[n27] = this.sumBuffer[n27] + n23;
                        int n28 = n26;
                        this.countBuffer[n28] = (short)(this.countBuffer[n28] + 1);
                        continue;
                    }
                    if (!bl6) continue;
                    if (bl) {
                        if (n23 <= (this.brightCueArray[n26] & 0xFF) && (n23 != (this.brightCueArray[n26] & 0xFF) || n25 <= this.cueZBuffer[n26])) continue;
                        this.brightCueArray[n26] = (byte)n23;
                        this.cueZBuffer[n26] = (short)n25;
                        this.projArray[n26] = (byte)(depthCueInt * n23 / 100 + n12 * n23 * (n9 - n25) / n11);
                        continue;
                    }
                    if (n23 <= (this.projArray[n26] & 0xFF)) continue;
                    this.projArray[n26] = (byte)n23;
                }
            }
        }
    }

    void doOneProjectionZ(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n5 * n6;
        int n10 = (int)((double)(n - 1) * this.sliceInterval + 0.5) - n4;
        int n11 = -n4;
        int n12 = 100 * (n10 - n11);
        int n13 = 100 - depthCueInt;
        int n14 = 100 - depthCueSurf;
        boolean bl = depthCueInt < 100;
        boolean bl2 = depthCueSurf < 100;
        boolean bl3 = projectionMethod == 0 || opacity > 0;
        boolean bl4 = opacity > 0 && projectionMethod != 0;
        boolean bl5 = projectionMethod == 2;
        boolean bl6 = projectionMethod == 1;
        int n15 = (this.left - n2 - 1) * n7;
        int n16 = (this.left - n2 - 1) * n8;
        int n17 = (this.top - n3 - 1) * n7;
        int n18 = (this.top - n3 - 1) * n8;
        int n19 = (n6 - this.bottom + this.top) / 2 * n5 + (n5 - this.right + this.left) / 2 - 1;
        for (int i = 1; i <= n; ++i) {
            byte[] byArray = (byte[])this.stack.getPixels(i);
            int n20 = (int)((double)(i - 1) * this.sliceInterval + 0.5) - n4;
            int n21 = n17;
            int n22 = n18;
            for (int j = this.top; j < this.bottom; ++j) {
                n21 += n7;
                n22 += n8;
                int n23 = n15;
                int n24 = n16;
                int n25 = j * this.imageWidth;
                for (int k = this.left; k < this.right; ++k) {
                    int n26 = byArray[n25 + k] & 0xFF;
                    n23 += n7;
                    n24 += n8;
                    if (n26 > this.transparencyUpper || n26 < this.transparencyLower) continue;
                    int n27 = (n24 + n21) / 8192 + n3 - this.top;
                    int n28 = (n23 - n22) / 8192 + n2 - this.left;
                    int n29 = n19 + n27 * n5 + n28;
                    if (n29 >= n9 || n29 < 0) {
                        n29 = 0;
                    }
                    if (bl3 && n20 < this.zBuffer[n29]) {
                        this.zBuffer[n29] = (short)n20;
                        if (bl4) {
                            this.opaArray[n29] = bl2 ? (byte)(depthCueSurf * n26 / 100 + n14 * n26 * (n10 - n20) / n12) : (byte)n26;
                        } else if (bl2) {
                            int n30 = depthCueSurf * n26 / 100 + n14 * n26 * (n10 - n20) / n12;
                            this.projArray[n29] = (byte)n30;
                        } else {
                            this.projArray[n29] = (byte)n26;
                        }
                    }
                    if (bl5) {
                        int n31 = n29;
                        this.sumBuffer[n31] = this.sumBuffer[n31] + n26;
                        int n32 = n29;
                        this.countBuffer[n32] = (short)(this.countBuffer[n32] + 1);
                        continue;
                    }
                    if (!bl6) continue;
                    if (bl) {
                        if (n26 <= (this.brightCueArray[n29] & 0xFF) && (n26 != (this.brightCueArray[n29] & 0xFF) || n20 <= this.cueZBuffer[n29])) continue;
                        this.brightCueArray[n29] = (byte)n26;
                        this.cueZBuffer[n29] = (short)n20;
                        this.projArray[n29] = (byte)(depthCueInt * n26 / 100 + n13 * n26 * (n10 - n20) / n12);
                        continue;
                    }
                    if (n26 <= (this.projArray[n29] & 0xFF)) continue;
                    this.projArray[n29] = (byte)n26;
                }
            }
        }
    }

    ImagePlus zScale(ImagePlus imagePlus) {
        IJ.showStatus("Z Scaling...");
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getSize();
        ImagePlus imagePlus2 = null;
        String string = imagePlus.getTitle();
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        ColorModel colorModel = imageProcessor.getColorModel();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = (int)((double)imageStack.getSize() * this.sliceInterval + 0.5);
        imagePlus2 = NewImage.createImage(string, n4, n5, n6, this.isRGB ? 24 : 8, 1);
        if (imagePlus2 == null || n6 != imagePlus2.getStackSize()) {
            return null;
        }
        ImageStack imageStack2 = imagePlus2.getStack();
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n4, n);
        imageProcessor2.setInterpolate(true);
        int[] nArray = new int[n4];
        for (int i = 0; i < n5; ++i) {
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                if (this.isRGB) {
                    this.getRGBRow(imageStack, rectangle.x, rectangle.y + i, n7, n2, n4, nArray);
                } else {
                    this.getByteRow(imageStack, rectangle.x, rectangle.y + i, n7, n2, n4, nArray);
                }
                imageProcessor2.putRow(0, n7, nArray, n4);
            }
            ImageProcessor imageProcessor3 = imageProcessor2.resize(n4, n6);
            for (n7 = 0; n7 < n6; ++n7) {
                imageProcessor3.getRow(0, n7, nArray, n4);
                if (this.isRGB) {
                    this.putRGBRow(imageStack2, i, n7, n4, nArray);
                    continue;
                }
                this.putByteRow(imageStack2, i, n7, n4, nArray);
            }
            if (this.batchMode) continue;
            IJ.showProgress(i, n5 - 1);
        }
        ImageProcessor imageProcessor4 = imagePlus2.getProcessor();
        imageProcessor4.setColorModel(colorModel);
        return imagePlus2;
    }

    public void getByteRow(ImageStack imageStack, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        byte[] byArray = (byte[])imageStack.getPixels(n3 + 1);
        int n6 = n + n2 * n4;
        for (int i = 0; i < n5; ++i) {
            nArray[i] = byArray[n6++] & 0xFF;
        }
    }

    public void putByteRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = (byte[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        for (int i = 0; i < n3; ++i) {
            byArray[n4++] = (byte)nArray[i];
        }
    }

    public void getRGBRow(ImageStack imageStack, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int[] nArray2 = (int[])imageStack.getPixels(n3 + 1);
        int n6 = n + n2 * n4;
        for (int i = 0; i < n5; ++i) {
            nArray[i] = nArray2[n6++];
        }
    }

    public void putRGBRow(ImageStack imageStack, int n, int n2, int n3, int[] nArray) {
        int[] nArray2 = (int[])imageStack.getPixels(n2 + 1);
        int n4 = n * n3;
        for (int i = 0; i < n3; ++i) {
            nArray2[n4++] = nArray[i];
        }
    }
}

