/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ColorBlitter
implements Blitter {
    private ColorProcessor ip;
    private int width;
    private int height;
    private int[] pixels;
    private int transparent = 0xFFFFFF;

    public ColorBlitter(ColorProcessor colorProcessor) {
        this.ip = colorProcessor;
        this.width = colorProcessor.getWidth();
        this.height = colorProcessor.getHeight();
        this.pixels = (int[])colorProcessor.getPixels();
    }

    public void setTransparentColor(Color color) {
        this.transparent = color.getRGB() & 0xFFFFFF;
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7 = imageProcessor.getWidth();
        int n8 = imageProcessor.getHeight();
        Rectangle rectangle = new Rectangle(n7, n8);
        rectangle.setLocation(n, n2);
        Rectangle rectangle2 = new Rectangle(this.width, this.height);
        if (!rectangle.intersects(rectangle2)) {
            return;
        }
        if (imageProcessor instanceof ByteProcessor) {
            byte[] byArray = (byte[])imageProcessor.getPixels();
            ColorModel colorModel = imageProcessor.getColorModel();
            if (imageProcessor.isInvertedLut()) {
                colorModel = imageProcessor.getDefaultColorModel();
            }
            n6 = imageProcessor.getWidth() * imageProcessor.getHeight();
            nArray = new int[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                nArray[n5] = colorModel.getRGB(byArray[n5] & 0xFF);
            }
        } else {
            nArray = (int[])imageProcessor.getPixels();
        }
        rectangle = rectangle.intersection(rectangle2);
        int n9 = n < 0 ? -n : 0;
        int n10 = n4 = n2 < 0 ? -n2 : 0;
        if (n3 == 0 || n3 == 2 || n3 == 14) {
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                int n11;
                int n12;
                int n13 = (i - n2) * n7 + (rectangle.x - n);
                int n14 = i * this.width + rectangle.x;
                int n15 = n12 = n3 == 14 ? 0 : this.transparent;
                if (n3 == 0) {
                    n11 = rectangle.width;
                    while (--n11 >= 0) {
                        this.pixels[n14++] = nArray[n13++];
                    }
                    continue;
                }
                n11 = rectangle.width;
                while (--n11 >= 0) {
                    int n16 = nArray[n13++];
                    int n17 = this.pixels[n14];
                    this.pixels[n14++] = (n16 & 0xFFFFFF) == n12 ? n17 : n16;
                }
            }
            return;
        }
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n18 = (i - n2) * n7 + (rectangle.x - n);
            int n19 = i * this.width + rectangle.x;
            int n20 = rectangle.width;
            while (--n20 >= 0) {
                int n21 = nArray[n18++];
                n6 = (n21 & 0xFF0000) >> 16;
                int n22 = (n21 & 0xFF00) >> 8;
                n5 = n21 & 0xFF;
                int n23 = this.pixels[n19];
                int n24 = (n23 & 0xFF0000) >> 16;
                int n25 = (n23 & 0xFF00) >> 8;
                int n26 = n23 & 0xFF;
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        n24 = n6 + n24;
                        n25 = n22 + n25;
                        n26 = n5 + n26;
                        if (n24 > 255) {
                            n24 = 255;
                        }
                        if (n25 > 255) {
                            n25 = 255;
                        }
                        if (n26 <= 255) break;
                        n26 = 255;
                        break;
                    }
                    case 7: {
                        n24 = (n6 + n24) / 2;
                        n25 = (n22 + n25) / 2;
                        n26 = (n5 + n26) / 2;
                        break;
                    }
                    case 4: {
                        n25 -= n22;
                        n26 -= n5;
                        if ((n24 -= n6) < 0) {
                            n24 = 0;
                        }
                        if (n25 < 0) {
                            n25 = 0;
                        }
                        if (n26 >= 0) break;
                        n26 = 0;
                        break;
                    }
                    case 8: {
                        if ((n24 -= n6) < 0) {
                            n24 = -n24;
                        }
                        if ((n25 -= n22) < 0) {
                            n25 = -n25;
                        }
                        if ((n26 -= n5) >= 0) break;
                        n26 = -n26;
                        break;
                    }
                    case 5: {
                        n24 = n6 * n24;
                        n25 = n22 * n25;
                        n26 = n5 * n26;
                        if (n24 > 255) {
                            n24 = 255;
                        }
                        if (n25 > 255) {
                            n25 = 255;
                        }
                        if (n26 <= 255) break;
                        n26 = 255;
                        break;
                    }
                    case 6: {
                        n24 = n6 == 0 ? 255 : (n24 /= n6);
                        n25 = n22 == 0 ? 255 : (n25 /= n22);
                        if (n5 == 0) {
                            n26 = 255;
                            break;
                        }
                        n26 /= n5;
                        break;
                    }
                    case 9: {
                        n24 = n6 & n24;
                        n25 = n22 & n25;
                        n26 = n5 & n26;
                        break;
                    }
                    case 10: {
                        n24 = n6 | n24;
                        n25 = n22 | n25;
                        n26 = n5 | n26;
                        break;
                    }
                    case 11: {
                        n24 = n6 ^ n24;
                        n25 = n22 ^ n25;
                        n26 = n5 ^ n26;
                        break;
                    }
                    case 12: {
                        if (n6 < n24) {
                            n24 = n6;
                        }
                        if (n22 < n25) {
                            n25 = n22;
                        }
                        if (n5 >= n26) break;
                        n26 = n5;
                        break;
                    }
                    case 13: {
                        if (n6 > n24) {
                            n24 = n6;
                        }
                        if (n22 > n25) {
                            n25 = n22;
                        }
                        if (n5 <= n26) break;
                        n26 = n5;
                    }
                }
                this.pixels[n19++] = -16777216 + (n24 << 16) + (n25 << 8) + n26;
            }
            if (i % 20 != 0) continue;
            imageProcessor.showProgress((double)(i - rectangle.y) / (double)rectangle.height);
        }
        imageProcessor.showProgress(1.0);
    }
}

