% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.xbal.R
\name{print.xbal}
\alias{print.xbal}
\alias{print}
\alias{print.balancetest}
\title{Printing xBalance and balanceTest Objects}
\usage{
\method{print}{xbal}(
  x,
  which.strata = dimnames(x$results)[["strata"]],
  which.stats = dimnames(x$results)[["stat"]],
  which.vars = dimnames(x$results)[["vars"]],
  print.overall = TRUE,
  digits = NULL,
  printme = TRUE,
  show.signif.stars = getOption("show.signif.stars"),
  show.pvals = !show.signif.stars,
  horizontal = TRUE,
  report = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class "xbal" which is the result of a call
to \code{xBalance}.}

\item{which.strata}{The stratification candidates to include in
the printout. Default is all.}

\item{which.stats}{The test statistics to include. Default is all
those requested from the call to \code{xBalance}.}

\item{which.vars}{The variables for which test information should
be displayed. Default is all.}

\item{print.overall}{Should the omnibus test be reported? Default
is \code{TRUE}.}

\item{digits}{To how many digits should the results be displayed?
Default is \code{max(2,getOptions("digits")-4)}.}

\item{printme}{Print the table to the console? Default is
\code{TRUE}.}

\item{show.signif.stars}{Use stars to indicate z-statistics larger
than conventional thresholds. Default is \code{TRUE}.}

\item{show.pvals}{Instead of stars, use p-values to summarize the
information in the z-statistics. Default is \code{FALSE}.}

\item{horizontal}{Display the results for different candidate
stratifications side-by-side (Default, \code{TRUE}), or as a
list for each stratification (\code{FALSE}).}

\item{report}{What to report.}

\item{...}{Other arguements. Not currently used.}
}
\value{
\describe{
\item{vartable}{The formatted table of variable-by-variable
  statistics for each stratification.}
\item{overalltable}{If the overall Chi-squared statistic is
  requested, a formatted version of that table is returned.}
}
}
\description{
A \code{print} method for balance test objects produced by \code{xBalance} and \code{balanceTest}.
}
\examples{
data(nuclearplants)


xb1 <- balanceTest(pr ~ date + t1 + t2 + cap + ne + ct + bw + cum.n + strata(pt),
         data = nuclearplants)

print(xb1)

print(xb1, show.pvals = TRUE)

print(xb1, horizontal = FALSE)

## The following doesn't work yet.
\dontrun{print(xb1, which.vars=c("date","t1"),
         which.stats=c("adj.means","z.scores","p.values"))}

## The following example prints the adjusted means
## labeled as "treatmentvar=0" and "treatmentvar=1" using the
## formula provided to xBalance().

# This is erroring with the change to devtools, FIXME
\dontrun{print(xb1,
      which.vars = c("date", "t1"),
      which.stats = c("pr=0", "pr=1", "z", "p"))}

## Only printing out a specific stratification factor
xb2 <- balanceTest(pr~ date + t1 + t2 + cap + ne + ct + bw + cum.n + strata(pt),
         data = nuclearplants)

print(xb2, which.strata = "pt")
}
\seealso{
\code{\link{xBalance}}, \code{\link{balanceTest}}
}
\keyword{print}
