/*
 * Decompiled with CFR 0.152.
 */
package info.urbanek.Rpackage.RJDBC;

import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCResultPull {
    public static final int CT_STRING = 0;
    public static final int CT_NUMERIC = 1;
    public static final double NA_double = Double.longBitsToDouble(9218868437227407266L);
    ResultSet rs;
    int[] cTypes;
    Object[] data;
    int capacity;
    int count;
    int cols;

    public JDBCResultPull(ResultSet resultSet, int[] nArray) {
        this.rs = resultSet;
        this.cTypes = nArray;
        this.cols = nArray == null ? 0 : nArray.length;
        this.data = new Object[this.cols];
        this.capacity = -1;
        this.count = 0;
    }

    public int columns() {
        return this.cols;
    }

    public int count() {
        return this.count;
    }

    public void setCapacity(int n) {
        if (this.capacity != n) {
            for (int i = 0; i < this.cols; ++i) {
                this.data[i] = this.cTypes[i] == 1 ? new double[n] : (double[])new String[n];
            }
            this.capacity = n;
        }
    }

    public int fetch(int n, int n2) throws SQLException {
        this.setCapacity(n);
        if (n2 > 0) {
            try {
                this.rs.setFetchSize(n2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.count = 0;
        while (this.rs.next()) {
            for (int i = 0; i < this.cols; ++i) {
                if (this.cTypes[i] == 1) {
                    double d = this.rs.getDouble(i + 1);
                    if (this.rs.wasNull()) {
                        d = NA_double;
                    }
                    ((double[])this.data[i])[this.count] = d;
                    continue;
                }
                ((String[])this.data[i])[this.count] = this.rs.getString(i + 1);
            }
            ++this.count;
            if (this.count < this.capacity) continue;
            return this.count;
        }
        return this.count;
    }

    public Object getColumnData(int n) {
        return n > 0 && n <= this.cols ? this.data[n - 1] : null;
    }

    public String[] getStrings(int n) {
        String[] stringArray = (String[])this.data[n - 1];
        if (this.count == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[this.count];
        if (this.count > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, this.count);
        }
        return stringArray2;
    }

    public double[] getDoubles(int n) {
        double[] dArray = (double[])this.data[n - 1];
        if (this.count == dArray.length) {
            return dArray;
        }
        double[] dArray2 = new double[this.count];
        if (this.count > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, this.count);
        }
        return dArray2;
    }
}

