/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.eco.EcoException;

public class Determinant {
    private double m_detcar;
    private double m_detman = 1.0;

    public void add(double var) {
        this.update(var);
    }

    public void clear() {
        this.m_detman = 1.0;
        this.m_detcar = 0.0;
    }

    public double factor(int n) {
        double det = Math.pow(this.m_detman, 1.0 / (double)n);
        return det *= Math.pow(2.0, this.m_detcar / (double)n);
    }

    public double getLogDeterminant() {
        return Math.log(this.m_detman) + this.m_detcar * Math.log(2.0);
    }

    public void remove(double var) {
        this.update(1.0 / var);
    }

    private void update(double var) {
        if (Double.isInfinite(var) || Double.isNaN(var) || var <= 0.0) {
            throw new EcoException("det_err");
        }
        this.m_detman *= var;
        while (this.m_detman >= 1.0) {
            this.m_detman *= 0.0625;
            this.m_detcar += 4.0;
        }
        while (this.m_detman != 0.0 && this.m_detman <= 0.0625) {
            this.m_detman *= 16.0;
            this.m_detcar -= 4.0;
        }
    }
}

