/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;

public class MeanController
implements IPreprocessingModule {
    static final double CVAL0 = 1.96;
    static final double CVAL1 = 1.6;
    private final double cval_;

    public MeanController(double cval) {
        this.cval_ = cval;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        boolean nmean;
        ModelDescription desc = context.description;
        ModelEstimation est = context.estimation;
        boolean mean = desc.isMean();
        if (!mean) {
            desc = desc.clone();
            desc.setMean(true);
            est = null;
        }
        if (est == null) {
            IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
            RegArimaEstimator monitor = new RegArimaEstimator(mapping);
            est = new ModelEstimation(desc.buildRegArima(), desc.getLikelihoodCorrection());
            if (!est.compute(monitor, mapping.getDim())) {
                return ProcessingResult.Failed;
            }
        }
        double ser = est.getLikelihood().getBSer(0, false, 0);
        double mu = est.getLikelihood().getB()[0];
        double t = Math.abs(mu / ser);
        boolean bl = nmean = t > this.cval_;
        if (nmean == mean) {
            return ProcessingResult.Unchanged;
        }
        context.description.setMean(nmean);
        context.estimation = null;
        return ProcessingResult.Changed;
    }
}

