/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions.levmar;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;

public class DogLegMethod
implements ISsqFunctionMinimizer {
    static final int DEF_MAX_ITER = 20;
    static final double EPSILON = 1.0E-17;
    static final double DEF_STOP_THRESH = 1.0E-12;
    static final double DEF_LTRUSTED = 0.1;
    private int itmax = 20;
    private int iter = 0;
    private double eps1 = 1.0E-12;
    private double eps2 = 1.0E-12;
    private double eps2_sq = 1.0E-24;
    private double eps3 = 1.0E-12;
    private double ltrusted_ = 0.1;
    private double eps = 1.0E-5;
    private DataBlock g_;
    private ISsqFunction fn_;
    private ISsqFunctionInstance fcur_;
    private ISsqFunctionInstance ftry_;
    private DataBlock ecur_;
    private double Fcur_;
    private double Ftry_;
    private Matrix J;
    private Matrix JtJ;
    private double scale_;
    private double scale2_;
    private int stop;

    public boolean minimize(ISsqFunction fn, IReadDataBlock pstart) {
        return this.minimize(fn, fn.ssqEvaluate(pstart));
    }

    @Override
    public ISsqFunctionMinimizer exemplar() {
        DogLegMethod ex = new DogLegMethod();
        ex.eps = this.eps;
        ex.eps1 = this.eps1;
        ex.eps2 = this.eps2;
        ex.eps3 = this.eps3;
        ex.eps2_sq = this.eps2_sq;
        return ex;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.eps;
    }

    @Override
    public Matrix getCurvature() {
        if (this.JtJ == null) {
            this.fn_.getDerivatives(this.fcur_).getJacobian(this.J.subMatrix());
            this.JtJ = SymmetricMatrix.XtX(this.J);
        }
        return this.JtJ.times(2.0);
    }

    @Override
    public double[] getGradient() {
        return this.fn_.getDerivatives(this.fcur_).getGradient();
    }

    @Override
    public int getIterCount() {
        return this.iter;
    }

    @Override
    public int getMaxIter() {
        return this.itmax;
    }

    @Override
    public ISsqFunctionInstance getResult() {
        return this.fcur_;
    }

    @Override
    public double getObjective() {
        return this.Fcur_;
    }

    @Override
    public boolean minimize(ISsqFunction function, ISsqFunctionInstance start) {
        this.fn_ = function;
        this.fcur_ = start;
        return this.calc();
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.eps = value;
    }

    @Override
    public void setMaxIter(int n) {
        this.itmax = n;
    }

    private boolean iterate() {
        DataBlock np;
        if (!Double.isFinite(this.Fcur_)) {
            this.stop = 7;
            return false;
        }
        if (this.Fcur_ <= this.eps3 * this.scale2_) {
            this.stop = 6;
            return false;
        }
        this.fn_.getDerivatives(this.fcur_).getJacobian(this.J.subMatrix());
        this.JtJ = SymmetricMatrix.XtX(this.J);
        double jdiag_ninf = this.JtJ.diagonal().nrmInf();
        this.g_.product(this.J.columns(), this.ecur_);
        double ngInf = this.g_.nrmInf();
        if (ngInf <= this.eps * this.scale_) {
            this.stop = 1;
            return false;
        }
        double ng2 = this.g_.ssq();
        double ng = Math.sqrt(ng2);
        DataBlock hgn = null;
        DataBlock hsd = this.g_.deepClone();
        hsd.chs();
        DataBlock Jg = new DataBlock(this.J.getRowsCount());
        Jg.product(this.J.rows(), this.g_);
        double alpha = ng2 / Jg.ssq();
        DataBlock a = hsd.deepClone();
        a.mul(alpha);
        double na = a.nrm2();
        double k = 0.0;
        do {
            Matrix A = this.JtJ.clone();
            if (k == 0.0) {
                k = 1.0E-6 * jdiag_ninf;
            } else {
                A.diagonal().add(k);
                k *= 10.0;
            }
            try {
                SymmetricMatrix.lcholesky(A);
                hgn = this.g_.deepClone();
                LowerTriangularMatrix.rsolve(A, hgn);
                LowerTriangularMatrix.lsolve(A, hgn);
                hgn.chs();
            }
            catch (MatrixException err) {
                hgn = null;
            }
        } while (hgn == null && k < jdiag_ninf);
        if (hgn == null) {
            return false;
        }
        do {
            double dL;
            DataBlock hdl;
            double ro = 0.0;
            if (hgn.nrm2() <= this.ltrusted_) {
                hdl = hgn;
                dL = -this.g_.dot(hdl);
            } else if (na >= this.ltrusted_) {
                hdl = hsd.deepClone();
                hdl.mul(this.ltrusted_ / ng);
                dL = this.ltrusted_ * (2.0 * Math.abs(alpha) * ng - this.ltrusted_) / alpha;
            } else {
                DataBlock bma = hgn.deepClone();
                bma.sub(a);
                double c = a.dot(bma);
                double nbma = bma.ssq();
                double z0 = this.ltrusted_ * this.ltrusted_ - a.ssq();
                double z1 = Math.sqrt(c * c + nbma * z0);
                double beta = c <= 0.0 ? (-c + z1) / nbma : z0 / (c + z1);
                dL = alpha * (1.0 - beta) * (1.0 - beta) * ng + beta * (2.0 - beta) * this.Fcur_;
                hdl = a.deepClone();
                hdl.addAY(beta, bma);
            }
            if (!Double.isFinite(hdl.ssq())) {
                this.stop = 7;
                return false;
            }
            np = new DataBlock(this.fcur_.getParameters());
            if (hdl.ssq() <= this.eps2 * (np.ssq() + this.eps2)) {
                this.stop = 2;
                return false;
            }
            np.add(hdl);
            boolean solved = this.fn_.getDomain().checkBoundaries(np);
            boolean accepted = false;
            if (solved) {
                this.ftry_ = this.fn_.ssqEvaluate(np);
                this.Ftry_ = this.ftry_.getSsqE();
                double dF = this.Fcur_ - this.Ftry_;
                ro = dF / dL;
                if (dF > 0.0) {
                    accepted = true;
                    this.fcur_ = this.ftry_;
                    this.Fcur_ = this.Ftry_;
                    this.ecur_ = new DataBlock(this.fcur_.getE());
                }
            }
            if (accepted && ro > 0.75) {
                this.ltrusted_ = Math.max(this.ltrusted_, 3.0 * hdl.nrm2());
            } else if (!accepted || ro < 0.25) {
                this.ltrusted_ *= 0.5;
            }
            if (!accepted) continue;
            return true;
        } while (!(this.ltrusted_ <= this.eps * (np.nrm2() + this.eps2)));
        this.JtJ = null;
        return false;
    }

    private boolean calc() {
        this.iter = 0;
        this.ecur_ = new DataBlock(this.fcur_.getE());
        this.scale2_ = this.Fcur_ = this.fcur_.getSsqE();
        this.scale_ = Math.sqrt(this.Fcur_);
        this.ltrusted_ = 0.1;
        int n = this.ecur_.getLength();
        int m = this.fn_.getDomain().getDim();
        this.J = new Matrix(n, m);
        this.g_ = new DataBlock(m);
        while (this.iterate() && this.iter < this.itmax) {
            ++this.iter;
        }
        return this.stop != 7 && this.stop != 4;
    }
}

