/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFrequencyResponse;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.polynomials.AllSelector;
import ec.tstoolkit.maths.polynomials.IRootSelector;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.ucarima.SimpleModelDecomposer;

public class RootDecomposer
extends SimpleModelDecomposer {
    private IRootSelector m_selector;
    private BackFilter m_sur;
    private BackFilter m_nur;
    private BackFilter m_sar;
    private BackFilter m_nar;
    private SymmetricFilter m_sma;
    private SymmetricFilter m_sfds;
    private SymmetricFilter m_sfdn;
    private SymmetricFilter m_sfcs;
    private SymmetricFilter m_sfcn;

    public RootDecomposer() {
        this.m_selector = new AllSelector();
    }

    public RootDecomposer(IRootSelector sel) {
        this.m_selector = sel;
    }

    @Override
    protected void calc() {
        int i;
        int i2;
        int k;
        int j;
        int qn;
        if (this.m_model.isNull()) {
            this.m_s = new ArimaModel(null, null, null, 0.0);
            this.m_n = new ArimaModel(null, null, null, 0.0);
            return;
        }
        if (this.m_selector == null) {
            this.m_s = new ArimaModel(null, null, null, 0.0);
            this.m_n = this.m_model;
            return;
        }
        this.splitRoots();
        this.simplifyMA();
        if (!this.checkSpecialCases()) {
            return;
        }
        double[] n = this.m_sma.getCoefficients();
        double[] ds = this.m_sfds.getCoefficients();
        double[] dn = this.m_sfdn == null ? Polynomial.ONE.getCoefficients() : this.m_sfdn.getCoefficients();
        int q = n.length - 1;
        int p = ds.length + dn.length - 2;
        int ps = ds.length - 1;
        int pn = dn.length - 1;
        int qs = ps > 0 ? ps - 1 : 0;
        int n2 = qn = pn > 0 ? pn - 1 : 0;
        if (q >= p) {
            qn = q - ps;
        }
        int xs = qs + 1;
        int xn = qn + 1;
        int x = xs + xn;
        Matrix m = new Matrix(x, x);
        n[0] = n[0] / 2.0;
        ds[0] = ds[0] / 2.0;
        dn[0] = dn[0] / 2.0;
        for (j = 0; j <= qs; ++j) {
            for (k = 0; k <= pn; ++k) {
                m.set(j + k, j, dn[k]);
            }
        }
        for (j = 0; j <= qn; ++j) {
            for (k = 0; k <= ps; ++k) {
                m.set(j + k, j + xs, ds[k]);
            }
        }
        for (j = 0; j <= qs; ++j) {
            for (k = 0; k <= pn; ++k) {
                i2 = j - k;
                if (i2 < 0) {
                    i2 = -i2;
                }
                m.set(i2, j, m.get(i2, j) + dn[k]);
            }
        }
        for (j = 0; j <= qn; ++j) {
            for (k = 0; k <= ps; ++k) {
                i2 = j - k;
                if (i2 < 0) {
                    i2 = -i2;
                }
                m.set(i2, j + xs, m.get(i2, j + xs) + ds[k]);
            }
        }
        Householder qr = new Householder(false);
        qr.decompose(m);
        double[] sq = new double[x];
        for (i2 = 0; i2 <= q; ++i2) {
            sq[i2] = n[i2];
        }
        try {
            sq = qr.solve(sq);
        }
        catch (MatrixException e) {
            throw new RuntimeException(e);
        }
        double[] rcs = new double[xs];
        double[] rcn = new double[xn];
        for (i = 0; i < rcs.length; ++i) {
            rcs[i] = sq[i];
        }
        for (i = 0; i < rcn.length; ++i) {
            rcn[i] = sq[xs + i];
        }
        rcs[0] = rcs[0] * 2.0;
        rcn[0] = rcn[0] * 2.0;
        SymmetricFilter sma = SymmetricFilter.of(rcs);
        SymmetricFilter nma = SymmetricFilter.of(rcn);
        this.m_s = new ArimaModel(this.m_sar, this.m_sur, null, null, 0.0, this.m_sfcs != null ? this.m_sfcs.times(sma) : sma);
        this.m_n = new ArimaModel(this.m_nar, this.m_nur, null, null, 0.0, this.m_sfcn != null ? this.m_sfcn.times(nma) : nma);
    }

    private boolean checkSpecialCases() {
        if (this.m_sfds == null || this.m_sfds.getLength() <= 1) {
            this.m_s = new ArimaModel(null, this.m_sur, null, 0.0);
            this.m_n = new ArimaModel(this.m_nar, this.m_nur, this.m_sfcn != null ? this.m_sma.times(this.m_sfcn) : this.m_sma);
            return false;
        }
        return true;
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_sur = null;
        this.m_nur = null;
        this.m_sar = null;
        this.m_nar = null;
        this.m_sfds = null;
        this.m_sfdn = null;
        this.m_sfcs = null;
        this.m_sfcn = null;
        this.m_sma = null;
    }

    public IRootSelector getSelector() {
        return this.m_selector;
    }

    public void setSelector(IRootSelector value) {
        this.m_selector = value;
        this.clear();
    }

    private void simplifyMA() {
        this.m_sma = this.m_model.sma();
        SymmetricFrequencyResponse sfma = new SymmetricFrequencyResponse(this.m_sma);
        if (this.m_sur != null) {
            this.m_sfds = SymmetricFilter.createFromFilter(this.m_sur);
        }
        if (this.m_nur != null) {
            this.m_sfdn = SymmetricFilter.createFromFilter(this.m_nur);
        }
        if (this.m_sfcs != null || this.m_sfcn != null) {
            this.m_sma = sfma.toSymmetricFilter();
        }
        if (this.m_sar != null) {
            this.m_sfds = this.m_sfds != null ? this.m_sfds.times(SymmetricFilter.createFromFilter(this.m_sar)) : SymmetricFilter.createFromFilter(this.m_sar);
        }
        if (this.m_nar != null) {
            this.m_sfdn = this.m_sfdn != null ? this.m_sfdn.times(SymmetricFilter.createFromFilter(this.m_nar)) : SymmetricFilter.createFromFilter(this.m_nar);
        }
    }

    private void splitRoots() {
        this.m_selector.select(this.m_model.getStationaryAR().getPolynomial());
        this.m_sar = this.m_selector.getSelection() != null ? new BackFilter(this.m_selector.getSelection()) : BackFilter.ONE;
        this.m_nar = this.m_selector.getOutofSelection() != null ? new BackFilter(this.m_selector.getOutofSelection()) : BackFilter.ONE;
        this.m_selector.selectUnitRoots(this.m_model.getNonStationaryAR().getPolynomial());
        this.m_sur = this.m_selector.getSelection() != null ? new BackFilter(this.m_selector.getSelection()) : BackFilter.ONE;
        this.m_nur = this.m_selector.getOutofSelection() != null ? new BackFilter(this.m_selector.getOutofSelection()) : BackFilter.ONE;
    }
}

