/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CodelistParser {
    private static final String sourceClass = CodelistParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String CODELIST = "Codelist";
    static final String CODE = "Code";
    static final String ID = "id";
    static final String DESCRIPTION = "Name";

    public static Map<String, String> parse(Reader reader) throws XMLStreamException, SdmxException {
        return CodelistParser.parse(reader, CODELIST, CODE, ID, DESCRIPTION);
    }

    public static Map<String, String> parse(Reader reader, String string, String string2, String string3, String string4) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(reader);
        Map<String, String> map = CodelistParser.getCodes(xMLEventReader, string, string2, string3, string4);
        logger.exiting(sourceClass, "parse");
        return map;
    }

    public static Map<String, String> getCodes(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        return CodelistParser.getCodes(xMLEventReader, CODELIST, CODE, ID, DESCRIPTION);
    }

    public static Map<String, String> getCodes(XMLEventReader xMLEventReader, String string, String string2, String string3, String string4) throws XMLStreamException, SdmxException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string5 = null;
        LocalizedText localizedText = new LocalizedText(Configuration.getLang());
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (object.getName().getLocalPart() == string2) {
                    localizedText.clear();
                    string5 = null;
                    Iterator<Attribute> iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.getName().toString().equals(string3)) continue;
                        string5 = attribute.getValue();
                    }
                } else if (object.getName().getLocalPart() == string4) {
                    localizedText.setText((StartElement)object, xMLEventReader);
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            object = xMLEvent.asEndElement().getName().getLocalPart();
            if (((String)object).equals(string2)) {
                if (string5 != null) {
                    logger.finer("Got code " + string5 + ", " + localizedText.getText());
                    hashtable.put(string5, localizedText.getText());
                    continue;
                }
                throw new SdmxXmlContentException("Error during Codelist Parsing. Invalid code id: " + string5);
            }
            if (!((String)object).equals(string)) continue;
            break;
        }
        return hashtable;
    }
}

