/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.GenericSDMXClient;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.client.custom.FILE;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxUnknownProviderException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxProxySelector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.NavigableMap;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SDMXClientFactory {
    private static final String ECB_PROVIDER = "https://sdw-wsrest.ecb.europa.eu/service";
    private static final String ISTAT_PROVIDER = "http://sdmx.istat.it/SDMXWS/rest";
    private static final String ISTAT_PROVIDER_POP = "http://sdmx.istat.it/WS_CENSPOP/rest";
    private static final String ISTAT_PROVIDER_AGR = "http://sdmx.istat.it/WS_CENSAGR/rest";
    private static final String ISTAT_PROVIDER_IND = "http://sdmx.istat.it/WS_CIS/rest";
    private static final String INSEE_PROVIDER = "https://bdm.insee.fr/series/sdmx";
    private static final String UNDATA_PROVIDER = "http://data.un.org/WS/rest";
    private static final String WITS_PROVIDER = "http://wits.worldbank.org/API/V1/SDMX/V21/rest";
    private static final String INEGI_PROVIDER = "http://sdmx.snieg.mx/service/Rest";
    private static final String IMF_SDMX_CENTRAL_PROVIDER = "https://sdmxcentral.imf.org/ws/public/sdmxapi/rest";
    private static final String WB_PROVIDER = "https://api.worldbank.org/v2/sdmx/rest";
    private static final String sourceClass;
    protected static Logger logger;
    private static NavigableMap<String, Provider> providers;

    private static void initBuiltInProviders() throws SdmxException {
        SDMXClientFactory.addBuiltInProvider("ECB", ECB_PROVIDER, false, false, true, "European Central Bank", false);
        SDMXClientFactory.addBuiltInProvider("ISTAT", ISTAT_PROVIDER, false, false, false, "Italian National Institute of Statistics ", false);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_POP", ISTAT_PROVIDER_POP, false, false, false, "ISTAT - Population and housing census 2011", false);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_AGR", ISTAT_PROVIDER_AGR, false, false, false, "ISTAT - Agricultural census 2010", false);
        SDMXClientFactory.addBuiltInProvider("ISTAT_CENSUS_IND", ISTAT_PROVIDER_IND, false, false, false, "ISTAT - Industry and services census 2011", false);
        SDMXClientFactory.addBuiltInProvider("INSEE", INSEE_PROVIDER, false, false, true, "National Institute of Statistics and Economic Studies", false);
        SDMXClientFactory.addBuiltInProvider("UNDATA", UNDATA_PROVIDER, false, false, false, "Data access system to UN databases", false);
        SDMXClientFactory.addBuiltInProvider("WITS", WITS_PROVIDER, false, false, false, "World Integrated Trade Solutions", false);
        SDMXClientFactory.addBuiltInProvider("INEGI", INEGI_PROVIDER, false, false, false, "Instituto Nacional de Estadistica y Geografia", false);
        SDMXClientFactory.addBuiltInProvider("IMF_SDMX_CENTRAL", IMF_SDMX_CENTRAL_PROVIDER, false, false, true, "International Monetary Fund SDMX Central", false);
        SDMXClientFactory.addBuiltInProvider("WB", WB_PROVIDER, false, false, false, "World Bank - World Development Indicators", false);
        SDMXClientFactory.addBuiltInProvider("OECD", null, false, false, false, "The Organisation for Economic Co-operation and Development", true);
        SDMXClientFactory.addBuiltInProvider("OECD_RESTR", null, true, false, false, "The Organisation for Economic Co-operation and Development, RESTRICTED ACCESS", true);
        SDMXClientFactory.addBuiltInProvider("ILO", null, false, false, false, "International Labour Organization", true);
        SDMXClientFactory.addBuiltInProvider("IMF2", null, false, false, false, "New International Monetary Fund endpoint", true);
        SDMXClientFactory.addBuiltInProvider("ABS", null, false, false, false, "Australian Bureau of Statistics", true);
        SDMXClientFactory.addBuiltInProvider("NBB", null, false, false, false, "National Bank Belgium", true);
        SDMXClientFactory.addBuiltInProvider("UIS", null, false, false, false, "Unesco Institute for Statistics", true);
        SDMXClientFactory.addBuiltInProvider("EUROSTAT", null, false, false, false, "Eurostat", true);
        ServiceLoader<GenericSDMXClient> serviceLoader = ServiceLoader.load(GenericSDMXClient.class);
        for (GenericSDMXClient genericSDMXClient : serviceLoader) {
            SDMXClientFactory.addProvider(genericSDMXClient.getClass().getSimpleName(), null, null, genericSDMXClient.needsCredentials(), false, false, genericSDMXClient.getClass().getSimpleName(), true);
        }
    }

    private static void initExternalProviders() throws SdmxException {
        String string = Configuration.getExternalProviders();
        if (string != null && !string.isEmpty()) {
            String[] stringArray = string.trim().split("\\s*,\\s*");
            for (int i = 0; i < stringArray.length; ++i) {
                SDMXClientFactory.addExternalProvider(stringArray[i]);
            }
        }
    }

    public static void addProvider(String string, URI uRI, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4) throws SdmxException {
        Provider provider = new Provider(string, uRI, null, bl, bl2, bl3, string2, bl4);
        providers.put(string, provider);
    }

    public static void addProvider(String string, URI uRI, KeyStore keyStore, boolean bl, boolean bl2, boolean bl3, String string2, boolean bl4) throws SdmxException {
        Provider provider = new Provider(string, uRI, keyStore, bl, bl2, bl3, string2, bl4);
        providers.put(string, provider);
    }

    private static void addBuiltInProvider(String string, String string2, Boolean bl, Boolean bl2, Boolean bl3, String string3, boolean bl4) throws SdmxException {
        try {
            String string4 = Configuration.getConfiguration().getProperty("providers." + string + ".name", string);
            String string5 = Configuration.getConfiguration().getProperty("providers." + string + ".endpoint", string2);
            URI uRI = null != string5 ? new URI(string5) : null;
            boolean bl5 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsCredentials", bl.toString()));
            boolean bl6 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsURLEncoding", bl2.toString()));
            boolean bl7 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".supportsCompression", bl3.toString()));
            String string6 = Configuration.getConfiguration().getProperty("providers." + string + ".description", string3);
            SDMXClientFactory.addProvider(string4, uRI, null, bl5, bl6, bl7, string6, bl4);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.SEVERE, "Exception. Class: {0} .Message: {1}", new Object[]{uRISyntaxException.getClass().getName(), uRISyntaxException.getMessage()});
            logger.log(Level.FINER, "", uRISyntaxException);
        }
    }

    private static void addExternalProvider(String string) throws SdmxException {
        try {
            KeyStore keyStore;
            String string2;
            boolean bl;
            boolean bl2;
            boolean bl3;
            URI uRI;
            String string3 = Configuration.getConfiguration().getProperty("providers." + string + ".name", string);
            String string4 = Configuration.getConfiguration().getProperty("providers." + string + ".endpoint");
            if (string4 != null && !string4.isEmpty()) {
                uRI = new URI(string4);
                bl3 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsCredentials", "false"));
                bl2 = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".needsURLEncoding", "false"));
                bl = Boolean.parseBoolean(Configuration.getConfiguration().getProperty("providers." + string + ".supportsCompression", "false"));
                string2 = Configuration.getConfiguration().getProperty("providers." + string + ".description", string);
                String string5 = Configuration.getConfiguration().getProperty("providers." + string + ".trustStore", "");
                keyStore = null;
                if (!"".equals(string5)) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(new File(string5));
                        keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        keyStore.load(fileInputStream, "changeit".toCharArray());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        logger.warning("Cannot open trust store at " + string5);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        generalSecurityException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        throw SdmxExceptionFactory.wrap(iOException);
                    }
                    finally {
                        keyStore = null;
                    }
                }
            } else {
                logger.warning("No URL has been configured for the external provider: '" + string + "'. It will be skipped.");
                return;
            }
            SDMXClientFactory.addProvider(string3, uRI, keyStore, bl3, bl2, bl, string2, false);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.log(Level.SEVERE, "Exception. Class: {0} .Message: {1}", new Object[]{uRISyntaxException.getClass().getName(), uRISyntaxException.getMessage()});
            logger.log(Level.FINER, "", uRISyntaxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GenericSDMXClient createClient(String string) throws SdmxException {
        Object object;
        logger.entering(sourceClass, "createClient");
        logger.fine("Create an SDMX client for '" + string + "'");
        GenericSDMXClient genericSDMXClient = null;
        Provider provider = (Provider)providers.get(string);
        String string2 = null;
        String string3 = "The provider '" + string + "' is not available in this configuration.";
        if (provider != null && !provider.isCustom()) {
            string2 = provider.getEndpoint().getHost();
            if (provider.getEndpoint().getScheme().toLowerCase().startsWith("http")) {
                genericSDMXClient = new RestSdmxClient(provider.getName(), provider.getEndpoint(), provider.getSSLSocketFactory(), provider.isNeedsCredentials(), provider.isNeedsURLEncoding(), provider.isSupportsCompression());
            } else {
                if (!provider.getEndpoint().getScheme().toLowerCase().equals("file")) {
                    logger.severe("The protocol '" + provider.getEndpoint().getScheme() + "' is not supported.");
                    throw new SdmxInvalidParameterException(string3);
                }
                genericSDMXClient = new FILE(provider.getName(), provider.getEndpoint());
            }
        } else {
            try {
                object = Class.forName("it.bancaditalia.oss.sdmx.client.custom." + string);
                genericSDMXClient = (GenericSDMXClient)((Class)object).newInstance();
                if (provider.getEndpoint() != null) {
                    genericSDMXClient.setEndpoint(provider.getEndpoint());
                }
                if (genericSDMXClient.getEndpoint() != null) {
                    string2 = genericSDMXClient.getEndpoint().getHost();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.severe("The provider '" + string + "' is not available in this configuration.");
                throw new SdmxUnknownProviderException(string, classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.severe("The provider implementation it.bancaditalia.oss.sdmx.client.custom." + string + " does not define a default constructor.");
                throw new SdmxUnknownProviderException(string, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.severe("Could not instantiate provider implementation it.bancaditalia.oss.sdmx.client.custom." + string);
                throw new SdmxUnknownProviderException(string, instantiationException);
            }
        }
        object = ProxySelector.getDefault();
        if (string2 != null && object != null && object instanceof SdmxProxySelector) {
            ((SdmxProxySelector)object).addToDefaultProxy(string2);
        }
        logger.exiting(sourceClass, "createClient");
        return genericSDMXClient;
    }

    public static NavigableMap<String, Provider> getProviders() {
        return providers;
    }

    static {
        providers = new TreeMap<String, Provider>();
        logger = Configuration.getSdmxLogger();
        try {
            SDMXClientFactory.initBuiltInProviders();
            SDMXClientFactory.initExternalProviders();
        }
        catch (SdmxException sdmxException) {
            sdmxException.printStackTrace();
        }
        sourceClass = SDMXClientFactory.class.getSimpleName();
    }
}

