% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerTable.R
\name{SsPowerTable}
\alias{SsPowerTable}
\title{Generate a power table}
\usage{
SsPowerTable(
  dataset,
  FOM,
  effectSize = NULL,
  alpha = 0.05,
  desiredPower = 0.8,
  method = "DBMH",
  option = "ALL"
)
}
\arguments{
\item{dataset}{The \bold{pilot} ROC dataset to be used to extrapolate 
to the \bold{pivotal} study.}

\item{FOM}{The figure of merit.}

\item{effectSize}{The effect size to be used in the \bold{pivotal} study, 
default value is \code{NULL}. See Details.}

\item{alpha}{The The size of the test, default is 0.05.}

\item{desiredPower}{The desired statistical power, default is 0.8.}

\item{method}{Analysis method, "DBMH" or "ORH", the default is "DBMH".}

\item{option}{Desired generalization, "RRRC", "FRRC", "RRFC" or "ALL" (the default).}
}
\value{
A list containing up to 3 (depending on \code{options}) dataframes. 
    Each dataframe contains 3 arrays:

\item{numReaders}{The numbers of readers in the pivotal study.}

\item{numCases}{The numbers of cases in the pivotal study.}

\item{power}{The estimated statistical powers.}
}
\description{
Generate combinations of numbers of readers J and numbers of cases K
   for desired power and specified generalization(s)
}
\details{
The default \code{effectSize} uses the observed effect size in the 
   pilot study. A numeric value over-rides the default value.
}
\note{
The procedure is valid for ROC studies only; for FROC studies see Online Appendix Chapter 19.
}
\examples{
\donttest{
## Examples with CPU or elapsed time > 5s
##              user    system elapsed
## SsPowerTable 20.033  0.037  20.077    

## Example of sample size calculation with DBM method
SsPowerTable(dataset02, FOM = "Wilcoxon", method = "DBMH")

## Example of sample size calculation with OR method
SsPowerTable(dataset02, FOM = "Wilcoxon", method = "ORH")
}
 
}
