% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTestingCrossedModalities.R
\name{StSignificanceTestingCrossedModalities}
\alias{StSignificanceTestingCrossedModalities}
\title{Perform significance testing using crossed treatments analysis}
\usage{
StSignificanceTestingCrossedModalities(
  ds,
  avgIndx,
  FOM = "wAFROC",
  alpha = 0.05,
  analysisOption = "ALL"
)
}
\arguments{
\item{ds}{The crossed treatments dataset}

\item{avgIndx}{The index of the treatment to be averaged over}

\item{FOM}{See \code{\link{StSignificanceTesting}}}

\item{alpha}{See \code{\link{StSignificanceTesting}}}

\item{analysisOption}{See \code{\link{StSignificanceTesting}}}
}
\value{
The return list contains the same items with \code{\link{StSignificanceTesting}}.
}
\description{
Performs ORH analysis for specified crossed treatments dataset 
   averaged over specified treatment factor
}
\examples{
\donttest{ 
## read the raw data file in extdata directory (this is included to illustrate the format)
crossedFileName <- system.file("extdata", "CrossedModalities.xlsx", 
package = "RJafroc", mustWork = TRUE)
ds <- DfReadCrossedModalities(crossedFileName)
retCrossed1 <- StSignificanceTestingCrossedModalities(ds, 1)

## read the built in dataset
retCrossed2 <- StSignificanceTestingCrossedModalities(datasetCrossedModality, 1)
}

}
