% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChisqrGoodnessOfFit.R
\name{ChisqrGoodnessOfFit}
\alias{ChisqrGoodnessOfFit}
\title{Compute the chisquare goodness of fit statistic for ROC fitting model}
\usage{
ChisqrGoodnessOfFit(fpCounts, tpCounts, parameters, model, lesDistr)
}
\arguments{
\item{fpCounts}{The FP counts table}

\item{tpCounts}{The TP counts table}

\item{parameters}{The parameters of the model including cutoffs, see details}

\item{model}{The fitting model: "BINORMAL", "CBM" or "RSM}

\item{lesDistr}{The lesion distribution matrix; not needed for "BINORMAL" 
or "CBM" models. Array [1:maxLL,1:2]. The probability mass function of the 
lesion distribution for diseased cases. The first column contains the 
actual numbers of lesions per case. 
The second column contains the fraction of diseased cases with the number 
of lesions specified in the first column. 
The second column must sum to unity.}
}
\value{
The return value is a list with the following elements:

\item{chisq}{The chi-square statistic}

\item{pVal}{The p-value of the fit}

\item{df}{The degrees of freedom}
}
\description{
Compute the chisquare goodness of fit statistic for specified ROC data fitting model
}
\details{
For model = "BINORMAL" the parameters are c(a,b,zetas).
For model = "CBM" the parameters are c(mu,alpha,zetas).
For model = "RSM" the parameters are c(mu,lambdaP,nuP,zetas).
Due to the sparsity of the data, in most cases the goodness of fit statistic 
cannot be calculated as the criterion of at least 5 counts in each
cell (TP and FP) is usually not met. An exception dataset is shown below.
}
\examples{
## Test with TONY data for which chisqr can be calculated
ds <- DfFroc2Roc(dataset01)
fit <- FitBinormalRoc(ds, 2, 3) # trt 2 and rdr 3
## fitted a,b and zeta parameters from preceding line were used to call the
## function as shown below:
fpCounts = c(119,  30,   9,  19,   7,   1)
tpCounts = c(10, 11,  7, 16, 29, 16)
gfit = ChisqrGoodnessOfFit(fpCounts, tpCounts, 
parameters = c(fit$a, fit$b, fit$zetas), model="BINORMAL") 
gfit



}
