% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilOR2DBMVarCom.R
\name{UtilOR2DBMVarCom}
\alias{UtilOR2DBMVarCom}
\title{Convert from OR to DBM variance components}
\usage{
UtilOR2DBMVarCom(K, ORVarCom)
}
\arguments{
\item{K}{Total number of cases}

\item{ORVarCom}{OR variance components, a data.frame 
containing VarR, VarTR, Cov1, Cov2, Cov3 and Var}
}
\value{
\code{UtilOR2DBMVarCom} returns the equivalent DBM variance components
}
\description{
\code{UtilOR2DBMVarCom} converts from OR to DBM variance components.
}
\examples{
DBMVarCom <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "DBM")$ANOVA$VarCom
UtilDBM2ORVarCom(114, DBMVarCom)

ORVarCom <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "OR")$ANOVA$VarCom
UtilOR2DBMVarCom(114, ORVarCom)



}
