/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLFBRuleReasoner
extends FBRuleReasoner {
    protected static final String RULE_FILE = "etc/owl-fb.rules";
    protected static List ruleSet;
    protected static FBRuleInfGraph staticPreload;
    protected static Log logger;

    public OWLFBRuleReasoner(ReasonerFactory factory) {
        super(OWLFBRuleReasoner.loadRules(), factory);
    }

    private OWLFBRuleReasoner(OWLFBRuleReasoner parent, InfGraph schemaGraph) {
        super(parent.rules, schemaGraph, parent.factory);
    }

    public static List loadRules() {
        if (ruleSet == null) {
            ruleSet = OWLFBRuleReasoner.loadRules(RULE_FILE);
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        this.checkArgGraph(tbox);
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph(this, this.rules, this.getPreload(), tbox);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.prepare();
        return new OWLFBRuleReasoner(this, graph);
    }

    public InfGraph bind(Graph data) throws ReasonerException {
        this.checkArgGraph(data);
        FBRuleInfGraph graph = null;
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        List baseRules = ((FBRuleInfGraph)schemaArg).getRules();
        graph = new FBRuleInfGraph(this, baseRules, schemaArg);
        graph.addPreprocessingHook(new OWLRuleTranslationHook());
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfGraph getPreload() {
        Class clazz = OWLFBRuleReasoner.class;
        synchronized (clazz) {
            if (staticPreload == null) {
                boolean prior = JenaParameters.enableFilteringOfHiddenInfNodes;
                try {
                    JenaParameters.enableFilteringOfHiddenInfNodes = true;
                    staticPreload = new FBRuleInfGraph(this, this.rules, null);
                    staticPreload.prepare();
                }
                finally {
                    JenaParameters.enableFilteringOfHiddenInfNodes = prior;
                }
            }
            return staticPreload;
        }
    }

    private void checkArgGraph(Graph g) {
        if (JenaParameters.enableOWLRuleOverOWLRuleWarnings && g instanceof InfGraph && ((InfGraph)g).getReasoner() instanceof OWLFBRuleReasoner) {
            logger.warn((Object)"Creating OWL rule reasoner working over another OWL rule reasoner");
        }
    }

    static {
        logger = LogFactory.getLog((Class)OWLFBRuleReasoner.class);
    }
}

