% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocation_rule.R
\name{AllocationRule}
\alias{AllocationRule}
\title{Allocation Rule Class}
\description{
This class represents an allocation rule that generates a next allocation.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{policy}}{The RLlib policy that is a Python object.}

\item{\code{dir}}{Directory path of the allocation rule (policy).}

\item{\code{dirpath}}{Full path to the directory of the allocation rule.}

\item{\code{created_at}}{Created time of this object.}

\item{\code{info}}{Information when learning the allocation rule.}

\item{\code{input}}{Inputs for learning the allocation rule.}

\item{\code{log}}{The log of scores during the learning of the allocation rule.}

\item{\code{checkpoints}}{The integer vector of iteration counts for checkpoints.}

\item{\code{checkpoints_paths}}{The paths to the directories where each checkpoint is stored.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AllocationRule-new}{\code{AllocationRule$new()}}
\item \href{#method-AllocationRule-opt_allocation_probs}{\code{AllocationRule$opt_allocation_probs()}}
\item \href{#method-AllocationRule-resume_learning}{\code{AllocationRule$resume_learning()}}
\item \href{#method-AllocationRule-set_info}{\code{AllocationRule$set_info()}}
\item \href{#method-AllocationRule-print}{\code{AllocationRule$print()}}
\item \href{#method-AllocationRule-clone}{\code{AllocationRule$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-new"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-new}{}}}
\subsection{Method \code{new()}}{
Create a new AllocationRule object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$new(dir = "latest", base_dir = "allocation_rules")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{A character value. A directory name or path where an
allocation rule is outputted. By default, the latest allocation
rule is searched in 'base_dir'.}

\item{\code{base_dir}}{A character value. A directory path that is used as the
parent directory if the 'dir' argument is a directory name and is
not used otherwise.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-opt_allocation_probs"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-opt_allocation_probs}{}}}
\subsection{Method \code{opt_allocation_probs()}}{
Compute optimal allocation probabilities using the obtained allocation rule for dose and response data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$opt_allocation_probs(data_doses, data_resps)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_doses}}{A numeric vector. The doses actually administered to each
subject in your clinical trial. It must include all previous
doses.}

\item{\code{data_resps}}{A numeric vector. The values of responses corresponding to
each subject for the 'data_doses' argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of the probabilities of the doses.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-resume_learning"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-resume_learning}{}}}
\subsection{Method \code{resume_learning()}}{
Resume learning the allocation rule. This function updates the original
AllocationRule object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$resume_learning(iter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iter}}{A number of additional iterations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An updated \link{AllocationRule} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-set_info"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-set_info}{}}}
\subsection{Method \code{set_info()}}{
Set information when learning the allocation rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$set_info(info, input, log, checkpoints)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{info}}{Information when learning the allocation rule.}

\item{\code{input}}{Inputs for learning the allocation rule.}

\item{\code{log}}{The log of scores during the learning of the allocation rule.}

\item{\code{checkpoints}}{The paths to the directories where each checkpoint is stored.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-print"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-print}{}}}
\subsection{Method \code{print()}}{
Print function for AllocationRule object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AllocationRule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AllocationRule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AllocationRule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
