% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMixtComp-package.R
\docType{package}
\name{RMixtComp-package}
\alias{RMixtComp-package}
\title{RMixtComp}
\description{
MixtComp (Mixture Composer, \url{https://github.com/modal-inria/MixtComp}) is a model-based clustering package for mixed data.

It has been engineered around the idea of easy and quick integration of all new univariate models, under the conditional independence assumption. 
Five basic models (Gaussian, Multinomial, Poisson, Weibull, NegativeBinomial) are implemented, as well as two advanced models (Func_CS and Rank_ISR).
MixtComp has the ability to natively manage missing data (completely or by interval).

Online SaaS version (not up-to-date): \url{https://massiccc.lille.inria.fr/}
}
\details{
Main functions are \link{mixtCompLearn} for clustering, \link{mixtCompPredict} for predicting the cluster of new samples with a model learnt with \link{mixtCompLearn}. 
\link{createAlgo} gives you default values for required parameters.

Read the help page of \link{mixtCompLearn} for available models and data format. A summary of these information can be accessed with the function \link{availableModels}.

All utility functions (getters, graphical) are in the \code{RMixtCompUtilities} package.

In order to have an overview of the output, you can use \link{print.MixtCompLearn}, \link{summary.MixtCompLearn} and \link{plot.MixtCompLearn} functions,

Getters are available to easily access some results (see. \link{mixtCompLearn} for output format): \link{getBIC}, \link{getICL}, \link{getCompletedData}, \link{getParam},
 \link{getTik}, \link{getEmpiricTik}, \link{getPartition}, \link{getType}, \link{getModel}, \link{getVarNames}.


You can compute discriminative powers and similarities with functions: \link{computeDiscrimPowerClass}, \link{computeDiscrimPowerVar}, \link{computeSimilarityClass}, \link{computeSimilarityVar}.

Graphics functions are \link{plot.MixtComp}, \link{plot.MixtCompLearn}, \link{heatmapClass}, \link{heatmapTikSorted}, \link{heatmapVar}, \link{histMisclassif}, \link{plotConvergence}, 
\link{plotDataBoxplot}, \link{plotDataCI}, \link{plotDiscrimClass}, \link{plotDiscrimVar}, \link{plotProportion}, \link{plotCrit}.

Datasets with running examples are provided: \link{titanic}, \link{CanadianWeather}, \link{prostate}, \link{simData}.
}
\examples{
data(simData)
 
# define the algorithm's parameters: you can use createAlgo function
algo <- list(nbBurnInIter = 100,
             nbIter = 100,
             nbGibbsBurnInIter = 50,
             nbGibbsIter = 50,
             nInitPerClass = 10,
             nSemTry = 20,
             confidenceLevel = 0.95)

# run RMixtComp for learning using only 3 variables
resLearn <- mixtCompLearn(simData$dataLearn$matrix, simData$model$unsupervised[1:3], algo,
                          nClass = 2:4)

summary(resLearn)
plot(resLearn)

# run RMixtComp for predicting
resPred <- mixtCompPredict(simData$dataPredict$matrix, simData$model$unsupervised[1:3], algo,
                           resLearn)

partitionPred <- getPartition(resPred)
print(resPred)


}
\seealso{
\code{\link{mixtCompLearn}} \code{\link{availableModels}} \code{RMixtCompUtilities}, \code{RMixtCompIO}. Other clustering packages: \code{Rmixmod}, \code{blockcluster}
}
\keyword{package}
