% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{plot_sample_clustering}
\alias{plot_sample_clustering}
\title{Plot clustering of samples in a distance heatmap}
\usage{
plot_sample_clustering(
  vsd,
  n_feats = 500,
  anno_vars = NULL,
  distance = "euclidean"
)
}
\arguments{
\item{vsd}{An object generated by \code{DESeq2::vst()}}

\item{n_feats}{Number of top-variable features (genes) to consider}

\item{anno_vars}{Character vector of columns in \code{colData(vsd)} to annotate samples}

\item{distance}{The type of distance metric to consider. Either 'euclidean', 'pearson' or 'spearman'}
}
\value{
A Heatmap-class object of the \code{ComplexHeatmap} package that contains the heatmap of pairwise sample distances.
}
\description{
Plot clustering of samples in a distance heatmap
}
\examples{
library("DESeq2")
dds <- makeExampleDESeqDataSet(m=8, interceptMean=10)
vsd <- vst(dds)
plot_sample_clustering(vsd)

}
