% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{show_window}
\alias{show_window}
\title{Show time window of document pairs}
\usage{
show_window(g, to_attribute = NULL, from_attribute = NULL)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow.compare} or \link[RNewsflow]{document.network}}

\item{to_attribute}{The vertex attribute to aggregate the `to` group of the edges}

\item{from_attribute}{The vertex attribute to aggregate the `from` group of the edges}
}
\value{
A data.frame showing the left and right edges of the window for each unique group.
}
\description{
This function aggregates the edges for all combinations of attributes specified in `from_attribute` and `to_attribute`, and shows the minimum and maximum hour difference for each combination.
}
\details{
The \link[RNewsflow]{filter.window} function can be used to filter edges that fall outside of the intended time window.
}
\examples{
data(docnet)
show_window(docnet, to_attribute = 'source')
show_window(docnet, to_attribute = 'sourcetype')
show_window(docnet, to_attribute = 'sourcetype', from_attribute = 'sourcetype')
}
