% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{niftiVersion}
\alias{niftiVersion}
\title{Check the format version of a file}
\usage{
niftiVersion(file)
}
\arguments{
\item{file}{A character vector of file names.}
}
\value{
A vector of integers, of the same length as \code{file}. Each
  element will be 0 for ANALYZE format (the precursor to NIfTI-1), 1 for
  NIfTI-1 (which is now most common), 2 for NIfTI-2, or -1 if the file
  doesn't exist or doesn't look plausible in any of these formats.
}
\description{
This function identifies the likely NIfTI format variant used by one or more
files on disk.
}
\note{
NIfTI-2 format, mostly a variant of NIfTI-1 with wider datatypes used
  for many fields, is not currently supported for reading, but it is
  detected by this function.
}
\examples{
path <- system.file("extdata", "example.nii.gz", package="RNifti")
niftiVersion(path)       # 1

}
\seealso{
\code{\link{readNifti}}
}
\author{
Jon Clayden <code@clayden.org>
}
