\name{Manage connections}
\alias{db.connect}
\alias{db.disconnect}
\alias{db.connection.status}
\alias{db.connection.open}
\alias{db.error.message}
\alias{db.name}
\alias{db.host.name}
\title{Open and manage database connection}
\usage{
db.connect(host=NULL, port=NULL, dbname=NULL, user=NULL, password=NULL,
authtype=NULL, options=NULL, tty=NULL, verbose=T)
db.disconnect()
db.connection.status()
db.connection.open()
db.error.message()
db.name()
db.host.name()
}
\arguments{
 \item{host}{postgres server host name}
 \item{port}{postgres server port number}
 \item{dbname}{database name}
 \item{user}{database user name}
 \item{password}{user password}
 \item{authtype}{authentication type}
 \item{options}{additional postgres options}
 \item{tty}{debugging tty}
 \item{verbose}{report some information}
}
\description{
  \code{db.connect} establishes a connection between RPgSQL and a
  PostgreSQL server.\cr
  \code{db.disconnect} terminates a database connection.\cr
  \code{db.connection.status} returns the current connection status.\cr
  \code{db.connection.open} is used to check whether a connection is
  open.\cr
  \code{db.error.message} returns the error message most recently
  generated by an operation on the connection.\cr
  \code{db.name} returns the current database name.\cr
  \code{db.host.name} return the name of the database host.
}
\details{
  Currently, \code{db.connect} does not return a  handle, so you can
  only open a single connection at a time.
}
\value{
  \code{db.connection.status} returns a non-zero number indicates an
  error.  See the PostgreSQL documentation for a description of the
  specific return values for different types of
  errors.\cr
  \code{db.connection.open} returns boolean indicating whether
  there is currently an open connection.\cr
  \code{db.error.message} returns string with the most recent error
  message from the server.\cr
  \code{db.name} returns the name of the current database.\cr
  \code{db.host.name} returns he name of the database server host
  associated with the current connection.
}
\notes{
  Default values for all of the arguments to \code{db.connect} can be
  set using the following environment variables:
  
  PGHOST sets the default server name. If a non-zero-length string is
  specified, TCP/IP communication is used. Without a host name, libpq will
  connect using a local Unix domain socket.

  PGPORT sets the default port or local Unix domain socket file
  extension for communicating with the Postgres backend.

  PGDATABASE sets the default Postgres database name.

  PGUSER sets the username used to connect to the database and for
  authentication.

  PGPASSWORD sets the password used if the backend demands password
  authentication.

  PGOPTIONS sets additional runtime options for the Postgres backend.
}
\author{Timothy H. Keitt}
\keyword{database}
