% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Redshift.R
\docType{class}
\name{Redshift}
\alias{Redshift}
\alias{RedshiftDriver-class}
\alias{RedshiftConnection-class}
\alias{dbConnect,RedshiftDriver-method}
\title{Redshift driver/connection}
\usage{
Redshift()

\S4method{dbConnect}{RedshiftDriver}(
  drv,
  dbname = NULL,
  host = NULL,
  port = NULL,
  password = NULL,
  user = NULL,
  service = NULL,
  ...,
  bigint = c("integer64", "integer", "numeric", "character"),
  check_interrupts = FALSE,
  timezone = "UTC"
)
}
\arguments{
\item{drv}{Should be set to \code{\link[=Postgres]{Postgres()}}
to use the \pkg{RPostgres} package.}

\item{dbname}{Database name. If \code{NULL}, defaults to the user name.
Note that this argument can only contain the database name, it will not
be parsed as a connection string (internally, \code{expand_dbname} is set to
\code{false} in the call to
\href{https://www.postgresql.org/docs/current/libpq-connect.html}{\code{PQconnectdbParams()}}).}

\item{host}{Host and port. If \code{NULL}, will be retrieved from
\code{PGHOST} and \code{PGPORT} env vars.}

\item{port}{Host and port. If \code{NULL}, will be retrieved from
\code{PGHOST} and \code{PGPORT} env vars.}

\item{password}{User name and password. If \code{NULL}, will be
retrieved from \code{PGUSER} and \code{PGPASSWORD} envvars, or from the
appropriate line in \verb{~/.pgpass}. See
\url{https://www.postgresql.org/docs/current/libpq-pgpass.html} for
more details.}

\item{user}{User name and password. If \code{NULL}, will be
retrieved from \code{PGUSER} and \code{PGPASSWORD} envvars, or from the
appropriate line in \verb{~/.pgpass}. See
\url{https://www.postgresql.org/docs/current/libpq-pgpass.html} for
more details.}

\item{service}{Name of service to connect as.  If \code{NULL}, will be
ignored.  Otherwise, connection parameters will be loaded from the pg_service.conf
file and used.  See \url{https://www.postgresql.org/docs/current/libpq-pgservice.html}
for details on this file and syntax.}

\item{...}{Other name-value pairs that describe additional connection
options as described at
\url{https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-PARAMKEYWORDS}}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{check_interrupts}{Should user interrupts be checked during the query execution (before
first row of data is available)? Setting to \code{TRUE} allows interruption of queries
running too long.}

\item{timezone}{Sets the timezone for the connection. The default is \code{"UTC"}.
If \code{NULL} then no timezone is set, which defaults to the server's time zone.}
}
\description{
Use \code{Redshift()} instead of \code{Postgres()} to connect to an AWS Redshift cluster.
All methods in \pkg{RPostgres} and downstream packages can be called on such connections.
Some have different behavior for Redshift connections, to ensure better interoperability.
}
