% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr-src.R
\name{src_presto}
\alias{src_presto}
\title{dplyr integration to connect to a Presto database.}
\usage{
src_presto(
  catalog = NULL,
  schema = NULL,
  user = NULL,
  host = NULL,
  port = NULL,
  source = NULL,
  session.timezone = NULL,
  parameters = NULL,
  bigint = c("integer", "integer64", "numeric", "character"),
  con = NULL,
  ...
)
}
\arguments{
\item{catalog}{Catalog to use in the connection}

\item{schema}{Schema to use in the connection}

\item{user}{User name to use in the connection}

\item{host}{Host name to connect to the database}

\item{port}{Port number to use with the host name}

\item{source}{Source to specify for the connection}

\item{session.timezone}{Time zone for the connection}

\item{parameters}{Additional parameters to pass to the connection}

\item{bigint}{The R type that Presto's 64-bit integer (\code{BIGINT}) types should
be translated to. The default is \code{"integer"}, which returns R's
\code{integer} type, but results in \code{NA} for values above/below
+/-2147483647. \code{"integer64"} returns a \link[bit64:bit64-package]{bit64::integer64}, which
allows the full range of 64 bit integers. \code{"numeric"} coerces into
R's \code{double} type but might result in precision loss. Lastly,
\code{"character"} casts into R's \code{character} type.}

\item{con}{An object that inherits from \linkS4class{PrestoConnection},
typically generated by \link[DBI:dbConnect]{DBI::dbConnect}. When a valid connection
object is supplied, Other arguments are ignored.}

\item{...}{For \code{src_presto} other arguments passed on to the underlying
database connector \code{dbConnect}. For \code{tbl.src_presto}, it is
included for compatibility with the generic, but otherwise ignored.}
}
\description{
Allows you to connect to an existing database through a presto connection.
}
\examples{
\dontrun{
# To connect to a database
my_db <- src_presto(
  catalog = "memory",
  schema = "default",
  user = Sys.getenv("USER"),
  host = "http://localhost",
  port = 8080,
  session.timezone = "Asia/Kathmandu"
)
# Use a PrestoConnection
my_con <- DBI::dbConnect(
  catalog = "memory",
  schema = "default",
  user = Sys.getenv("USER"),
  host = "http://localhost",
  port = 8080,
  session.timezone = "Asia/Kathmandu"
)
my_db2 <- src_presto(con = my_con)
}
}
