% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{qgis_session_info}
\alias{qgis_session_info}
\title{QGIS session info}
\usage{
qgis_session_info(qgis_env = set_env())
}
\arguments{
\item{qgis_env}{Environment settings containing all the paths to run the QGIS
API. For more information, refer to \code{\link{set_env}}.}
}
\value{
The function returns a list with following elements:
\enumerate{
 \item{qgis_version: Name and version of QGIS used by RQGIS.}
 \item{grass6: GRASS 6 version number. Under Linux, the function only checks if
 GRASS 6 modules can be executed, therefore it simply returns TRUE instead of
 a version number.}
 \item{grass7: GRASS 7 version number. Under Linux, the function only checks if
 GRASS 6 modules can be executed, therefore it simply returns TRUE instead of
 a version number}
 \item{saga: The installed SAGA version used by QGIS.}
 \item{supported_saga_versions: character vector representing the SAGA
 versions supported by the QGIS installation.}
}
}
\description{
\code{qgis_session_info} reports the version of QGIS and
  installed third-party providers (so far GRASS 6, GRASS 7, and SAGA). 
  Additionally, it figures out with which SAGA versions the QGIS installation
  is compatible.
}
\examples{
\dontrun{
qgis_session_info()
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

