% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{exp_Ct_dCt}
\alias{exp_Ct_dCt}
\title{exp_Ct_dCt}
\usage{
exp_Ct_dCt(data, save.to.txt = FALSE, name.txt = "data_exp_Ct_dCt")
}
\arguments{
\item{data}{Data object returned from make_Ct_ready() or delta_Ct() functions.}

\item{save.to.txt}{Logical: if TRUE, returned data will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "data_exp_Ct_dCt".}
}
\value{
Data frame with exponentiated Ct or dCt values.
}
\description{
This function exponentiates Ct and delta Ct (dCt) values by using 2^-Ct and 2^-dCt formulas, respectively.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.Ct.exp <- exp_Ct_dCt(data.CtF.ready)
head(data.Ct.exp)

}
