% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{FCh_plot}
\alias{FCh_plot}
\title{FCh_plot}
\usage{
FCh_plot(
  data,
  use.p = TRUE,
  mode,
  p.threshold = 0.05,
  use.FCh = FALSE,
  FCh.threshold = 2,
  use.sd = FALSE,
  sel.Gene = "all",
  bar.width = 0.8,
  signif.show = FALSE,
  signif.labels,
  signif.length = 0.2,
  signif.dist = 0.5,
  y.exp.low = 0.1,
  y.exp.up = 0.1,
  angle = 0,
  rotate = FALSE,
  colors = c("#66c2a5", "#fc8d62"),
  border.color = "black",
  x.axis.title = "",
  y.axis.title = "log10(Fold change)",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title = "Selected as significant?",
  legend.title.size = 11,
  legend.position = "top",
  plot.title = "",
  plot.title.size = 14,
  dpi = 600,
  width = 15,
  height = 15,
  save.to.tiff = FALSE,
  name.tiff = "FCh_plot"
)
}
\arguments{
\item{data}{Object returned from RQ_dCt() or RQ_ddCt() functions.}

\item{use.p}{Logical: if TRUE, p value threshold will be used to label gene as significant.}

\item{mode}{Character: which p value should be used? One of the "t" (p values from Student's t test), "t.adj" (adjusted p values from Student's t test),
"mw" (p values from Mann-Whitney U test),"mw.adj" (adjusted p values from Mann-Whitney U test),
"depends" (if data in both compared groups were considered as derived from normal distribution
(p value from Shapiro_Wilk test > 0.05) - p values from Student's t test will be used for significance assignment,
otherwise p values from Mann-Whitney U test will be used), "depends.adj"
(if data in both compared groups were considered as derived from normal distribution
(p value from Shapiro_Wilk test > 0.05) - adjusted p values from Student's t test will be used for significance assignment,
otherwise adjusted p values from Mann-Whitney U test will be used), and "user" that can be used
the user intend to use another p values, e.g. obtained from other statistical test. In such situation, before run FCh_plot function, the user should prepare
data frame object named "user" that contains two columns, the first of them with Gene names and the second with p values.
The order of columns must be kept as described.}

\item{p.threshold}{Numeric: threshold of p values for statistical significance. Default to 0.05.}

\item{use.FCh}{Logical: if TRUE, the criterion of fold change will be also used for significance assignment of genes.}

\item{FCh.threshold}{Numeric: threshold of fold change values used for significance assignment of genes.
If is set to 2 (default), genes with 2-fold changed expression (increased or decreased) between groups will be assigned as significant.}

\item{use.sd}{Logical: if TRUE, errorbars with standard deviations will be added to the plot.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all names of genes.}

\item{bar.width}{numeric: width of bars.}

\item{signif.show}{Logical: if TRUE, labels for statistical significance will be added to the plot. Default to FALSE.}

\item{signif.labels}{Character vector with statistical significance labels (e.g. "ns.","***", etc.). The number
of elements must be equal to the number of genes used for plotting. All elements in the vector must be different; therefore,
symmetrically white spaces to repeated labels must be add to the same labels, e.g. "ns.", " ns. ", "  ns.  ".}

\item{signif.length}{Numeric: length of horizontal bars under statistical significance labels, values from 0 to 1.}

\item{signif.dist}{Numeric: distance between errorbar and statistical significance labels.}

\item{y.exp.low, y.exp.up}{Numeric: space between data on the plot and lower or upper axis. Useful to add extra space for statistical significance labels when faceting = TRUE.}

\item{angle}{Integer: value of angle in which names of genes are displayed. Default to 0.}

\item{rotate}{Logical: if TRUE, bars will be arranged horizontally. Deafault to FALSE.}

\item{colors}{Character vector length of one (when use.p = FALSE) or two (when use.p = TRUE), containing colors for significant and no significant genes.}

\item{border.color}{Character: color for borders of bars.}

\item{x.axis.title}{Character: title of x axis. Default to "Gene".}

\item{y.axis.title}{Character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be one of "top" (default), "right", "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "FCh_plot".}
}
\value{
List containing object with barplot and data frame with results. Created plot is also displayed on graphic device.
}
\description{
This function creates barplot that illustrate fold change values with indicating of significance by different colors of bars.
}
\examples{
library(ggsignif)
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
data.dCtF <- filter_transformed_data(data.dCt, remove.Sample = c("Control11"))
results.ddCt <- RQ_ddCt(data.dCtF, "Disease", "Control")

signif.labels <- c("****",
                   "**",
                   "ns.",
                   " ns. ",
                   "  ns.  ",
                   "   ns.   ",
                   "    ns.    ",
                   "     ns.     ",
                   "      ns.      ",
                   "       ns.       ",
                   "        ns.        ",
                   "         ns.         ",
                   "          ns.          ",
                   "***")
FCh.plot <- FCh_plot(results.ddCt,
                   mode = "depends",
                   use.FCh = TRUE,
                   FCh.threshold = 2.5,
                   signif.labels = signif.labels,
                   angle = 30)
head(FCh.plot[[2]])

# with user p values - calculated using stats::wilcox.test() function:
user <- data.dCt \%>\%
pivot_longer(cols = -c(Group, Sample), names_to = "Gene", values_to = "dCt") \%>\%
  group_by(Gene) \%>\%
  summarise(MW_test_p = wilcox.test(dCt ~ Group)$p.value, .groups = "keep")

FCh.plot <- FCh_plot(results.ddCt,
                   mode = "user",
                   use.FCh = TRUE,
                   FCh.threshold = 2,
                   signif.labels = signif.labels,
                   angle = 30)
head(FCh.plot[[2]])
}
