/*
 * Decompiled with CFR 0.152.
 */
package org.act.util;

import java.util.Random;
import org.act.util.ProbDistribution;

public class UniDimUniformDistribution
implements ProbDistribution {
    private double min;
    private double max;

    public UniDimUniformDistribution(double min, double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public int getDim() {
        return 1;
    }

    @Override
    public ProbDistribution.TYPE getType() {
        return ProbDistribution.TYPE.Uniform;
    }

    @Override
    public double density(double ... x) {
        if (x[0] >= this.min && x[0] <= this.max) {
            return 1.0 / (this.max - this.min);
        }
        return 0.0;
    }

    @Override
    public double[] sample(int n, double minVal, double maxVal) {
        Random random = new Random();
        double[] sample = new double[n];
        for (int i = 0; i < n; ++i) {
            sample[i] = random.nextDouble() * (maxVal - minVal) + minVal;
        }
        return sample;
    }

    @Override
    public double[] sample(int n) {
        return this.sample(n, this.min, this.max);
    }

    @Override
    public double mean() {
        return (this.min + this.max) / 2.0;
    }

    @Override
    public double sd() {
        return Math.pow(this.max - this.min, 2.0) / 12.0;
    }
}

