% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_repo_manager.R
\name{repo_manager_get_info}
\alias{repo_manager_get_info}
\title{Returns information on repo manager.}
\usage{
repo_manager_get_info(repo_manager)
}
\arguments{
\item{repo_manager}{repo manager object}
}
\value{
named list with following entries:
\describe{
  \item{types}{Types of packages manager can manage. (type: character)}
  \item{rver}{R version repo manager is managing. NA if repo
    manager is managing source packages. (type: character)}
  \item{url}{Url to the repository. (type: character)}
}
}
\description{
Returns information on repo manager.
}
\examples{
# create you own Repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' create own repo manager
#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

#' @export
repo_manager_get_info.repo_manager_own <- function(repo_manager) {
  return(list(
     types = c("source", "win-binary"), # package types supported by the manager
     rver = "3.5", # R version supported by the manager
     url = "file:///..." # base URL of repository
  ))
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
\concept{in extending RSuite with Repo adapter}
