/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClassifier
implements OptionHandler {
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_ClassifierOptions;
    protected String m_AnalysisResults;
    protected boolean m_Debug = false;
    protected boolean m_Silent = false;
    protected int m_NumInstances = 20;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tSilent mode - prints nothing to stdout.", "S", 0, "-S"));
        vector.addElement(new Option("\tThe number of instances in the datasets (default 20).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tFull name of the classifier analysed.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setSilent(Utils.getFlag('S', stringArray));
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else {
            this.setNumInstances(20);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getSilent()) {
            vector.add("-S");
        }
        vector.add("-N");
        vector.add("" + this.getNumInstances());
        if (this.getClassifier() != null) {
            vector.add("-W");
            vector.add(this.getClassifier().getClass().getName());
        }
        if ((stringArray = this.m_Classifier != null && this.m_Classifier instanceof OptionHandler ? this.m_Classifier.getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void doTests() {
        if (this.getClassifier() == null) {
            this.println("\n=== No classifier set ===");
            return;
        }
        this.println("\n=== Check on Classifier: " + this.getClassifier().getClass().getName() + " ===\n");
        this.canTakeOptions();
        boolean bl = this.updateableClassifier()[0];
        boolean bl2 = this.weightedInstancesHandler()[0];
        this.testsPerClassType(false, bl, bl2);
        this.testsPerClassType(true, bl, bl2);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
        if (this.getDebug()) {
            this.setSilent(false);
        }
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSilent(boolean bl) {
        this.m_Silent = bl;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public void setNumInstances(int n) {
        this.m_NumInstances = n;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected void print(Object object) {
        if (!this.getSilent()) {
            System.out.print(object);
        }
    }

    protected void println(Object object) {
        this.print(object + "\n");
    }

    protected void println() {
        this.print("\n");
    }

    protected void testsPerClassType(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.canPredict(true, false, false, bl)[0];
        boolean bl5 = this.canPredict(false, true, false, bl)[0];
        boolean bl6 = this.canPredict(false, false, true, bl)[0];
        if (bl4 || bl5 || bl6) {
            boolean bl7;
            if (bl3) {
                this.instanceWeights(bl4, bl5, bl6, bl);
            }
            if (!bl) {
                this.canHandleNClasses(bl4, bl5, bl6, 4);
            }
            this.canHandleZeroTraining(bl4, bl5, bl6, bl);
            boolean bl8 = this.canHandleMissing(bl4, bl5, bl6, bl, true, false, 20)[0];
            if (bl8) {
                this.canHandleMissing(bl4, bl5, bl6, bl, true, false, 100);
            }
            if (bl7 = this.canHandleMissing(bl4, bl5, bl6, bl, false, true, 20)[0]) {
                this.canHandleMissing(bl4, bl5, bl6, bl, false, true, 100);
            }
            this.correctBuildInitialisation(bl4, bl5, bl6, bl);
            this.datasetIntegrity(bl4, bl5, bl6, bl, bl8, bl7);
            this.doesntUseTestClassVal(bl4, bl5, bl6, bl);
            if (bl2) {
                this.updatingEquality(bl4, bl5, bl6, bl);
            }
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Classifier instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = this.m_Classifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] updateableClassifier() {
        boolean[] blArray = new boolean[2];
        this.print("updateable classifier...");
        if (this.m_Classifier instanceof UpdateableClassifier) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances classifier...");
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] canPredict(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3, bl4);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("not in classpath");
        int n = this.getNumInstances();
        int n2 = this.getNumInstances();
        int n3 = 2;
        int n4 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, n4, bl5, bl6, n, n2, n3, fastVector);
    }

    protected boolean[] canHandleNClasses(boolean bl, boolean bl2, boolean bl3, int n) {
        this.print("more than two class problems");
        this.printAttributeSummary(bl, bl2, bl3, false);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("number");
        fastVector.addElement("class");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        return this.runBasicTest(bl, bl2, bl3, false, n4, bl4, bl5, n2, n3, n, fastVector);
    }

    protected boolean[] canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3, bl4);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n = 0;
        int n2 = this.getNumInstances();
        int n3 = 2;
        int n4 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, n4, bl5, bl6, n, n2, n3, fastVector);
    }

    protected boolean[] correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean[] blArray;
        block21: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildClassifier");
            this.printAttributeSummary(bl, bl2, bl3, bl4);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            Instances instances = null;
            Instances instances2 = null;
            Instances instances3 = null;
            Instances instances4 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            Evaluation evaluation2 = null;
            Evaluation evaluation3 = null;
            boolean bl7 = false;
            int n5 = 0;
            try {
                instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
                instances3 = this.makeTestDataset(84, n, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
                instances4 = this.makeTestDataset(48, n2, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                if (bl) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                    instances3.deleteAttributeAt(0);
                    instances4.deleteAttributeAt(0);
                }
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl5, bl6);
                    this.addMissing(instances2, Math.min(n4, 50), bl5, bl6);
                    this.addMissing(instances3, n4, bl5, bl6);
                    this.addMissing(instances4, Math.min(n4, 50), bl5, bl6);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
                evaluation2 = new Evaluation(instances);
                evaluation3 = new Evaluation(instances3);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n5 = 0;
                classifier.buildClassifier(instances);
                bl7 = true;
                if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n5 = 1;
                bl7 = false;
                classifier.buildClassifier(instances3);
                bl7 = true;
                if (!this.testWRTZeroR(classifier, evaluation3, instances3, instances4)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n5 = 2;
                bl7 = false;
                classifier.buildClassifier(instances);
                bl7 = true;
                if (!this.testWRTZeroR(classifier, evaluation2, instances, instances2)[0]) {
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                n5 = 3;
                if (!evaluation.equals(evaluation2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n" + evaluation.toSummaryString("\nFirst buildClassifier()", true) + "\n\n");
                        this.println(evaluation2.toSummaryString("\nSecond buildClassifier()", true) + "\n\n");
                    }
                    throw new Exception("Results differ between buildClassifier calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                String string = exception.getMessage().toLowerCase();
                if (string.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    blArray[1] = true;
                } else {
                    this.println("no");
                    blArray[0] = false;
                }
                if (!this.m_Debug) break block21;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl7) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (n5) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test1 Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("=== Train2 Dataset ===\n" + instances3.toString() + "\n");
                this.println("=== Test2 Dataset ===\n" + instances4.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        if (n == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl5) {
            this.print(" predictor");
            if (bl6) {
                this.print(" and");
            }
        }
        if (bl6) {
            this.print(" class");
        }
        this.print(" values");
        this.printAttributeSummary(bl, bl2, bl3, bl4);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n2 = this.getNumInstances();
        int n3 = this.getNumInstances();
        int n4 = 2;
        return this.runBasicTest(bl, bl2, bl3, bl4, n, bl5, bl6, n2, n3, n4, fastVector);
    }

    protected boolean[] updatingEquality(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(bl, bl2, bl3, bl4);
        this.print("...");
        int n = this.getNumInstances();
        int n2 = this.getNumInstances();
        int n3 = 2;
        int n4 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean[] blArray = new boolean[2];
        Instances instances = null;
        Instances instances2 = null;
        Classifier[] classifierArray = null;
        Evaluation evaluation = null;
        Evaluation evaluation2 = null;
        boolean bl7 = false;
        try {
            instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
            instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
            if (bl) {
                instances.deleteAttributeAt(0);
                instances2.deleteAttributeAt(0);
            }
            if (n4 > 0) {
                this.addMissing(instances, n4, bl5, bl6);
                this.addMissing(instances2, Math.min(n4, 50), bl5, bl6);
            }
            classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
            evaluation = new Evaluation(instances);
            evaluation2 = new Evaluation(instances);
            classifierArray[0].buildClassifier(instances);
            this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            classifierArray[1].buildClassifier(new Instances(instances, 0));
            for (int i = 0; i < instances.numInstances(); ++i) {
                ((UpdateableClassifier)((Object)classifierArray[1])).updateClassifier(instances.instance(i));
            }
            bl7 = true;
            this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
            if (!evaluation.equals(evaluation2)) {
                this.println("no");
                blArray[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    this.println("Here are the results:\n");
                    this.println(evaluation.toSummaryString("\nbatch built results\n", true));
                    this.println(evaluation2.toSummaryString("\nincrementally built results\n", true));
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                    this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                }
            } else {
                this.println("yes");
                blArray[0] = true;
            }
        }
        catch (Exception exception) {
            blArray[0] = false;
            this.print("Problem during");
            if (bl7) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + exception.getMessage() + "\n");
        }
        return blArray;
    }

    protected boolean[] doesntUseTestClassVal(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean[] blArray;
        block11: {
            this.print("classifier ignores test instance class vals");
            this.printAttributeSummary(bl, bl2, bl3, bl4);
            this.print("...");
            int n = 2 * this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier[] classifierArray = null;
            Evaluation evaluation = null;
            Evaluation evaluation2 = null;
            boolean bl7 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                instances2 = this.makeTestDataset(24, n2, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                if (bl) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl5, bl6);
                    this.addMissing(instances2, Math.min(n4, 50), bl5, bl6);
                }
                classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
                evaluation = new Evaluation(instances);
                evaluation2 = new Evaluation(instances);
                classifierArray[0].buildClassifier(instances);
                classifierArray[1].buildClassifier(instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances2.numInstances(); ++i) {
                    Instance instance = instances2.instance(i);
                    Instance instance2 = (Instance)instance.copy();
                    instance2.setDataset(instances2);
                    instance2.setClassMissing();
                    double[] dArray = classifierArray[0].distributionForInstance(instance);
                    double[] dArray2 = classifierArray[1].distributionForInstance(instance2);
                    for (int j = 0; j < dArray.length; ++j) {
                        if (dArray[j] == dArray2[j]) continue;
                        throw new Exception("Prediction different for instance " + (i + 1));
                    }
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block11;
                this.println("\n=== Full Report ===");
                if (bl7) {
                    this.println("Results differ between non-missing and missing test class values.");
                } else {
                    this.print("Problem during testing");
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] instanceWeights(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean[] blArray;
        block14: {
            this.print("classifier uses instance weights");
            this.printAttributeSummary(bl, bl2, bl3, bl4);
            this.print("...");
            int n = 2 * this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier[] classifierArray = null;
            Evaluation evaluation = null;
            Evaluation evaluation2 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                instances2 = this.makeTestDataset(24, n2, bl ? 3 : 0, bl2 ? 2 : 0, bl3 ? 1 : 0, n3, bl4);
                if (bl) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl5, bl6);
                    this.addMissing(instances2, Math.min(n4, 50), bl5, bl6);
                }
                classifierArray = Classifier.makeCopies(this.getClassifier(), 2);
                evaluation = new Evaluation(instances);
                evaluation2 = new Evaluation(instances);
                classifierArray[0].buildClassifier(instances);
                this.testWRTZeroR(classifierArray[0], evaluation, instances, instances2);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n5 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n6 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n5).setWeight(n6);
                }
                classifierArray[1].buildClassifier(instances);
                bl7 = true;
                this.testWRTZeroR(classifierArray[1], evaluation2, instances, instances2);
                if (evaluation.equals(evaluation2)) {
                    bl8 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block14;
                this.println("\n=== Full Report ===");
                if (bl8) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println(evaluation.toSummaryString("\nboth methods\n", true));
                } else {
                    this.print("Problem during");
                    if (bl7) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
                this.println("(test weights all 1.0\n");
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        boolean[] blArray;
        block8: {
            this.print("classifier doesn't alter original datasets");
            this.printAttributeSummary(bl, bl2, bl3, bl4);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = this.getNumInstances();
            int n3 = 2;
            int n4 = 20;
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean bl7 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
                instances2 = this.makeTestDataset(24, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n3, bl4);
                if (bl) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n4 > 0) {
                    this.addMissing(instances, n4, bl5, bl6);
                    this.addMissing(instances2, Math.min(n4, 50), bl5, bl6);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances3 = new Instances(instances);
                Instances instances4 = new Instances(instances2);
                classifier.buildClassifier(instances3);
                this.compareDatasets(instances, instances3);
                bl7 = true;
                this.testWRTZeroR(classifier, evaluation, instances3, instances4);
                this.compareDatasets(instances2, instances4);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block8;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl7) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, boolean bl6, int n2, int n3, int n4, FastVector fastVector) {
        boolean[] blArray;
        block15: {
            blArray = new boolean[2];
            Instances instances = null;
            Instances instances2 = null;
            Classifier classifier = null;
            Evaluation evaluation = null;
            boolean bl7 = false;
            try {
                instances = this.makeTestDataset(42, n2, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n4, bl4);
                instances2 = this.makeTestDataset(24, n3, bl ? 2 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, n4, bl4);
                if (bl) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n > 0) {
                    this.addMissing(instances, n, bl5, bl6);
                    this.addMissing(instances2, Math.min(n, 50), bl5, bl6);
                }
                classifier = Classifier.makeCopies(this.getClassifier(), 1)[0];
                evaluation = new Evaluation(instances);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                classifier.buildClassifier(instances);
                bl7 = true;
                if (!this.testWRTZeroR(classifier, evaluation, instances, instances2)[0]) {
                    blArray[1] = true;
                    throw new Exception("Scheme performs worse than ZeroR");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n5;
                boolean bl8 = false;
                String string = exception.getMessage().toLowerCase();
                if (string.indexOf("worse than zeror") >= 0) {
                    this.println("warning: performs worse than ZeroR");
                    blArray[1] = true;
                } else {
                    for (n5 = 0; n5 < fastVector.size(); ++n5) {
                        if (string.indexOf((String)fastVector.elementAt(n5)) < 0) continue;
                        bl8 = true;
                    }
                    this.println("no" + (bl8 ? " (OK error message)" : ""));
                    blArray[1] = bl8;
                }
                if (!this.m_Debug) break block15;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl7) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                this.println(": " + exception.getMessage() + "\n");
                if (bl8) break block15;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n5 = 0; n5 < fastVector.size(); ++n5) {
                        if (n5 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n5) + '\"');
                    }
                }
                this.println("here are the datasets:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Test Dataset ===\n" + instances2.toString() + "\n\n");
            }
        }
        return blArray;
    }

    protected boolean[] testWRTZeroR(Classifier classifier, Evaluation evaluation, Instances instances, Instances instances2) throws Exception {
        boolean[] blArray = new boolean[2];
        evaluation.evaluateModel(classifier, instances2);
        try {
            ZeroR zeroR = new ZeroR();
            ((Classifier)zeroR).buildClassifier(instances);
            Evaluation evaluation2 = new Evaluation(instances);
            evaluation2.evaluateModel(zeroR, instances2);
            blArray[0] = Utils.grOrEq(evaluation2.errorRate(), evaluation.errorRate());
        }
        catch (Exception exception) {
            throw new Error("Problem determining ZeroR performance: " + exception.getMessage());
        }
        return blArray;
    }

    protected void compareDatasets(Instances instances, Instances instances2) throws Exception {
        if (!instances2.equalHeaders(instances)) {
            throw new Exception("header has been modified");
        }
        if (instances2.numInstances() != instances.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Instance instance2 = instances2.instance(i);
            for (int j = 0; j < instance.numAttributes(); ++j) {
                if (instance.isMissing(j) ? !instance2.isMissing(j) : instance.value(j) != instance2.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (instance.weight() == instance2.weight()) continue;
                throw new Exception("instance weights have changed");
            }
        }
    }

    protected void addMissing(Instances instances, int n, boolean bl, boolean bl2) {
        int n2 = instances.classIndex();
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if ((j != n2 || !bl2) && (j == n2 || !bl) || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) throws Exception {
        int n7;
        String[] stringArray = new String[]{"The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"};
        int n8 = n3 + n4 + n5 + 1;
        Random random = new Random(n);
        FastVector fastVector = new FastVector(n8);
        for (n7 = 0; n7 < n3; ++n7) {
            FastVector fastVector2 = new FastVector(n7 + 1);
            for (int i = 0; i <= n7; ++i) {
                fastVector2.addElement("a" + (n7 + 1) + "l" + (i + 1));
            }
            fastVector.addElement(new Attribute("Nominal" + (n7 + 1), fastVector2));
        }
        for (n7 = 0; n7 < n4; ++n7) {
            fastVector.addElement(new Attribute("Numeric" + (n7 + 1)));
        }
        for (n7 = 0; n7 < n5; ++n7) {
            fastVector.addElement(new Attribute("String" + (n7 + 1), (FastVector)null));
        }
        if (bl) {
            fastVector.addElement(new Attribute("Class"));
        } else {
            FastVector fastVector3 = new FastVector();
            for (int i = 0; i < n6; ++i) {
                fastVector3.addElement("cl" + (i + 1));
            }
            fastVector.addElement(new Attribute("Class", fastVector3));
        }
        Instances instances = new Instances("CheckSet", fastVector, n2);
        instances.setClassIndex(instances.numAttributes() - 1);
        for (int i = 0; i < n2; ++i) {
            Instance instance = new Instance(n8);
            instance.setDataset(instances);
            if (bl) {
                instance.setClassValue((double)random.nextFloat() * 0.25 + (double)(Math.abs(random.nextInt()) % Math.max(2, n3)));
            } else {
                instance.setClassValue(Math.abs(random.nextInt()) % instances.numClasses());
            }
            double d = instance.classValue();
            double d2 = 0.0;
            block11: for (int j = 0; j < n8 - 1; ++j) {
                switch (instances.attribute(j).type()) {
                    case 0: {
                        d2 = d * 4.0 + (double)(random.nextFloat() * 1.0f) - 0.5;
                        instance.setValue(j, d2);
                        continue block11;
                    }
                    case 1: {
                        d2 = (double)random.nextFloat() < 0.2 ? (double)(Math.abs(random.nextInt()) % instances.attribute(j).numValues()) : (double)((int)d % instances.attribute(j).numValues());
                        instance.setValue(j, d2);
                        continue block11;
                    }
                    case 2: {
                        String string = "";
                        for (int k = 0; k < stringArray.length; ++k) {
                            if (k > 0) {
                                string = string + " ";
                            }
                            string = string + stringArray[random.nextInt(stringArray.length)];
                        }
                        instance.setValue(j, (double)instances.attribute(j).addStringValue(string));
                    }
                }
            }
            instances.add(instance);
        }
        return instances;
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = "";
        if (bl2) {
            string = string + " numeric";
        }
        if (bl) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " nominal";
        }
        if (bl3) {
            if (string.length() > 0) {
                string = string + " &";
            }
            string = string + " string";
        }
        string = string + " predictors)";
        string = bl4 ? " (numeric class," + string : " (nominal class," + string;
        this.print(string);
    }

    public static void main(String[] stringArray) {
        try {
            CheckClassifier checkClassifier = new CheckClassifier();
            try {
                checkClassifier.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\nCheckClassifier Options:\n\n";
                Enumeration enumeration = checkClassifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            checkClassifier.doTests();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

