/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import java.io.Serializable;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropySplitCrit;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class ClassifierDecList
implements Serializable {
    protected int m_minNumObj;
    protected static EntropySplitCrit m_splitCrit = new EntropySplitCrit();
    protected ModelSelection m_toSelectModel;
    protected ClassifierSplitModel m_localModel;
    protected ClassifierDecList[] m_sons;
    protected boolean m_isLeaf;
    protected boolean m_isEmpty;
    protected Instances m_train;
    protected Distribution m_test;
    protected int indeX;

    public ClassifierDecList(ModelSelection modelSelection, int n) {
        this.m_toSelectModel = modelSelection;
        this.m_minNumObj = n;
    }

    public void buildRule(Instances instances) throws Exception {
        this.buildDecList(instances, false);
        this.cleanup(new Instances(instances, 0));
    }

    public void buildDecList(Instances instances, boolean bl) throws Exception {
        this.m_train = null;
        this.m_test = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.indeX = 0;
        double d = instances.sumOfWeights();
        NoSplit noSplit = new NoSplit(new Distribution(instances));
        this.m_localModel = bl ? noSplit : this.m_toSelectModel.selectModel(instances);
        if (this.m_localModel.numSubsets() > 1) {
            int n;
            Instances[] instancesArray = this.m_localModel.split(instances);
            instances = null;
            this.m_sons = new ClassifierDecList[this.m_localModel.numSubsets()];
            int n2 = 0;
            do {
                ++n2;
                n = this.chooseIndex();
                if (n == -1) {
                    for (int i = 0; i < this.m_sons.length; ++i) {
                        if (this.m_sons[i] != null) continue;
                        this.m_sons[i] = this.getNewDecList(instancesArray[i], true);
                    }
                    if (n2 < 2) {
                        this.m_localModel = noSplit;
                        this.m_isLeaf = true;
                        this.m_sons = null;
                        if (Utils.eq(d, 0.0)) {
                            this.m_isEmpty = true;
                        }
                        return;
                    }
                    n = 0;
                    break;
                }
                this.m_sons[n] = this.getNewDecList(instancesArray[n], false);
            } while (n2 < this.m_sons.length && this.m_sons[n].m_isLeaf);
            this.indeX = this.chooseLastIndex();
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(d, 0.0)) {
                this.m_isEmpty = true;
            }
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = -1.0;
        int n = 0;
        for (int i = 0; i < instance.numClasses(); ++i) {
            double d2 = this.getProbs(i, instance, 1.0);
            if (!Utils.gr(d2, d)) continue;
            n = i;
            d = d2;
        }
        if (Utils.eq(d, 0.0)) {
            return -1.0;
        }
        return n;
    }

    public final double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getProbs(i, instance, 1.0);
        }
        return dArray;
    }

    public double weight(Instance instance) throws Exception {
        if (this.m_isLeaf) {
            return 1.0;
        }
        int n = this.m_localModel.whichSubset(instance);
        if (n == -1) {
            return this.m_localModel.weights(instance)[this.indeX] * this.m_sons[this.indeX].weight(instance);
        }
        if (n == this.indeX) {
            return this.m_sons[this.indeX].weight(instance);
        }
        return 0.0;
    }

    public final void cleanup(Instances instances) {
        this.m_train = instances;
        this.m_test = null;
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.m_sons[i] == null) continue;
                this.m_sons[i].cleanup(instances);
            }
        }
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf) {
                stringBuffer.append(": ");
                stringBuffer.append(this.m_localModel.dumpLabel(0, this.m_train) + "\n");
            } else {
                this.dumpDecList(stringBuffer);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print rule.";
        }
    }

    protected ClassifierDecList getNewDecList(Instances instances, boolean bl) throws Exception {
        ClassifierDecList classifierDecList = new ClassifierDecList(this.m_toSelectModel, this.m_minNumObj);
        classifierDecList.buildDecList(instances, bl);
        return classifierDecList;
    }

    public final int chooseIndex() {
        int n = -1;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.m_sons.length; ++i) {
            double d2;
            if (this.son(i) != null) continue;
            if (Utils.sm(this.localModel().distribution().perBag(i), this.m_minNumObj)) {
                d2 = Double.MAX_VALUE;
            } else {
                d2 = 0.0;
                for (int j = 0; j < this.localModel().distribution().numClasses(); ++j) {
                    d2 -= m_splitCrit.logFunc(this.localModel().distribution().perClassPerBag(i, j));
                }
                d2 += m_splitCrit.logFunc(this.localModel().distribution().perBag(i));
                d2 /= this.localModel().distribution().perBag(i);
            }
            if (Utils.smOrEq(d2, 0.0)) {
                return i;
            }
            if (!Utils.sm(d2, d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    public final int chooseLastIndex() {
        int n = 0;
        double d = Double.MAX_VALUE;
        if (!this.m_isLeaf) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                double d2;
                if (this.son(i) == null || !Utils.grOrEq(this.localModel().distribution().perBag(i), this.m_minNumObj) || !Utils.sm(d2 = this.son(i).getSizeOfBranch(), d)) continue;
                d = d2;
                n = i;
            }
        }
        return n;
    }

    protected double getSizeOfBranch() {
        if (this.m_isLeaf) {
            return -this.localModel().distribution().total();
        }
        return this.son(this.indeX).getSizeOfBranch();
    }

    private void dumpDecList(StringBuffer stringBuffer) throws Exception {
        stringBuffer.append(this.m_localModel.leftSide(this.m_train));
        stringBuffer.append(this.m_localModel.rightSide(this.indeX, this.m_train));
        if (this.m_sons[this.indeX].m_isLeaf) {
            stringBuffer.append(": ");
            stringBuffer.append(this.m_localModel.dumpLabel(this.indeX, this.m_train) + "\n");
        } else {
            stringBuffer.append(" AND\n");
            this.m_sons[this.indeX].dumpDecList(stringBuffer);
        }
    }

    private void dumpTree(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append(": ");
                stringBuffer.append(this.m_localModel.dumpLabel(i, this.m_train));
                continue;
            }
            this.m_sons[i].dumpTree(n + 1, stringBuffer);
        }
    }

    private double getProbs(int n, Instance instance, double d) throws Exception {
        if (this.m_isLeaf) {
            return d * this.localModel().classProb(n, instance, -1);
        }
        int n2 = this.localModel().whichSubset(instance);
        if (n2 == -1) {
            double[] dArray = this.localModel().weights(instance);
            return this.son(this.indeX).getProbs(n, instance, dArray[this.indeX] * d);
        }
        if (n2 == this.indeX) {
            return this.son(this.indeX).getProbs(n, instance, d);
        }
        return 0.0;
    }

    protected ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    protected ClassifierDecList son(int n) {
        return this.m_sons[n];
    }
}

