/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.PairedStatsCorrected;
import weka.experiment.PairedTTester;

public class PairedCorrectedTTester
extends PairedTTester {
    public PairedStats calculateStatistics(Instance instance, int n, int n2, int n3) throws Exception {
        if (this.m_Instances.attribute(n3).type() != 0) {
            throw new Exception("Comparison column " + (n3 + 1) + " (" + this.m_Instances.attribute(n3).name() + ") is not numeric");
        }
        if (!this.m_ResultsetsValid) {
            this.prepareData();
        }
        PairedTTester.Resultset resultset = (PairedTTester.Resultset)this.m_Resultsets.elementAt(n);
        PairedTTester.Resultset resultset2 = (PairedTTester.Resultset)this.m_Resultsets.elementAt(n2);
        FastVector fastVector = resultset.dataset(instance);
        FastVector fastVector2 = resultset2.dataset(instance);
        String string = this.templateString(instance);
        if (fastVector == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset.templateString());
        }
        if (fastVector2 == null) {
            throw new Exception("No results for dataset=" + string + " for resultset=" + resultset2.templateString());
        }
        if (fastVector.size() != fastVector2.size()) {
            throw new Exception("Results for dataset=" + string + " differ in size for resultset=" + resultset.templateString() + " and resultset=" + resultset2.templateString());
        }
        double d = 0.0;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            if (this.m_Instances.attribute(i).name().toLowerCase().equals("number_of_training_instances")) {
                n4 = i;
                continue;
            }
            if (!this.m_Instances.attribute(i).name().toLowerCase().equals("number_of_testing_instances")) continue;
            n5 = i;
        }
        if (n4 >= 0 && n5 >= 0) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < fastVector.size(); ++i) {
                Instance instance2 = (Instance)fastVector.elementAt(i);
                d2 += instance2.value(n4);
                d3 += instance2.value(n5);
            }
            d = d3 / d2;
        }
        PairedStatsCorrected pairedStatsCorrected = new PairedStatsCorrected(this.m_SignificanceLevel, d);
        for (int i = 0; i < fastVector.size(); ++i) {
            Instance instance3 = (Instance)fastVector.elementAt(i);
            Instance instance4 = (Instance)fastVector2.elementAt(i);
            if (instance3.isMissing(n3)) {
                System.err.println("Instance has missing value in comparison column!\n" + instance3);
                continue;
            }
            if (instance4.isMissing(n3)) {
                System.err.println("Instance has missing value in comparison column!\n" + instance4);
                continue;
            }
            if (instance3.value(this.m_RunColumn) != instance4.value(this.m_RunColumn)) {
                System.err.println("Run numbers do not match!\n" + instance3 + instance4);
            }
            if (this.m_FoldColumn != -1 && instance3.value(this.m_FoldColumn) != instance4.value(this.m_FoldColumn)) {
                System.err.println("Fold numbers do not match!\n" + instance3 + instance4);
            }
            double d4 = instance3.value(n3);
            double d5 = instance4.value(n3);
            pairedStatsCorrected.add(d4, d5);
        }
        ((PairedStats)pairedStatsCorrected).calculateDerived();
        return pairedStatsCorrected;
    }

    public static void main(String[] stringArray) {
        try {
            PairedCorrectedTTester pairedCorrectedTTester = new PairedCorrectedTTester();
            String string = Utils.getOption('t', stringArray);
            String string2 = Utils.getOption('c', stringArray);
            String string3 = Utils.getOption('b', stringArray);
            boolean bl = Utils.getFlag('s', stringArray);
            boolean bl2 = Utils.getFlag('r', stringArray);
            try {
                if (string.length() == 0 || string2.length() == 0) {
                    throw new Exception("-t and -c options are required");
                }
                pairedCorrectedTTester.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string4 = "";
                Enumeration enumeration = pairedCorrectedTTester.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string4 = string4 + option.synopsis() + '\n' + option.description() + '\n';
                }
                throw new Exception("Usage:\n\n-t <file>\n\tSet the dataset containing data to evaluate\n-b <index>\n\tSet the resultset to base comparisons against (optional)\n-c <index>\n\tSet the column to perform a comparison on\n-s\n\tSummarize wins over all resultset pairs\n\n-r\n\tGenerate a resultset ranking\n\n" + string4);
            }
            Instances instances = new Instances(new BufferedReader(new FileReader(string)));
            pairedCorrectedTTester.setInstances(instances);
            int n = Integer.parseInt(string2) - 1;
            System.out.println(pairedCorrectedTTester.header(n));
            if (bl2) {
                System.out.println(pairedCorrectedTTester.multiResultsetRanking(n));
            } else if (bl) {
                System.out.println(pairedCorrectedTTester.multiResultsetSummary(n));
            } else {
                System.out.println(pairedCorrectedTTester.resultsetKey());
                if (string3.length() == 0) {
                    for (int i = 0; i < pairedCorrectedTTester.getNumResultsets(); ++i) {
                        System.out.println(pairedCorrectedTTester.multiResultsetFull(i, n));
                    }
                } else {
                    int n2 = Integer.parseInt(string3) - 1;
                    System.out.println(pairedCorrectedTTester.multiResultsetFull(n2, n));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public String getDisplayName() {
        return "Paired T-Tester (corrected)";
    }

    public String getToolTipText() {
        return "Performs test using corrected resampled t-test statistic (Nadeau and Bengio)";
    }
}

