/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class DBScan
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1666498248451219728L;
    private double epsilon = 0.9;
    private int minPoints = 6;
    private ReplaceMissingValues replaceMissingValues_Filter;
    private int numberOfGeneratedClusters;
    private String database_distanceType = "weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject";
    private String database_Type = "weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase";
    private Database database;
    private int clusterID;
    private int processed_InstanceID;
    private double elapsedTime;

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        DataObject dataObject;
        this.getCapabilities().testWithFail(instances);
        long l = System.currentTimeMillis();
        this.processed_InstanceID = 0;
        this.numberOfGeneratedClusters = 0;
        this.clusterID = 0;
        this.replaceMissingValues_Filter = new ReplaceMissingValues();
        this.replaceMissingValues_Filter.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.replaceMissingValues_Filter);
        this.database = this.databaseForName(this.getDatabase_Type(), instances2);
        for (int i = 0; i < this.database.getInstances().numInstances(); ++i) {
            dataObject = this.dataObjectForName(this.getDatabase_distanceType(), this.database.getInstances().instance(i), Integer.toString(i), this.database);
            this.database.insert(dataObject);
        }
        this.database.setMinMaxValues();
        Iterator iterator = this.database.dataObjectIterator();
        while (iterator.hasNext()) {
            dataObject = (DataObject)iterator.next();
            if (dataObject.getClusterLabel() != -1 || !this.expandCluster(dataObject)) continue;
            ++this.clusterID;
            ++this.numberOfGeneratedClusters;
        }
        long l2 = System.currentTimeMillis();
        this.elapsedTime = (double)(l2 - l) / 1000.0;
    }

    private boolean expandCluster(DataObject dataObject) {
        DataObject dataObject2;
        int n;
        List list = this.database.epsilonRangeQuery(this.getEpsilon(), dataObject);
        if (list.size() < this.getMinPoints()) {
            dataObject.setClusterLabel(Integer.MIN_VALUE);
            return false;
        }
        for (n = 0; n < list.size(); ++n) {
            dataObject2 = (DataObject)list.get(n);
            dataObject2.setClusterLabel(this.clusterID);
            if (!dataObject2.equals(dataObject)) continue;
            list.remove(n);
            --n;
        }
        for (n = 0; n < list.size(); ++n) {
            dataObject2 = (DataObject)list.get(n);
            List list2 = this.database.epsilonRangeQuery(this.getEpsilon(), dataObject2);
            if (list2.size() >= this.getMinPoints()) {
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject3 = (DataObject)list2.get(i);
                    if (dataObject3.getClusterLabel() != -1 && dataObject3.getClusterLabel() != Integer.MIN_VALUE) continue;
                    if (dataObject3.getClusterLabel() == -1) {
                        list.add(dataObject3);
                    }
                    dataObject3.setClusterLabel(this.clusterID);
                }
            }
            list.remove(n);
            --n;
        }
        return true;
    }

    public int clusterInstance(Instance instance) throws Exception {
        int n;
        if (this.processed_InstanceID >= this.database.size()) {
            this.processed_InstanceID = 0;
        }
        if ((n = this.database.getDataObject(Integer.toString(this.processed_InstanceID++)).getClusterLabel()) == Integer.MIN_VALUE) {
            throw new Exception();
        }
        return n;
    }

    public int numberOfClusters() throws Exception {
        return this.numberOfGeneratedClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tepsilon (default = 0.9)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tminPoints (default = 6)", "M", 1, "-M <int>"));
        vector.addElement(new Option("\tindex (database) used for DBScan (default = weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase)", "I", 1, "-I <String>"));
        vector.addElement(new Option("\tdistance-type (default = weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject)", "D", 1, "-D <String>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setEpsilon(Double.parseDouble(string));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMinPoints(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('I', stringArray)).length() != 0) {
            this.setDatabase_Type(string);
        }
        if ((string = Utils.getOption('D', stringArray)).length() != 0) {
            this.setDatabase_distanceType(string);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.getEpsilon();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinPoints();
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getDatabase_Type();
        stringArray[n++] = "-D";
        stringArray[n++] = "" + this.getDatabase_distanceType();
        return stringArray;
    }

    public Database databaseForName(String string, Instances instances) {
        Object var3_3 = null;
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(string).getConstructor(Instances.class);
            var3_3 = constructor.newInstance(instances);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return var3_3;
    }

    public DataObject dataObjectForName(String string, Instance instance, String string2, Database database) {
        Object var5_5 = null;
        Constructor<?> constructor = null;
        try {
            constructor = Class.forName(string).getConstructor(Instance.class, String.class, Database.class);
            var5_5 = constructor.newInstance(instance, string2, database);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return var5_5;
    }

    public void setMinPoints(int n) {
        this.minPoints = n;
    }

    public void setEpsilon(double d) {
        this.epsilon = d;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getMinPoints() {
        return this.minPoints;
    }

    public String getDatabase_distanceType() {
        return this.database_distanceType;
    }

    public String getDatabase_Type() {
        return this.database_Type;
    }

    public void setDatabase_distanceType(String string) {
        this.database_distanceType = string;
    }

    public void setDatabase_Type(String string) {
        this.database_Type = string;
    }

    public String epsilonTipText() {
        return "radius of the epsilon-range-queries";
    }

    public String minPointsTipText() {
        return "minimun number of DataObjects required in an epsilon-range-query";
    }

    public String database_TypeTipText() {
        return "used database";
    }

    public String database_distanceTypeTipText() {
        return "used distance-type";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Martin Ester and Hans-Peter Kriegel and Joerg Sander and Xiaowei Xu");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Second International Conference on Knowledge Discovery and Data Mining");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "Evangelos Simoudis and Jiawei Han and Usama M. Fayyad");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "226-231");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return technicalInformation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DBScan clustering results\n========================================================================================\n\n");
        stringBuffer.append("Clustered DataObjects: " + this.database.size() + "\n");
        stringBuffer.append("Number of attributes: " + this.database.getInstances().numAttributes() + "\n");
        stringBuffer.append("Epsilon: " + this.getEpsilon() + "; minPoints: " + this.getMinPoints() + "\n");
        stringBuffer.append("Index: " + this.getDatabase_Type() + "\n");
        stringBuffer.append("Distance-type: " + this.getDatabase_distanceType() + "\n");
        stringBuffer.append("Number of generated clusters: " + this.numberOfGeneratedClusters + "\n");
        DecimalFormat decimalFormat = new DecimalFormat(".##");
        stringBuffer.append("Elapsed time: " + decimalFormat.format(this.elapsedTime) + "\n\n");
        for (int i = 0; i < this.database.size(); ++i) {
            DataObject dataObject = this.database.getDataObject(Integer.toString(i));
            stringBuffer.append("(" + Utils.doubleToString(Double.parseDouble(dataObject.getKey()), Integer.toString(this.database.size()).length(), 0) + ".) " + Utils.padRight(dataObject.toString(), 69) + "  -->  " + (dataObject.getClusterLabel() == Integer.MIN_VALUE ? "NOISE\n" : dataObject.getClusterLabel() + "\n"));
        }
        return stringBuffer.toString() + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }

    public static void main(String[] stringArray) {
        DBScan.runClusterer(new DBScan(), stringArray);
    }
}

