/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Jython;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class JythonClassifier
extends Classifier {
    private static final long serialVersionUID = -9078371491735496175L;
    protected File m_JythonModule = new File(System.getProperty("user.dir"));
    protected String[] m_JythonOptions = new String[0];
    protected File[] m_JythonPaths = new File[0];
    protected transient Classifier m_JythonObject = null;

    public String globalInfo() {
        return "A wrapper class for Jython code. Even though the classifier is serializable, the trained classifier cannot be stored persistently. I.e., one cannot store a model file and re-load it at a later point in time again to make predictions.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe Jython module to load (full path)\n\tOptions after '--' will be passed on to the Jython module.", "J", 1, "-J <filename>"));
        vector.addElement(new Option("\tThe paths to add to 'sys.path' (comma-separated list).", "P", 1, "-P <directory[,directory,...]>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_JythonOptions = new String[0];
        this.setJythonPaths(Utils.getOption('P', stringArray));
        String string = Utils.getOption('J', stringArray);
        if (string.length() != 0) {
            this.setJythonModule(new File(string));
        } else {
            this.setJythonModule(new File(System.getProperty("user.dir")));
        }
        this.setJythonOptions(Utils.joinOptions((String[])Utils.partitionOptions(stringArray).clone()));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        if (this.getJythonPaths().length() > 0) {
            vector.add("-P");
            vector.add("" + this.getJythonPaths());
        }
        vector.add("-J");
        vector.add("" + this.getJythonModule().getAbsolutePath());
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.m_JythonOptions.length > 0) {
            stringArray = this.m_JythonOptions;
            vector.add("--");
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String jythonModuleTipText() {
        return "The Jython module to load and execute.";
    }

    public void setJythonModule(File file) {
        this.m_JythonModule = file;
        this.initJythonObject();
    }

    public File getJythonModule() {
        return this.m_JythonModule;
    }

    public String jythonOptionsTipText() {
        return "The options for the Jython module.";
    }

    public void setJythonOptions(String string) {
        try {
            this.m_JythonOptions = (String[])Utils.splitOptions(string).clone();
            this.initJythonObject();
        }
        catch (Exception exception) {
            this.m_JythonOptions = new String[0];
            exception.printStackTrace();
        }
    }

    public String getJythonOptions() {
        return Utils.joinOptions(this.m_JythonOptions);
    }

    public String jythonPathsTipText() {
        return "Comma-separated list of additional paths that get added to 'sys.path'.";
    }

    public void setJythonPaths(String string) {
        if (string.length() == 0) {
            this.m_JythonPaths = new File[0];
        } else {
            String[] stringArray = string.split(",");
            this.m_JythonPaths = new File[stringArray.length];
            for (int i = 0; i < this.m_JythonPaths.length; ++i) {
                this.m_JythonPaths[i] = new File(stringArray[i]);
            }
        }
    }

    public String getJythonPaths() {
        String string = "";
        for (int i = 0; i < this.m_JythonPaths.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.m_JythonPaths[i].getAbsolutePath();
        }
        return string;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_JythonObject == null ? new Capabilities(this) : this.m_JythonObject.getCapabilities();
        capabilities.enableAllAttributeDependencies();
        capabilities.enableAllClassDependencies();
        return capabilities;
    }

    protected void initJythonObject() {
        try {
            this.m_JythonObject = this.m_JythonModule.isFile() ? (Classifier)Jython.newInstance(this.m_JythonModule, Classifier.class, this.m_JythonPaths) : null;
            if (this.m_JythonObject != null) {
                this.m_JythonObject.setOptions((String[])this.m_JythonOptions.clone());
            }
        }
        catch (Exception exception) {
            this.m_JythonObject = null;
            exception.printStackTrace();
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!Jython.isPresent()) {
            throw new Exception("Jython classes not in CLASSPATH!");
        }
        this.initJythonObject();
        if (this.m_JythonObject != null) {
            this.m_JythonObject.buildClassifier(instances);
        } else {
            System.err.println("buildClassifier: No Jython object present!");
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.classifyInstance(instance);
        }
        return Instance.missingValue();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.distributionForInstance(instance);
        }
        return new double[instance.numClasses()];
    }

    public String toString() {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.toString();
        }
        return "No Jython module loaded.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        JythonClassifier.runClassifier(new JythonClassifier(), stringArray);
    }
}

