/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.DefineFunction;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.Function;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Apply
extends Expression {
    private static final long serialVersionUID = -2790648331300695083L;
    protected ArrayList<Expression> m_arguments = new ArrayList();
    protected Function m_function = null;
    protected Attribute m_outputStructure = null;

    protected Apply(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList, TransformationDictionary transformationDictionary) throws Exception {
        super(optype, arrayList);
        String string = element.getAttribute("function");
        if (string == null || string.length() == 0) {
            string = element.getAttribute("name");
        }
        if (string == null || string.length() == 0) {
            throw new Exception("[Apply] No function name specified!!");
        }
        this.m_function = Function.getFunction(string, transformationDictionary);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Expression expression;
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (string2 = ((Element)node).getTagName()).equals("Extension") || (expression = Expression.getExpression(string2, node, this.m_opType, this.m_fieldDefs, transformationDictionary)) == null) continue;
            this.m_arguments.add(expression);
        }
        this.updateDefsForArgumentsAndFunction();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        super.setFieldDefs(arrayList);
        this.updateDefsForArgumentsAndFunction();
    }

    private void updateDefsForArgumentsAndFunction() throws Exception {
        for (int i = 0; i < this.m_arguments.size(); ++i) {
            this.m_arguments.get(i).setFieldDefs(this.m_fieldDefs);
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.m_arguments.size());
        for (int i = 0; i < this.m_arguments.size(); ++i) {
            arrayList.add(this.m_arguments.get(i).getOutputDef());
        }
        this.m_function.setParameterDefs(arrayList);
        this.m_outputStructure = this.m_function.getOutputDef();
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        double[] dArray2 = new double[this.m_arguments.size()];
        for (int i = 0; i < this.m_arguments.size(); ++i) {
            dArray2[i] = this.m_arguments.get(i).getResult(dArray);
        }
        double d = this.m_function.getResult(dArray2);
        return d;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[Apply] Can't return result as categorical/ordinal because optype is continuous!");
        }
        double d = this.getResult(dArray);
        return this.m_outputStructure.value((int)d);
    }

    @Override
    public Attribute getOutputDef() {
        return this.m_outputStructure;
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = null;
        stringBuffer.append(string + "Apply [" + this.m_function.toString() + "]:\n");
        stringBuffer.append(string + "args:");
        if (this.m_function instanceof DefineFunction) {
            stringArray = this.m_function.getParameterNames();
        }
        for (int i = 0; i < this.m_arguments.size(); ++i) {
            Expression expression = this.m_arguments.get(i);
            stringBuffer.append("\n" + (stringArray != null ? string + stringArray[i] + " = " : "") + expression.toString(string + "  "));
        }
        return stringBuffer.toString();
    }
}

