/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.FastVector;
import weka.gui.ResultHistoryPanel;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeVisualizer;

public class GraphViewer
extends JPanel
implements Visible,
GraphListener,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    private static final long serialVersionUID = -5183121972114900617L;
    protected BeanVisual m_visual;
    private transient JFrame m_resultsFrame = null;
    protected transient ResultHistoryPanel m_history;
    protected transient BeanContext m_beanContext = null;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);
    protected boolean m_design;

    public GraphViewer() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!graphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    protected void appearanceDesign() {
        this.setUpResultHistory();
        this.removeAll();
        this.m_visual = new BeanVisual("GraphViewer", "weka/gui/beans/icons/DefaultGraph.gif", "weka/gui/beans/icons/DefaultGraph_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        this.setUpResultHistory();
        this.add((Component)this.m_history, "Center");
    }

    public String globalInfo() {
        return "Graphically visualize trees or graphs produced by classifiers/clusterers.";
    }

    private void setUpResultHistory() {
        if (this.m_history == null) {
            this.m_history = new ResultHistoryPanel(null);
        }
        this.m_history.setBorder(BorderFactory.createTitledBorder("Graph list"));
        this.m_history.setHandleRightClicks(false);
        this.m_history.getList().addMouseListener(new ResultHistoryPanel.RMouseAdapter(){
            private static final long serialVersionUID = -4984130887963944249L;

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = GraphViewer.this.m_history.getList().locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    String string = GraphViewer.this.m_history.getNameAtIndex(n);
                    GraphViewer.this.doPopup(string);
                }
            }
        });
    }

    public void setBeanContext(BeanContext beanContext) {
        this.m_beanContext = beanContext;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!graphicsEnvironment.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public synchronized void acceptGraph(GraphEvent graphEvent) {
        FastVector fastVector = new FastVector();
        if (this.m_history == null) {
            this.setUpResultHistory();
        }
        String string = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
        string = string + graphEvent.getGraphTitle();
        fastVector.addElement(new Integer(graphEvent.getGraphType()));
        fastVector.addElement(graphEvent.getGraphString());
        this.m_history.addResult(string, new StringBuffer());
        this.m_history.addObject(string, fastVector);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultGraph.gif", "weka/gui/beans/icons/DefaultGraph_animated.gif");
    }

    public void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_history == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = new JFrame("Graph Viewer");
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            this.m_resultsFrame.getContentPane().add((Component)this.m_history, "Center");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    GraphViewer.this.m_resultsFrame.dispose();
                    GraphViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    private void doPopup(String string) {
        JPanel jPanel;
        JFrame jFrame;
        FastVector fastVector = (FastVector)this.m_history.getNamedObject(string);
        int n = (Integer)fastVector.firstElement();
        String string2 = (String)fastVector.lastElement();
        if (n == 1) {
            jFrame = new JFrame("Weka Classifier Tree Visualizer: " + string);
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jPanel = new TreeVisualizer(null, string2, (NodePlace)new PlaceNode2());
            jFrame.getContentPane().add((Component)jPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
        if (n == 2) {
            jFrame = new JFrame("Weka Classifier Graph Visualizer: " + string);
            jFrame.setSize(500, 400);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jPanel = new GraphVisualizer();
            try {
                ((GraphVisualizer)jPanel).readBIF(string2);
            }
            catch (BIFFormatException bIFFormatException) {
                System.err.println("unable to visualize BayesNet");
                bIFFormatException.printStackTrace();
            }
            ((GraphVisualizer)jPanel).layoutGraph();
            jFrame.getContentPane().add((Component)jPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                }
            });
            jFrame.setVisible(true);
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        vector.addElement("Show results");
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Show results") != 0) {
            throw new IllegalArgumentException(string + " not supported (GraphViewer)");
        }
        this.showResults();
    }
}

