/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.classifiers.meta.ensembleSelection.ModelBag;
import weka.classifiers.trees.REPTree;
import weka.classifiers.xml.XMLClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;

public class EnsembleSelection
extends RandomizableClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1744155148765058511L;
    protected EnsembleSelectionLibrary m_library = new EnsembleSelectionLibrary();
    protected EnsembleSelectionLibraryModel[] m_chosen_models = null;
    protected int[] m_chosen_model_weights = null;
    protected int m_total_weight = 0;
    protected double m_modelRatio = 0.5;
    protected double m_validationRatio = 0.25;
    public static final Tag[] TAGS_METRIC = new Tag[]{new Tag(0, "Optimize with Accuracy"), new Tag(1, "Optimize with RMSE"), new Tag(2, "Optimize with ROC"), new Tag(3, "Optimize with precision"), new Tag(4, "Optimize with recall"), new Tag(5, "Optimize with fscore"), new Tag(6, "Optimize with all metrics")};
    public static final int ALGORITHM_FORWARD = 0;
    public static final int ALGORITHM_BACKWARD = 1;
    public static final int ALGORITHM_FORWARD_BACKWARD = 2;
    public static final int ALGORITHM_BEST = 3;
    public static final int ALGORITHM_BUILD_LIBRARY = 4;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(0, "Forward selection"), new Tag(1, "Backward elimation"), new Tag(2, "Forward Selection + Backward Elimination"), new Tag(3, "Best model"), new Tag(4, "Build Library Only")};
    private static final int MAX_DEFAULT_DIRECTORIES = 1000;
    protected String m_modelLibraryFileName = null;
    protected int m_numModelBags = 10;
    protected int m_hillclimbMetric = 1;
    protected int m_algorithm = 0;
    protected int m_hillclimbIterations = 100;
    protected double m_sortInitializationRatio = 1.0;
    protected boolean m_replacement = true;
    protected boolean m_greedySortInitialization = true;
    protected boolean m_verboseOutput = false;
    protected Map m_cachedPredictions = null;
    protected File m_workingDirectory = new File(EnsembleSelection.getDefaultWorkingDirectory());
    protected int m_NumFolds = 1;

    public String globalInfo() {
        return "Combines several classifiers using the ensemble selection method. For more information, see: Caruana, Rich, Niculescu, Alex, Crew, Geoff, and Ksikes, Alex, Ensemble Selection from Libraries of Models, The International Conference on Machine Learning (ICML'04), 2004.  Implemented in Weka by Bob Jung and David Michael.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecifies the Model Library File, continuing the list of all models.", "L", 1, "-L </path/to/modelLibrary>"));
        vector.addElement(new Option("\tSpecifies the Working Directory, where all models will be stored.", "W", 1, "-W </path/to/working/directory>"));
        vector.addElement(new Option("\tSet the number of bags, i.e., number of iterations to run \n\tthe ensemble selection algorithm.", "B", 1, "-B <numModelBags>"));
        vector.addElement(new Option("\tSet the ratio of library models that will be randomly chosen \n\tto populate each bag of models.", "E", 1, "-E <modelRatio>"));
        vector.addElement(new Option("\tSet the ratio of the training data set that will be reserved \n\tfor validation.", "V", 1, "-V <validationRatio>"));
        vector.addElement(new Option("\tSet the number of hillclimbing iterations to be performed \n\ton each model bag.", "H", 1, "-H <hillClimbIterations>"));
        vector.addElement(new Option("\tSet the the ratio of the ensemble library that the sort \n\tinitialization algorithm will be able to choose from while \n\tinitializing the ensemble for each model bag", "I", 1, "-I <sortInitialization>"));
        vector.addElement(new Option("\tSets the number of cross-validation folds.", "X", 1, "-X <numFolds>"));
        vector.addElement(new Option("\tSpecify the metric that will be used for model selection \n\tduring the hillclimbing algorithm.\n\tValid metrics are: \n\t\taccuracy, rmse, roc, precision, recall, fscore, all", "P", 1, "-P <hillclimbMettric>"));
        vector.addElement(new Option("\tSpecifies the algorithm to be used for ensemble selection. \n\tValid algorithms are:\n\t\t\"forward\" (default) for forward selection.\n\t\t\"backward\" for backward elimination.\n\t\t\"both\" for both forward and backward elimination.\n\t\t\"best\" to simply print out top performer from the \n\t\t   ensemble library\n\t\t\"library\" to only train the models in the ensemble \n\t\t   library", "A", 1, "-A <algorithm>"));
        vector.addElement(new Option("\tFlag whether or not models can be selected more than once \n\tfor an ensemble.", "R", 0, "-R"));
        vector.addElement(new Option("\tWhether sort initialization greedily stops adding models \n\twhen performance degrades.", "G", 0, "-G"));
        vector.addElement(new Option("\tFlag for verbose output. Prints out performance of all \n\tselected models.", "O", 0, "-O"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        return capabilities;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.m_modelLibraryFileName = string;
            this.m_library = new EnsembleSelectionLibrary(this.m_modelLibraryFileName);
        } else {
            this.setLibrary(new EnsembleSelectionLibrary());
        }
        string = Utils.getOption('W', stringArray);
        this.m_workingDirectory = string.length() != 0 && this.validWorkingDirectory(string) ? new File(string) : new File(EnsembleSelection.getDefaultWorkingDirectory());
        this.m_library.setWorkingDirectory(this.m_workingDirectory);
        string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setModelRatio(Double.parseDouble(string));
        } else {
            this.setModelRatio(1.0);
        }
        string = Utils.getOption('V', stringArray);
        if (string.length() != 0) {
            this.setValidationRatio(Double.parseDouble(string));
        } else {
            this.setValidationRatio(0.25);
        }
        string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setNumModelBags(Integer.parseInt(string));
        } else {
            this.setNumModelBags(10);
        }
        string = Utils.getOption('H', stringArray);
        if (string.length() != 0) {
            this.setHillclimbIterations(Integer.parseInt(string));
        } else {
            this.setHillclimbIterations(100);
        }
        string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setSortInitializationRatio(Double.parseDouble(string));
        } else {
            this.setSortInitializationRatio(1.0);
        }
        string = Utils.getOption('X', stringArray);
        if (string.length() != 0) {
            this.setNumFolds(Integer.parseInt(string));
        } else {
            this.setNumFolds(10);
        }
        this.setReplacement(Utils.getFlag('R', stringArray));
        this.setGreedySortInitialization(Utils.getFlag('G', stringArray));
        this.setVerboseOutput(Utils.getFlag('O', stringArray));
        string = Utils.getOption('P', stringArray);
        if (string.toLowerCase().equals("accuracy")) {
            this.setHillclimbMetric(new SelectedTag(0, TAGS_METRIC));
        } else if (string.toLowerCase().equals("rmse")) {
            this.setHillclimbMetric(new SelectedTag(1, TAGS_METRIC));
        } else if (string.toLowerCase().equals("roc")) {
            this.setHillclimbMetric(new SelectedTag(2, TAGS_METRIC));
        } else if (string.toLowerCase().equals("precision")) {
            this.setHillclimbMetric(new SelectedTag(3, TAGS_METRIC));
        } else if (string.toLowerCase().equals("recall")) {
            this.setHillclimbMetric(new SelectedTag(4, TAGS_METRIC));
        } else if (string.toLowerCase().equals("fscore")) {
            this.setHillclimbMetric(new SelectedTag(5, TAGS_METRIC));
        } else if (string.toLowerCase().equals("all")) {
            this.setHillclimbMetric(new SelectedTag(6, TAGS_METRIC));
        } else {
            this.setHillclimbMetric(new SelectedTag(1, TAGS_METRIC));
        }
        string = Utils.getOption('A', stringArray);
        if (string.toLowerCase().equals("forward")) {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        } else if (string.toLowerCase().equals("backward")) {
            this.setAlgorithm(new SelectedTag(1, TAGS_ALGORITHM));
        } else if (string.toLowerCase().equals("both")) {
            this.setAlgorithm(new SelectedTag(2, TAGS_ALGORITHM));
        } else if (string.toLowerCase().equals("forward")) {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        } else if (string.toLowerCase().equals("best")) {
            this.setAlgorithm(new SelectedTag(3, TAGS_ALGORITHM));
        } else if (string.toLowerCase().equals("library")) {
            this.setAlgorithm(new SelectedTag(4, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        }
        super.setOptions(stringArray);
        this.m_library.setDebug(this.m_Debug);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.m_library.getModelListFile() != null) {
            vector.add("-L");
            vector.add("" + this.m_library.getModelListFile());
        }
        if (!this.m_workingDirectory.equals("")) {
            vector.add("-W");
            vector.add("" + this.getWorkingDirectory());
        }
        vector.add("-P");
        switch (this.getHillclimbMetric().getSelectedTag().getID()) {
            case 0: {
                vector.add("accuracy");
                break;
            }
            case 1: {
                vector.add("rmse");
                break;
            }
            case 2: {
                vector.add("roc");
                break;
            }
            case 3: {
                vector.add("precision");
                break;
            }
            case 4: {
                vector.add("recall");
                break;
            }
            case 5: {
                vector.add("fscore");
                break;
            }
            case 6: {
                vector.add("all");
            }
        }
        vector.add("-A");
        switch (this.getAlgorithm().getSelectedTag().getID()) {
            case 0: {
                vector.add("forward");
                break;
            }
            case 1: {
                vector.add("backward");
                break;
            }
            case 2: {
                vector.add("both");
                break;
            }
            case 3: {
                vector.add("best");
                break;
            }
            case 4: {
                vector.add("library");
            }
        }
        vector.add("-B");
        vector.add("" + this.getNumModelBags());
        vector.add("-V");
        vector.add("" + this.getValidationRatio());
        vector.add("-E");
        vector.add("" + this.getModelRatio());
        vector.add("-H");
        vector.add("" + this.getHillclimbIterations());
        vector.add("-I");
        vector.add("" + this.getSortInitializationRatio());
        vector.add("-X");
        vector.add("" + this.getNumFolds());
        if (this.m_replacement) {
            vector.add("-R");
        }
        if (this.m_greedySortInitialization) {
            vector.add("-G");
        }
        if (this.m_verboseOutput) {
            vector.add("-O");
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String numFoldsTipText() {
        return "The number of folds used for cross-validation.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of cross-validation folds must be positive.");
        }
        this.m_NumFolds = n;
    }

    public String libraryTipText() {
        return "An ensemble library.";
    }

    public EnsembleSelectionLibrary getLibrary() {
        return this.m_library;
    }

    public void setLibrary(EnsembleSelectionLibrary ensembleSelectionLibrary) {
        this.m_library = ensembleSelectionLibrary;
        this.m_library.setDebug(this.m_Debug);
    }

    public String modelRatioTipText() {
        return "The ratio of library models that will be randomly chosen to be used for each iteration.";
    }

    public double getModelRatio() {
        return this.m_modelRatio;
    }

    public void setModelRatio(double d) {
        this.m_modelRatio = d;
    }

    public String validationRatioTipText() {
        return "The ratio of the training data set that will be reserved for validation.";
    }

    public double getValidationRatio() {
        return this.m_validationRatio;
    }

    public void setValidationRatio(double d) {
        this.m_validationRatio = d;
    }

    public String hillclimbMetricTipText() {
        return "the metric that will be used to optimizer the chosen ensemble..";
    }

    public SelectedTag getHillclimbMetric() {
        return new SelectedTag(this.m_hillclimbMetric, TAGS_METRIC);
    }

    public void setHillclimbMetric(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_METRIC) {
            this.m_hillclimbMetric = selectedTag.getSelectedTag().getID();
        }
    }

    public String algorithmTipText() {
        return "the algorithm used to optimizer the ensemble";
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_algorithm, TAGS_ALGORITHM);
    }

    public void setAlgorithm(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_ALGORITHM) {
            this.m_algorithm = selectedTag.getSelectedTag().getID();
        }
    }

    public String hillclimbIterationsTipText() {
        return "The number of hillclimbing iterations for the ensemble selection algorithm.";
    }

    public int getHillclimbIterations() {
        return this.m_hillclimbIterations;
    }

    public void setHillclimbIterations(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of hillclimb iterations must be positive.");
        }
        this.m_hillclimbIterations = n;
    }

    public String numModelBagsTipText() {
        return "The number of \"model bags\" used in the ensemble selection algorithm.";
    }

    public int getNumModelBags() {
        return this.m_numModelBags;
    }

    public void setNumModelBags(int n) throws Exception {
        if (n <= 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of model bags must be positive.");
        }
        this.m_numModelBags = n;
    }

    public String sortInitializationRatioTipText() {
        return "The ratio of library models to be used for sort initialization.";
    }

    public double getSortInitializationRatio() {
        return this.m_sortInitializationRatio;
    }

    public void setSortInitializationRatio(double d) {
        this.m_sortInitializationRatio = d;
    }

    public String replacementTipText() {
        return "Whether models in the library can be included more than once in an ensemble.";
    }

    public boolean getReplacement() {
        return this.m_replacement;
    }

    public void setReplacement(boolean bl) {
        this.m_replacement = bl;
    }

    public String greedySortInitializationTipText() {
        return "Whether sort initialization greedily stops adding models when performance degrades.";
    }

    public boolean getGreedySortInitialization() {
        return this.m_greedySortInitialization;
    }

    public void setGreedySortInitialization(boolean bl) {
        this.m_greedySortInitialization = bl;
    }

    public String verboseOutputTipText() {
        return "Whether metrics are printed for each model.";
    }

    public boolean getVerboseOutput() {
        return this.m_verboseOutput;
    }

    public void setVerboseOutput(boolean bl) {
        this.m_verboseOutput = bl;
    }

    public String workingDirectoryTipText() {
        return "The working directory of the ensemble - where trained models will be stored.";
    }

    public File getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public void setWorkingDirectory(File file) {
        if (this.m_Debug) {
            System.out.println("working directory changed to: " + file);
        }
        this.m_library.setWorkingDirectory(file);
        this.m_workingDirectory = file;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        int n;
        Iterator iterator;
        Object object2;
        Object object3;
        Object object4;
        this.getCapabilities().testWithFail(instances);
        if (this.m_library.m_Models.size() == 0) {
            System.out.println("WARNING: No library file specified.  Using some default models.");
            System.out.println("You should specify a model list with -L <file> from the command line.");
            System.out.println("Or edit the list directly with the LibraryEditor from the GUI");
            for (int i = 0; i < 10; ++i) {
                object4 = new REPTree();
                ((REPTree)object4).setSeed(i);
                this.m_library.addModel(new EnsembleSelectionLibraryModel((Classifier)object4));
            }
        }
        if (this.m_library == null) {
            this.m_library = new EnsembleSelectionLibrary();
            this.m_library.setDebug(this.m_Debug);
        }
        this.m_library.setNumFolds(this.getNumFolds());
        this.m_library.setValidationRatio(this.getValidationRatio());
        Instances instances2 = this.m_library.trainAll(instances, this.m_workingDirectory.getAbsolutePath(), this.m_algorithm);
        object4 = this.m_library.getHillclimbPredictions();
        int n2 = ((Object)object4).length;
        int[] nArray = new int[n2];
        this.m_total_weight = 0;
        Random random = new Random(this.m_Seed);
        if (this.m_algorithm == 4) {
            return;
        }
        if (this.m_algorithm == 3) {
            object3 = new ModelBag((double[][][])object4, 1.0, this.m_Debug);
            object2 = ((ModelBag)object3).sortInitialize(1, false, instances2, this.m_hillclimbMetric);
            nArray[object2[0]] = 1;
        } else {
            if (this.m_Debug) {
                System.out.println("Starting hillclimbing algorithm: " + this.m_algorithm);
            }
            for (int i = 0; i < this.getNumModelBags(); ++i) {
                if (this.m_Debug) {
                    System.out.println("Starting on ensemble bag: " + i);
                }
                object2 = new ModelBag((double[][][])object4, this.getModelRatio(), this.m_Debug);
                ((ModelBag)object2).shuffle(random);
                if (this.getSortInitializationRatio() > 0.0) {
                    ((ModelBag)object2).sortInitialize((int)(this.getSortInitializationRatio() * this.getModelRatio() * (double)n2), this.getGreedySortInitialization(), instances2, this.m_hillclimbMetric);
                }
                if (this.m_algorithm == 1) {
                    ((ModelBag)object2).weightAll(1);
                }
                for (int j = 0; j < this.getHillclimbIterations(); ++j) {
                    if (this.m_algorithm == 0) {
                        ((ModelBag)object2).forwardSelect(this.getReplacement(), instances2, this.m_hillclimbMetric);
                        continue;
                    }
                    if (this.m_algorithm == 1) {
                        ((ModelBag)object2).backwardEliminate(instances2, this.m_hillclimbMetric);
                        continue;
                    }
                    if (this.m_algorithm != 2) continue;
                    ((ModelBag)object2).forwardSelectOrBackwardEliminate(this.getReplacement(), instances2, this.m_hillclimbMetric);
                }
                iterator = (Iterator)((ModelBag)object2).getModelWeights();
                for (n = 0; n < ((Object)iterator).length; ++n) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + iterator[n];
                }
            }
        }
        object3 = this.m_library.getModelNames();
        object2 = new String[this.m_library.size()];
        iterator = object3.iterator();
        n = 0;
        int n4 = 0;
        while (iterator.hasNext()) {
            object2[n] = (String)iterator.next();
            int n5 = nArray[n++];
            this.m_total_weight += n5;
            if (n5 <= 0) continue;
            ++n4;
        }
        if (this.m_verboseOutput) {
            ModelBag modelBag = new ModelBag((double[][][])object4, 1.0, this.m_Debug);
            int[] nArray2 = modelBag.sortInitialize(((Object)object2).length, false, instances2, this.m_hillclimbMetric);
            object = modelBag.getIndividualPerformance(instances2, this.m_hillclimbMetric);
            for (int i = 0; i < nArray2.length; ++i) {
                System.out.println("" + object[i] + " " + (String)object2[nArray2[i]]);
            }
        }
        this.m_chosen_models = new EnsembleSelectionLibraryModel[n4];
        this.m_chosen_model_weights = new int[n4];
        n = 0;
        int n6 = 0;
        iterator = this.m_library.getModels().iterator();
        while (iterator.hasNext()) {
            int n7 = nArray[n++];
            object = (EnsembleSelectionLibraryModel)iterator.next();
            if (n7 <= 0) continue;
            this.m_chosen_models[n6] = object;
            this.m_chosen_model_weights[n6] = n7;
            ++n6;
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        String string = instance.toString();
        double[][] dArray = null;
        if (this.m_cachedPredictions != null && this.m_cachedPredictions.containsKey(string)) {
            dArray = (double[][])this.m_cachedPredictions.get(string);
        }
        double[] dArray2 = new double[instance.numClasses()];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[n] = 0.0;
        }
        for (n = 0; n < this.m_chosen_models.length; ++n) {
            double[] dArray3 = null;
            if (dArray == null) {
                this.m_chosen_models[n].rehydrateModel(this.m_workingDirectory.getAbsolutePath());
                dArray3 = this.m_chosen_models[n].getAveragePrediction(instance);
            } else {
                dArray3 = dArray[n];
            }
            if (dArray3 == null) continue;
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] + (double)this.m_chosen_model_weights[n] * dArray3[i] / (double)this.m_total_weight;
            }
        }
        if (instance.classAttribute().isNominal() && Utils.sum(dArray2) > 0.0) {
            Utils.normalize(dArray2);
        }
        return dArray2;
    }

    private boolean validWorkingDirectory(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory() && file.canWrite()) {
                bl = true;
            }
        } else if (file.canWrite()) {
            bl = true;
        }
        return bl;
    }

    public static String getDefaultWorkingDirectory() {
        String string = new String("");
        boolean bl = false;
        for (int i = 1; i < 1000 && !bl; ++i) {
            File file = new File(System.getProperty("user.home"), "Ensemble-" + i);
            if (file.exists() || !file.getParentFile().canWrite()) continue;
            string = file.getPath();
            bl = true;
        }
        if (!bl) {
            string = new String("");
        }
        return string;
    }

    public String toString() {
        String string = new String();
        if (this.m_chosen_models != null) {
            for (int i = 0; i < this.m_chosen_models.length; ++i) {
                string = string + this.m_chosen_model_weights[i];
                string = string + " " + this.m_chosen_models[i].getStringRepresentation() + "\n";
            }
        } else {
            string = "No models selected.";
        }
        return string;
    }

    private void cachePredictions(Instances instances) throws Exception {
        this.m_cachedPredictions = new HashMap();
        Evaluation evaluation = null;
        Instances instances2 = null;
        boolean bl = this.getVerboseOutput();
        if (bl) {
            instances2 = new Instances(instances);
        }
        for (int i = 0; i < this.m_chosen_models.length; ++i) {
            Object object;
            if (bl) {
                evaluation = new Evaluation(instances2);
            }
            Date date = new Date();
            this.m_chosen_models[i].rehydrateModel(this.m_workingDirectory.getAbsolutePath());
            for (int j = 0; j < instances.numInstances(); ++j) {
                Instance instance = instances.instance(j);
                instance.setClassMissing();
                String string = instance.toString();
                if (!this.m_cachedPredictions.containsKey(string)) {
                    int n = instances.classAttribute().isNumeric() ? 1 : instances.classAttribute().numValues();
                    double[][] dArray = new double[this.m_chosen_models.length][n];
                    this.m_cachedPredictions.put(string, dArray);
                }
                object = (double[][])this.m_cachedPredictions.get(string);
                object[i] = this.m_chosen_models[i].getAveragePrediction(instances.instance(j));
                if (!bl) continue;
                evaluation.evaluateModelOnceAndRecordPrediction(object[i], instances2.instance(j));
            }
            this.m_chosen_models[i].releaseModel();
            Date date2 = new Date();
            long l = date2.getTime() - date.getTime();
            if (this.m_Debug) {
                System.out.println("Test time for " + this.m_chosen_models[i].getStringRepresentation() + " was: " + l);
            }
            if (!bl) continue;
            object = new String(this.m_chosen_models[i].getStringRepresentation() + ": ");
            object = (String)object + "\tRMSE:" + evaluation.rootMeanSquaredError();
            object = (String)object + "\tACC:" + evaluation.pctCorrect();
            if (instances.numClasses() == 2) {
                object = (String)object + "\tROC:" + evaluation.areaUnderROC(1);
                object = (String)object + "\tPREC:" + evaluation.precision(1);
                object = (String)object + "\tFSCR:" + evaluation.fMeasure(1);
            }
            System.out.println((String)object);
        }
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Rich Caruana, Alex Niculescu, Geoff Crew, and Alex Ksikes");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Ensemble Selection from Libraries of Models");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "21st International Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        return technicalInformation;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5526 $");
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = (String[])stringArray.clone();
            String string = Utils.getOption("xml", stringArray2);
            if (!string.equals("")) {
                stringArray2 = new XMLOptions(string).toArray();
            }
            String string2 = Utils.getOption('t', stringArray2);
            String string3 = Utils.getOption('l', stringArray2);
            String string4 = Utils.getOption('T', stringArray2);
            if (string4.length() != 0 && string3.length() != 0 && string2.length() == 0) {
                Object object;
                System.out.println("Caching predictions");
                EnsembleSelection ensembleSelection = null;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
                int n = -1;
                String string5 = Utils.getOption('c', stringArray2);
                if (string5.length() != 0) {
                    n = Integer.parseInt(string5);
                }
                Instances instances = new Instances(bufferedReader, 1);
                if (n != -1) {
                    instances.setClassIndex(n - 1);
                } else {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                if (n > instances.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
                while (instances.readInstance(bufferedReader)) {
                }
                bufferedReader.close();
                InputStream inputStream = new FileInputStream(string3);
                if (string3.endsWith(".gz")) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                if (!string3.endsWith("UpdateableClassifier.koml") || !KOML.isPresent()) {
                    object = new ObjectInputStream(inputStream);
                    ensembleSelection = (EnsembleSelection)((ObjectInputStream)object).readObject();
                    ((ObjectInputStream)object).close();
                } else {
                    object = new BufferedInputStream(inputStream);
                    ensembleSelection = (EnsembleSelection)KOML.read((InputStream)object);
                    ((BufferedInputStream)object).close();
                }
                object = Utils.getOption('W', stringArray);
                if (!((String)object).equals("")) {
                    ensembleSelection.setWorkingDirectory(new File((String)object));
                }
                ensembleSelection.setDebug(Utils.getFlag('D', stringArray));
                ensembleSelection.setVerboseOutput(Utils.getFlag('O', stringArray));
                ensembleSelection.cachePredictions(instances);
                String string6 = string3;
                OutputStream outputStream = new FileOutputStream(string6);
                if (!(string6.endsWith(".xml") || string6.endsWith(".koml") && KOML.isPresent())) {
                    if (string6.endsWith(".gz")) {
                        outputStream = new GZIPOutputStream(outputStream);
                    }
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(ensembleSelection);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                } else {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                    if (string6.endsWith(".xml")) {
                        XMLClassifier xMLClassifier = new XMLClassifier();
                        xMLClassifier.write(bufferedOutputStream, (Object)ensembleSelection);
                    } else if (string6.endsWith(".koml")) {
                        KOML.write(bufferedOutputStream, (Object)ensembleSelection);
                    }
                    bufferedOutputStream.close();
                }
            }
            System.out.println(Evaluation.evaluateModel(new EnsembleSelection(), stringArray));
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().indexOf("General options") == -1) {
                exception.printStackTrace();
            }
            System.err.println(exception.getMessage());
        }
    }
}

