/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibLINEAR
extends Classifier
implements TechnicalInformationHandler {
    protected static final String CLASS_LINEAR = "liblinear.Linear";
    protected static final String CLASS_MODEL = "liblinear.Model";
    protected static final String CLASS_PROBLEM = "liblinear.Problem";
    protected static final String CLASS_PARAMETER = "liblinear.Parameter";
    protected static final String CLASS_SOLVERTYPE = "liblinear.SolverType";
    protected static final String CLASS_FEATURENODE = "liblinear.FeatureNode";
    protected static final long serialVersionUID = 230504711L;
    protected Object m_Model;
    protected Filter m_Filter = null;
    protected boolean m_Normalize = false;
    public static final int SVMTYPE_L2_LR = 0;
    public static final int SVMTYPE_L2LOSS_SVM_DUAL = 1;
    public static final int SVMTYPE_L2LOSS_SVM = 2;
    public static final int SVMTYPE_L1LOSS_SVM_DUAL = 3;
    public static final int SVMTYPE_MCSVM_CS = 4;
    public static final Tag[] TAGS_SVMTYPE = new Tag[]{new Tag(0, "L2-regularized logistic regression"), new Tag(1, "L2-loss support vector machines (dual)"), new Tag(2, "L2-loss support vector machines (primal)"), new Tag(3, "L1-loss support vector machines (dual)"), new Tag(4, "multi-class support vector machines by Crammer and Singer")};
    protected int m_SVMType = 1;
    protected double m_eps = 0.01;
    protected double m_Cost = 1.0;
    protected double m_Bias = 1.0;
    protected int[] m_WeightLabel = new int[0];
    protected double[] m_Weight = new double[0];
    protected boolean m_ProbabilityEstimates = false;
    protected ReplaceMissingValues m_ReplaceMissingValues;
    protected NominalToBinary m_NominalToBinary;
    private boolean m_nominalToBinary = false;
    private boolean m_noReplaceMissingValues;
    protected static boolean m_Present = false;

    public Object getModel() {
        return this.m_Model;
    }

    public String globalInfo() {
        return "A wrapper class for the liblinear tools (the liblinear classes, typically the jar file, need to be in the classpath to use this classifier).\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Rong-En Fan and Kai-Wei Chang and Cho-Jui Hsieh and Xiang-Rui Wang and Chih-Jen Lin");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "LIBLINEAR - A Library for Large Linear Classification");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2008");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://www.csie.ntu.edu.tw/~cjlin/liblinear/");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "The Weka classifier works with version 1.33 of LIBLINEAR");
        return technicalInformation;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet type of solver (default: 1)\n\t\t 0 = L2-regularized logistic regression\n\t\t 1 = L2-loss support vector machines (dual)\n\t\t 2 = L2-loss support vector machines (primal)\n\t\t 3 = L1-loss support vector machines (dual)\n\t\t 4 = multi-class support vector machines by Crammer and Singer", "S", 1, "-S <int>"));
        vector.addElement(new Option("\tSet the cost parameter C\n\t (default: 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tTurn on normalization of input data (default: off)", "Z", 0, "-Z"));
        vector.addElement(new Option("\tTurn on nominal to binary conversion.", "N", 0, "-N"));
        vector.addElement(new Option("\tTurn off missing value replacement.\n\tWARNING: use only if your data has no missing values.", "M", 0, "-M"));
        vector.addElement(new Option("\tUse probability estimation (default: off)\ncurrently for L2-regularized logistic regression only! ", "P", 0, "-P"));
        vector.addElement(new Option("\tSet tolerance of termination criterion (default: 0.01)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tSet the parameters C of class i to weight[i]*C\n\t (default: 1)", "W", 1, "-W <double>"));
        vector.addElement(new Option("\tAdd Bias term with the given value if >= 0; if < 0, no bias term added (default: 1)", "B", 1, "-B <double>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    @Override
    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSVMType(new SelectedTag(Integer.parseInt(string), TAGS_SVMTYPE));
        } else {
            this.setSVMType(new SelectedTag(1, TAGS_SVMTYPE));
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setCost(Double.parseDouble(string));
        } else {
            this.setCost(1.0);
        }
        string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setEps(Double.parseDouble(string));
        } else {
            this.setEps(0.001);
        }
        this.setNormalize(Utils.getFlag('Z', stringArray));
        this.setConvertNominalToBinary(Utils.getFlag('N', stringArray));
        this.setDoNotReplaceMissingValues(Utils.getFlag('M', stringArray));
        string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setBias(Double.parseDouble(string));
        } else {
            this.setBias(1.0);
        }
        this.setWeights(Utils.getOption('W', stringArray));
        this.setProbabilityEstimates(Utils.getFlag('P', stringArray));
        super.setOptions(stringArray);
    }

    @Override
    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.m_SVMType);
        vector.add("-C");
        vector.add("" + this.getCost());
        vector.add("-E");
        vector.add("" + this.getEps());
        vector.add("-B");
        vector.add("" + this.getBias());
        if (this.getNormalize()) {
            vector.add("-Z");
        }
        if (this.getConvertNominalToBinary()) {
            vector.add("-N");
        }
        if (this.getDoNotReplaceMissingValues()) {
            vector.add("-M");
        }
        if (this.getWeights().length() != 0) {
            vector.add("-W");
            vector.add("" + this.getWeights());
        }
        if (this.getProbabilityEstimates()) {
            vector.add("-P");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public void setSVMType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SVMTYPE) {
            this.m_SVMType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getSVMType() {
        return new SelectedTag(this.m_SVMType, TAGS_SVMTYPE);
    }

    public String SVMTypeTipText() {
        return "The type of SVM to use.";
    }

    public void setCost(double d) {
        this.m_Cost = d;
    }

    public double getCost() {
        return this.m_Cost;
    }

    public String costTipText() {
        return "The cost parameter C.";
    }

    public void setEps(double d) {
        this.m_eps = d;
    }

    public double getEps() {
        return this.m_eps;
    }

    public String epsTipText() {
        return "The tolerance of the termination criterion.";
    }

    public void setBias(double d) {
        this.m_Bias = d;
    }

    public double getBias() {
        return this.m_Bias;
    }

    public String biasTipText() {
        return "If >= 0, a bias term with that value is added; otherwise (<0) no bias term is added (default: 1).";
    }

    public String normalizeTipText() {
        return "Whether to normalize the data.";
    }

    public void setNormalize(boolean bl) {
        this.m_Normalize = bl;
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String convertNominalToBinaryTipText() {
        return "Whether to turn on conversion of nominal attributes to binary.";
    }

    public void setConvertNominalToBinary(boolean bl) {
        this.m_nominalToBinary = bl;
    }

    public boolean getConvertNominalToBinary() {
        return this.m_nominalToBinary;
    }

    public String doNotReplaceMissingValuesTipText() {
        return "Whether to turn off automatic replacement of missing values. WARNING: set to true only if the data does not contain missing values.";
    }

    public void setDoNotReplaceMissingValues(boolean bl) {
        this.m_noReplaceMissingValues = bl;
    }

    public boolean getDoNotReplaceMissingValues() {
        return this.m_noReplaceMissingValues;
    }

    public void setWeights(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.m_Weight = new double[stringTokenizer.countTokens()];
        this.m_WeightLabel = new int[stringTokenizer.countTokens()];
        if (this.m_Weight.length == 0) {
            System.out.println("Zero Weights processed. Default weights will be used");
        }
        for (int i = 0; i < this.m_Weight.length; ++i) {
            this.m_Weight[i] = Double.parseDouble(stringTokenizer.nextToken());
            this.m_WeightLabel[i] = i;
        }
    }

    public String getWeights() {
        String string = "";
        for (int i = 0; i < this.m_Weight.length; ++i) {
            if (i > 0) {
                string = string + " ";
            }
            string = string + Double.toString(this.m_Weight[i]);
        }
        return string;
    }

    public String weightsTipText() {
        return "The weights to use for the classes, if empty 1 is used by default.";
    }

    public void setProbabilityEstimates(boolean bl) {
        this.m_ProbabilityEstimates = bl;
    }

    public boolean getProbabilityEstimates() {
        return this.m_ProbabilityEstimates;
    }

    public String probabilityEstimatesTipText() {
        return "Whether to generate probability estimates instead of -1/+1 for classification problems (currently for L2-regularized logistic regression only!)";
    }

    protected void setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setField(Object object, String string, int n, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            Array.set(field.get(object), n, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Object getField(Object object, String string) {
        Object object2;
        try {
            Field field = object.getClass().getField(string);
            object2 = field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    protected void newArray(Object object, String string, Class clazz, int n) {
        this.newArray(object, string, clazz, new int[]{n});
    }

    protected void newArray(Object object, String string, Class clazz, int[] nArray) {
        try {
            Field field = object.getClass().getField(string);
            field.set(object, Array.newInstance(clazz, nArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    protected Object getParameters() {
        Object var1_7;
        try {
            Class<?> clazz = Class.forName(CLASS_SOLVERTYPE);
            ?[] objArray = clazz.getEnumConstants();
            Object obj = objArray[this.m_SVMType];
            Class[] classArray = new Class[]{clazz, Double.TYPE, Double.TYPE};
            Constructor<?> constructor = Class.forName(CLASS_PARAMETER).getConstructor(classArray);
            var1_7 = constructor.newInstance(obj, this.m_Cost, this.m_eps);
            if (this.m_Weight.length > 0) {
                this.invokeMethod(var1_7, "setWeights", new Class[]{double[].class, int[].class}, new Object[]{this.m_Weight, this.m_WeightLabel});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            var1_7 = null;
        }
        return var1_7;
    }

    protected Object getProblem(List<Object> list, List<Integer> list2, int n) {
        Object obj;
        try {
            int n2;
            obj = Class.forName(CLASS_PROBLEM).newInstance();
            this.setField(obj, "l", list2.size());
            this.setField(obj, "n", n);
            this.newArray(obj, "x", Class.forName(CLASS_FEATURENODE), new int[]{list2.size(), 0});
            for (n2 = 0; n2 < list2.size(); ++n2) {
                this.setField(obj, "x", n2, list.get(n2));
            }
            this.newArray(obj, "y", Integer.TYPE, list2.size());
            for (n2 = 0; n2 < list2.size(); ++n2) {
                this.setField(obj, "y", n2, list2.get(n2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            obj = null;
        }
        return obj;
    }

    protected Object instanceToArray(Instance instance) throws Exception {
        int n;
        int n2 = 0;
        for (n = 0; n < instance.numValues(); ++n) {
            if (instance.index(n) == instance.classIndex() || instance.valueSparse(n) == 0.0) continue;
            ++n2;
        }
        if (this.m_Bias >= 0.0) {
            ++n2;
        }
        Class[] classArray = new Class[]{Integer.TYPE, Double.TYPE};
        Constructor<?> constructor = Class.forName(CLASS_FEATURENODE).getConstructor(classArray);
        Object object = Array.newInstance(Class.forName(CLASS_FEATURENODE), n2);
        int n3 = 0;
        for (n = 0; n < instance.numValues(); ++n) {
            int n4 = instance.index(n);
            double d = instance.valueSparse(n);
            if (n4 == instance.classIndex() || d == 0.0) continue;
            Object obj = constructor.newInstance(n4 + 1, d);
            Array.set(object, n3, obj);
            ++n3;
        }
        if (this.m_Bias >= 0.0) {
            Integer n5 = instance.numAttributes() + 1;
            Double d = this.m_Bias;
            Object obj = constructor.newInstance(n5, d);
            Array.set(object, n3, obj);
        }
        return object;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.getDoNotReplaceMissingValues()) {
            this.m_ReplaceMissingValues.input(instance);
            this.m_ReplaceMissingValues.batchFinished();
            instance = this.m_ReplaceMissingValues.output();
        }
        if (this.getConvertNominalToBinary() && this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Object object = this.instanceToArray(instance);
        double[] dArray = new double[instance.numClasses()];
        if (this.m_ProbabilityEstimates) {
            if (this.m_SVMType != 0) {
                throw new WekaException("probability estimation is currently only supported for L2-regularized logistic regression");
            }
            int[] nArray = (int[])this.invokeMethod(this.m_Model, "getLabels", null, null);
            double[] dArray2 = new double[instance.numClasses()];
            double d = ((Integer)this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "predictProbability", new Class[]{Class.forName(CLASS_MODEL), Array.newInstance(Class.forName(CLASS_FEATURENODE), Array.getLength(object)).getClass(), Array.newInstance(Double.TYPE, dArray2.length).getClass()}, new Object[]{this.m_Model, object, dArray2})).doubleValue();
            for (int i = 0; i < dArray2.length; ++i) {
                dArray[nArray[i]] = dArray2[i];
            }
        } else {
            double d = ((Integer)this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "predict", new Class[]{Class.forName(CLASS_MODEL), Array.newInstance(Class.forName(CLASS_FEATURENODE), Array.getLength(object)).getClass()}, new Object[]{this.m_Model, object})).doubleValue();
            assert (instance.classAttribute().isNominal());
            dArray[(int)d] = 1.0;
        }
        return dArray;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.m_NominalToBinary = null;
        this.m_Filter = null;
        if (!LibLINEAR.isPresent()) {
            throw new Exception("liblinear classes not in CLASSPATH!");
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (!this.getDoNotReplaceMissingValues()) {
            this.m_ReplaceMissingValues = new ReplaceMissingValues();
            this.m_ReplaceMissingValues.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_ReplaceMissingValues);
        }
        this.getCapabilities().testWithFail(instances);
        if (this.getConvertNominalToBinary()) {
            instances = this.nominalToBinary(instances);
        }
        if (this.getNormalize()) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(instances.numInstances());
        ArrayList<Object> arrayList2 = new ArrayList<Object>(instances.numInstances());
        int n = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Object object = this.instanceToArray(instance);
            int n2 = Array.getLength(object);
            if (n2 > 0) {
                n = Math.max(n, (Integer)this.getField(Array.get(object, n2 - 1), "index"));
            }
            arrayList2.add(object);
            double d = instance.classValue();
            int n3 = (int)d;
            if ((double)n3 != d) {
                throw new RuntimeException("unsupported class value: " + d);
            }
            arrayList.add(n3);
        }
        if (!this.m_Debug) {
            this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "disableDebugOutput", null, null);
        } else {
            this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "enableDebugOutput", null, null);
        }
        this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "resetRandom", null, null);
        this.m_Model = this.invokeMethod(Class.forName(CLASS_LINEAR).newInstance(), "train", new Class[]{Class.forName(CLASS_PROBLEM), Class.forName(CLASS_PARAMETER)}, new Object[]{this.getProblem(arrayList2, arrayList, n), this.getParameters()});
    }

    private Instances nominalToBinary(Instances instances) throws Exception {
        boolean bl = true;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
            bl = false;
            break;
        }
        if (!bl) {
            this.m_NominalToBinary = new NominalToBinary();
            this.m_NominalToBinary.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        }
        return instances;
    }

    public String toString() {
        return "LibLINEAR wrapper";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5523 $");
    }

    public static void main(String[] stringArray) {
        LibLINEAR.runClassifier(new LibLINEAR(), stringArray);
    }

    static {
        try {
            Class.forName(CLASS_LINEAR);
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }
}

