/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.functions.Logistic;
import weka.classifiers.rules.ZeroR;
import weka.clusterers.MakeDensityBasedClusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ClusterMembership;
import weka.filters.unsupervised.attribute.Standardize;

public class RBFNetwork
extends Classifier
implements OptionHandler {
    static final long serialVersionUID = -3669814959712675720L;
    private Logistic m_logistic;
    private LinearRegression m_linear;
    private ClusterMembership m_basisFilter;
    private Standardize m_standardize;
    private int m_numClusters = 2;
    protected double m_ridge = 1.0E-8;
    private int m_maxIts = -1;
    private int m_clusteringSeed = 1;
    private double m_minStdDev = 0.1;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Class that implements a normalized Gaussian radial basisbasis function network.\nIt uses the k-means clustering algorithm to provide the basis functions and learns either a logistic regression (discrete class problems) or linear regression (numeric class problems) on top of that. Symmetric multivariate Gaussians are fit to the data from each cluster. If the class is nominal it uses the given number of clusters per class.It standardizes all numeric attributes to zero mean and unit variance.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Logistic().getCapabilities();
        capabilities.or(new LinearRegression().getCapabilities());
        Capabilities capabilities2 = capabilities.getClassCapabilities();
        capabilities.and(new SimpleKMeans().getCapabilities());
        capabilities.or(capabilities2);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        this.m_standardize = new Standardize();
        this.m_standardize.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_standardize);
        SimpleKMeans simpleKMeans = new SimpleKMeans();
        simpleKMeans.setNumClusters(this.m_numClusters);
        simpleKMeans.setSeed(this.m_clusteringSeed);
        MakeDensityBasedClusterer makeDensityBasedClusterer = new MakeDensityBasedClusterer();
        makeDensityBasedClusterer.setClusterer(simpleKMeans);
        makeDensityBasedClusterer.setMinStdDev(this.m_minStdDev);
        this.m_basisFilter = new ClusterMembership();
        this.m_basisFilter.setDensityBasedClusterer(makeDensityBasedClusterer);
        this.m_basisFilter.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, this.m_basisFilter);
        if (instances.classAttribute().isNominal()) {
            this.m_linear = null;
            this.m_logistic = new Logistic();
            this.m_logistic.setRidge(this.m_ridge);
            this.m_logistic.setMaxIts(this.m_maxIts);
            this.m_logistic.buildClassifier(instances2);
        } else {
            this.m_logistic = null;
            this.m_linear = new LinearRegression();
            this.m_linear.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
            this.m_linear.setRidge(this.m_ridge);
            this.m_linear.buildClassifier(instances2);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        this.m_standardize.input(instance);
        this.m_basisFilter.input(this.m_standardize.output());
        Instance instance2 = this.m_basisFilter.output();
        return instance.classAttribute().isNominal() ? this.m_logistic.distributionForInstance(instance2) : this.m_linear.distributionForInstance(instance2);
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_basisFilter == null) {
            return "No classifier built yet!";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Radial basis function network\n");
        stringBuffer.append(this.m_linear == null ? "(Logistic regression " : "(Linear regression ");
        stringBuffer.append("applied to K-means clusters as basis functions):\n\n");
        stringBuffer.append(this.m_linear == null ? this.m_logistic.toString() : this.m_linear.toString());
        return stringBuffer.toString();
    }

    public String maxItsTipText() {
        return "Maximum number of iterations for the logistic regression to perform. Only applied to discrete class problems.";
    }

    public int getMaxIts() {
        return this.m_maxIts;
    }

    public void setMaxIts(int n) {
        this.m_maxIts = n;
    }

    public String ridgeTipText() {
        return "Set the Ridge value for the logistic or linear regression.";
    }

    public void setRidge(double d) {
        this.m_ridge = d;
    }

    public double getRidge() {
        return this.m_ridge;
    }

    public String numClustersTipText() {
        return "The number of clusters for K-Means to generate.";
    }

    public void setNumClusters(int n) {
        if (n > 0) {
            this.m_numClusters = n;
        }
    }

    public int getNumClusters() {
        return this.m_numClusters;
    }

    public String clusteringSeedTipText() {
        return "The random seed to pass on to K-means.";
    }

    public void setClusteringSeed(int n) {
        this.m_clusteringSeed = n;
    }

    public int getClusteringSeed() {
        return this.m_clusteringSeed;
    }

    public String minStdDevTipText() {
        return "Sets the minimum standard deviation for the clusters.";
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    public void setMinStdDev(double d) {
        this.m_minStdDev = d;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tSet the number of clusters (basis functions) to generate. (default = 2).", "B", 1, "-B <number>"));
        vector.addElement(new Option("\tSet the random seed to be used by K-means. (default = 1).", "S", 1, "-S <seed>"));
        vector.addElement(new Option("\tSet the ridge value for the logistic or linear regression.", "R", 1, "-R <ridge>"));
        vector.addElement(new Option("\tSet the maximum number of iterations for the logistic regression. (default -1, until convergence).", "M", 1, "-M <number>"));
        vector.addElement(new Option("\tSet the minimum standard deviation for the clusters. (default 0.1).", "W", 1, "-W <number>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        String string2;
        this.setDebug(Utils.getFlag('D', stringArray));
        String string3 = Utils.getOption('R', stringArray);
        this.m_ridge = string3.length() != 0 ? Double.parseDouble(string3) : 1.0E-8;
        String string4 = Utils.getOption('M', stringArray);
        this.m_maxIts = string4.length() != 0 ? Integer.parseInt(string4) : -1;
        String string5 = Utils.getOption('B', stringArray);
        if (string5.length() != 0) {
            this.setNumClusters(Integer.parseInt(string5));
        }
        if ((string2 = Utils.getOption('S', stringArray)).length() != 0) {
            this.setClusteringSeed(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('W', stringArray)).length() != 0) {
            this.setMinStdDev(Double.parseDouble(string));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.m_numClusters;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_clusteringSeed;
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.m_ridge;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_maxIts;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.m_minStdDev;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }

    public static void main(String[] stringArray) {
        RBFNetwork.runClassifier(new RBFNetwork(), stringArray);
    }
}

