/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.trees.ft.FTInnerNode;
import weka.classifiers.trees.ft.FTLeavesNode;
import weka.classifiers.trees.ft.FTNode;
import weka.classifiers.trees.ft.FTtree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FT
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
Drawable,
TechnicalInformationHandler {
    static final long serialVersionUID = -1113212459618105000L;
    protected ReplaceMissingValues m_replaceMissing;
    protected NominalToBinary m_nominalToBinary;
    protected FTtree m_tree;
    protected boolean m_convertNominal;
    protected boolean m_errorOnProbabilities;
    protected int m_minNumInstances = 15;
    protected int m_numBoostingIterations = 15;
    protected int m_modelType = 0;
    protected double m_weightTrimBeta = 0.0;
    protected boolean m_useAIC = false;
    public static final int MODEL_FT = 0;
    public static final int MODEL_FTLeaves = 1;
    public static final int MODEL_FTInner = 2;
    public static final Tag[] TAGS_MODEL = new Tag[]{new Tag(0, "FT"), new Tag(1, "FTLeaves"), new Tag(2, "FTInner")};

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        Instances instances2 = new Instances(instances);
        instances2.deleteWithMissingClass();
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, this.m_replaceMissing);
        if (this.m_convertNominal) {
            this.m_nominalToBinary = new NominalToBinary();
            this.m_nominalToBinary.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_nominalToBinary);
        }
        int n = 2;
        if (this.m_modelType == 0) {
            this.m_tree = new FTNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        if (this.m_modelType == 1) {
            this.m_tree = new FTLeavesNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        if (this.m_modelType == 2) {
            this.m_tree = new FTInnerNode(this.m_errorOnProbabilities, this.m_numBoostingIterations, this.m_minNumInstances, this.m_weightTrimBeta, this.m_useAIC);
        }
        this.m_tree.buildClassifier(instances2);
        this.m_tree.prune();
        this.m_tree.assignIDs(0);
        this.m_tree.cleanup();
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_replaceMissing.input(instance);
        instance = this.m_replaceMissing.output();
        if (this.m_convertNominal) {
            this.m_nominalToBinary.input(instance);
            instance = this.m_nominalToBinary.output();
        }
        return this.m_tree.distributionForInstance(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        double d = -1.0;
        int n = 0;
        double[] dArray = this.distributionForInstance(instance);
        for (int i = 0; i < instance.numClasses(); ++i) {
            if (!Utils.gr(dArray[i], d)) continue;
            n = i;
            d = dArray[i];
        }
        return n;
    }

    public String toString() {
        if (this.m_tree != null) {
            if (this.m_modelType == 0) {
                return "FT tree \n------------------\n" + this.m_tree.toString();
            }
            if (this.m_modelType == 1) {
                return "FT Leaves tree \n------------------\n" + this.m_tree.toString();
            }
            return "FT Inner tree \n------------------\n" + this.m_tree.toString();
        }
        return "No tree built";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(8);
        vector.addElement(new Option("\tBinary splits (convert nominal attributes to binary ones) ", "B", 0, "-B"));
        vector.addElement(new Option("\tUse error on probabilities instead of misclassification error for stopping criterion of LogitBoost.", "P", 0, "-P"));
        vector.addElement(new Option("\tSet fixed number of iterations for LogitBoost (instead of using cross-validation)", "I", 1, "-I <numIterations>"));
        vector.addElement(new Option("\tSet Funtional Tree type to be generate:  0 for FT, 1 for FTLeaves and 2 for FTInner", "F", 1, "-F <modelType>"));
        vector.addElement(new Option("\tSet minimum number of instances at which a node can be split (default 15)", "M", 1, "-M <numInstances>"));
        vector.addElement(new Option("\tSet beta for weight trimming for LogitBoost. Set to 0 (default) for no weight trimming.", "W", 1, "-W <beta>"));
        vector.addElement(new Option("\tThe AIC is used to choose the best iteration.", "A", 0, "-A"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setBinSplit(Utils.getFlag('B', stringArray));
        this.setErrorOnProbabilities(Utils.getFlag('P', stringArray));
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumBoostingIterations(new Integer(string));
        }
        if ((string = Utils.getOption('F', stringArray)).length() != 0) {
            this.setModelType(new SelectedTag(Integer.parseInt(string), TAGS_MODEL));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMinNumInstances(new Integer(string));
        }
        if ((string = Utils.getOption('W', stringArray)).length() != 0) {
            this.setWeightTrimBeta(new Double(string));
        }
        this.setUseAIC(Utils.getFlag('A', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[11];
        int n = 0;
        if (this.getBinSplit()) {
            stringArray[n++] = "-B";
        }
        if (this.getErrorOnProbabilities()) {
            stringArray[n++] = "-P";
        }
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumBoostingIterations();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getModelType().getSelectedTag().getID();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinNumInstances();
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getWeightTrimBeta();
        if (this.getUseAIC()) {
            stringArray[n++] = "-A";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public double getWeightTrimBeta() {
        return this.m_weightTrimBeta;
    }

    public boolean getUseAIC() {
        return this.m_useAIC;
    }

    public void setWeightTrimBeta(double d) {
        this.m_weightTrimBeta = d;
    }

    public void setUseAIC(boolean bl) {
        this.m_useAIC = bl;
    }

    public boolean getBinSplit() {
        return this.m_convertNominal;
    }

    public boolean getErrorOnProbabilities() {
        return this.m_errorOnProbabilities;
    }

    public int getNumBoostingIterations() {
        return this.m_numBoostingIterations;
    }

    public SelectedTag getModelType() {
        return new SelectedTag(this.m_modelType, TAGS_MODEL);
    }

    public void setModelType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MODEL) {
            int n = selectedTag.getSelectedTag().getID();
            if (n == 0 || n == 1 || n == 2) {
                this.m_modelType = n;
            } else {
                throw new IllegalArgumentException("Wrong model type, -F value should be: 0, for FT, 1, for FTLeaves, and 2, for FTInner ");
            }
        }
    }

    public int getMinNumInstances() {
        return this.m_minNumInstances;
    }

    public void setBinSplit(boolean bl) {
        this.m_convertNominal = bl;
    }

    public void setErrorOnProbabilities(boolean bl) {
        this.m_errorOnProbabilities = bl;
    }

    public void setNumBoostingIterations(int n) {
        this.m_numBoostingIterations = n;
    }

    public void setMinNumInstances(int n) {
        this.m_minNumInstances = n;
    }

    public int graphType() {
        return 1;
    }

    public String graph() throws Exception {
        return this.m_tree.graph();
    }

    public int measureTreeSize() {
        return this.m_tree.numNodes();
    }

    public int measureNumLeaves() {
        return this.m_tree.numLeaves();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(2);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        if (string.compareToIgnoreCase("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(string + " not supported (FT)");
    }

    public String globalInfo() {
        return "Classifier for building 'Functional trees', which are classification trees  that could have logistic regression functions at the inner nodes and/or leaves. The algorithm can deal with binary and multi-class target variables, numeric and nominal attributes and missing values.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Joao Gama");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Functional Trees");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "55");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "219-250");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "3");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.ARTICLE);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Niels Landwehr and Mark Hall and Eibe Frank");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Logistic Model Trees");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation2.setValue(TechnicalInformation.Field.VOLUME, "95");
        technicalInformation2.setValue(TechnicalInformation.Field.PAGES, "161-205");
        technicalInformation2.setValue(TechnicalInformation.Field.NUMBER, "1-2");
        return technicalInformation;
    }

    public String modelTypeTipText() {
        return "The type of FT model. 0, for FT, 1, for FTLeaves, and 2, for FTInner";
    }

    public String binSplitTipText() {
        return "Convert all nominal attributes to binary ones before building the tree. This means that all splits in the final tree will be binary.";
    }

    public String errorOnProbabilitiesTipText() {
        return "Minimize error on probabilities instead of misclassification error when cross-validating the number of LogitBoost iterations. When set, the number of LogitBoost iterations is chosen that minimizes the root mean squared error instead of the misclassification error.";
    }

    public String numBoostingIterationsTipText() {
        return "Set a fixed number of iterations for LogitBoost. If >= 0, this sets a fixed number of LogitBoost iterations that is used everywhere in the tree. If < 0, the number is cross-validated.";
    }

    public String minNumInstancesTipText() {
        return "Set the minimum number of instances at which a node is considered for splitting. The default value is 15.";
    }

    public String weightTrimBetaTipText() {
        return "Set the beta value used for weight trimming in LogitBoost. Only instances carrying (1 - beta)% of the weight from previous iteration are used in the next iteration. Set to 0 for no weight trimming. The default value is 0.";
    }

    public String useAICTipText() {
        return "The AIC is used to determine when to stop LogitBoost iterations. The default is not to use AIC.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] stringArray) {
        FT.runClassifier(new FT(), stringArray);
    }
}

