/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.NoSupportForMissingValuesException;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnassignedClassException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.converters.ConverterUtils;

public class Capabilities
implements Cloneable,
Serializable,
RevisionHandler {
    static final long serialVersionUID = -5478590032325567849L;
    public static final String PROPERTIES_FILE = "weka/core/Capabilities.props";
    protected static Properties PROPERTIES;
    private static final int ATTRIBUTE = 1;
    private static final int CLASS = 2;
    private static final int ATTRIBUTE_CAPABILITY = 4;
    private static final int CLASS_CAPABILITY = 8;
    private static final int OTHER_CAPABILITY = 16;
    protected CapabilitiesHandler m_Owner;
    protected HashSet m_Capabilities;
    protected HashSet m_Dependencies;
    protected Exception m_FailReason = null;
    protected int m_MinimumNumberInstances = 1;
    protected boolean m_Test;
    protected boolean m_InstancesTest;
    protected boolean m_AttributeTest;
    protected boolean m_MissingValuesTest;
    protected boolean m_MissingClassValuesTest;
    protected boolean m_MinimumNumberInstancesTest;

    public Capabilities(CapabilitiesHandler capabilitiesHandler) {
        this.setOwner(capabilitiesHandler);
        this.m_Capabilities = new HashSet();
        this.m_Dependencies = new HashSet();
        if (PROPERTIES == null) {
            try {
                PROPERTIES = Utils.readProperties(PROPERTIES_FILE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                PROPERTIES = new Properties();
            }
        }
        this.m_Test = Boolean.parseBoolean(PROPERTIES.getProperty("Test", "true"));
        this.m_InstancesTest = Boolean.parseBoolean(PROPERTIES.getProperty("InstancesTest", "true")) && this.m_Test;
        this.m_AttributeTest = Boolean.parseBoolean(PROPERTIES.getProperty("AttributeTest", "true")) && this.m_Test;
        this.m_MissingValuesTest = Boolean.parseBoolean(PROPERTIES.getProperty("MissingValuesTest", "true")) && this.m_Test;
        this.m_MissingClassValuesTest = Boolean.parseBoolean(PROPERTIES.getProperty("MissingClassValuesTest", "true")) && this.m_Test;
        this.m_MinimumNumberInstancesTest = Boolean.parseBoolean(PROPERTIES.getProperty("MinimumNumberInstancesTest", "true")) && this.m_Test;
    }

    public Object clone() {
        Capabilities capabilities = new Capabilities(this.m_Owner);
        capabilities.assign(this);
        return capabilities;
    }

    public void assign(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (capabilities.handles(capability)) {
                this.enable(capability);
            } else {
                this.disable(capability);
            }
            if (capabilities.hasDependency(capability)) {
                this.enableDependency(capability);
                continue;
            }
            this.disableDependency(capability);
        }
        this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
    }

    public void and(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (this.handles(capability) && capabilities.handles(capability)) {
                this.m_Capabilities.add(capability);
            } else {
                this.m_Capabilities.remove((Object)capability);
            }
            if (this.hasDependency(capability) && capabilities.hasDependency(capability)) {
                this.m_Dependencies.add(capability);
                continue;
            }
            this.m_Dependencies.remove((Object)capability);
        }
        if (capabilities.getMinimumNumberInstances() > this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
        }
    }

    public void or(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (this.handles(capability) || capabilities.handles(capability)) {
                this.m_Capabilities.add(capability);
            } else {
                this.m_Capabilities.remove((Object)capability);
            }
            if (this.hasDependency(capability) || capabilities.hasDependency(capability)) {
                this.m_Dependencies.add(capability);
                continue;
            }
            this.m_Dependencies.remove((Object)capability);
        }
        if (capabilities.getMinimumNumberInstances() < this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
        }
    }

    public boolean supports(Capabilities capabilities) {
        boolean bl = true;
        for (Capability capability : Capability.values()) {
            if (!capabilities.handles(capability) || this.handles(capability)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean supportsMaybe(Capabilities capabilities) {
        boolean bl = true;
        for (Capability capability : Capability.values()) {
            if (!capabilities.handles(capability) || this.handles(capability) || this.hasDependency(capability)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setOwner(CapabilitiesHandler capabilitiesHandler) {
        this.m_Owner = capabilitiesHandler;
    }

    public CapabilitiesHandler getOwner() {
        return this.m_Owner;
    }

    public void setMinimumNumberInstances(int n) {
        if (n >= 0) {
            this.m_MinimumNumberInstances = n;
        }
    }

    public int getMinimumNumberInstances() {
        return this.m_MinimumNumberInstances;
    }

    public Iterator capabilities() {
        return this.m_Capabilities.iterator();
    }

    public Iterator dependencies() {
        return this.m_Dependencies.iterator();
    }

    public void enable(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.enable(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.BINARY_ATTRIBUTES) {
            this.enable(Capability.UNARY_ATTRIBUTES);
        } else if (capability == Capability.UNARY_ATTRIBUTES) {
            this.enable(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.enable(Capability.BINARY_CLASS);
        }
        this.m_Capabilities.add(capability);
    }

    public void enableDependency(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.enableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.BINARY_ATTRIBUTES) {
            this.enableDependency(Capability.UNARY_ATTRIBUTES);
        } else if (capability == Capability.UNARY_ATTRIBUTES) {
            this.enableDependency(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.enableDependency(Capability.BINARY_CLASS);
        }
        this.m_Dependencies.add(capability);
    }

    public void enableAllClasses() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.enable(capability);
        }
    }

    public void enableAllClassDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.enableDependency(capability);
        }
    }

    public void enableAllAttributes() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.enable(capability);
        }
    }

    public void enableAllAttributeDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.enableDependency(capability);
        }
    }

    public void enableAll() {
        this.enableAllAttributes();
        this.enableAllAttributeDependencies();
        this.enableAllClasses();
        this.enableAllClassDependencies();
    }

    public void disable(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.disable(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.BINARY_ATTRIBUTES) {
            this.disable(Capability.UNARY_ATTRIBUTES);
        } else if (capability == Capability.UNARY_ATTRIBUTES) {
            this.disable(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.disable(Capability.BINARY_CLASS);
        } else if (capability == Capability.BINARY_CLASS) {
            this.disable(Capability.UNARY_CLASS);
        } else if (capability == Capability.UNARY_CLASS) {
            this.disable(Capability.EMPTY_NOMINAL_CLASS);
        }
        this.m_Capabilities.remove((Object)capability);
    }

    public void disableDependency(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.disableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.BINARY_ATTRIBUTES) {
            this.disableDependency(Capability.UNARY_ATTRIBUTES);
        } else if (capability == Capability.UNARY_ATTRIBUTES) {
            this.disableDependency(Capability.EMPTY_NOMINAL_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.disableDependency(Capability.BINARY_CLASS);
        } else if (capability == Capability.BINARY_CLASS) {
            this.disableDependency(Capability.UNARY_CLASS);
        } else if (capability == Capability.UNARY_CLASS) {
            this.disableDependency(Capability.EMPTY_NOMINAL_CLASS);
        }
        this.m_Dependencies.remove((Object)capability);
    }

    public void disableAllClasses() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.disable(capability);
        }
    }

    public void disableAllClassDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.disableDependency(capability);
        }
    }

    public void disableAllAttributes() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.disable(capability);
        }
    }

    public void disableAllAttributeDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.disableDependency(capability);
        }
    }

    public void disableAll() {
        this.disableAllAttributes();
        this.disableAllAttributeDependencies();
        this.disableAllClasses();
        this.disableAllClassDependencies();
    }

    public Capabilities getClassCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isClassCapability() || !this.handles(capability)) continue;
            capabilities.m_Capabilities.add(capability);
        }
        return capabilities;
    }

    public Capabilities getAttributeCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isAttributeCapability() || !this.handles(capability)) continue;
            capabilities.m_Capabilities.add(capability);
        }
        return capabilities;
    }

    public Capabilities getOtherCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isOtherCapability() || !this.handles(capability)) continue;
            capabilities.m_Capabilities.add(capability);
        }
        return capabilities;
    }

    public boolean handles(Capability capability) {
        return this.m_Capabilities.contains((Object)capability);
    }

    public boolean hasDependency(Capability capability) {
        return this.m_Dependencies.contains((Object)capability);
    }

    public boolean hasDependencies() {
        return this.m_Dependencies.size() > 0;
    }

    public Exception getFailReason() {
        return this.m_FailReason;
    }

    protected String createMessage(String string) {
        String string2 = "";
        string2 = this.getOwner() != null ? this.getOwner().getClass().getName() : "<anonymous>";
        string2 = string2 + ": " + string;
        return string2;
    }

    public boolean test(Attribute attribute) {
        return this.test(attribute, false);
    }

    public boolean test(Attribute attribute, boolean bl) {
        boolean bl2 = true;
        if (!this.m_AttributeTest) {
            return bl2;
        }
        String string = bl ? "class" : "attributes";
        switch (attribute.type()) {
            case 1: {
                Capability capability;
                Capability capability2;
                Capability capability3;
                Capability capability4;
                if (bl) {
                    capability4 = Capability.NOMINAL_CLASS;
                    capability3 = Capability.BINARY_CLASS;
                    capability2 = Capability.UNARY_CLASS;
                    capability = Capability.EMPTY_NOMINAL_CLASS;
                } else {
                    capability4 = Capability.NOMINAL_ATTRIBUTES;
                    capability3 = Capability.BINARY_ATTRIBUTES;
                    capability2 = Capability.UNARY_ATTRIBUTES;
                    capability = Capability.EMPTY_NOMINAL_ATTRIBUTES;
                }
                if (this.handles(capability4) && attribute.numValues() > 2 || this.handles(capability3) && attribute.numValues() == 2 || this.handles(capability2) && attribute.numValues() == 1 || this.handles(capability) && attribute.numValues() == 0) break;
                if (attribute.numValues() == 0) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle empty nominal " + string + "!"));
                    bl2 = false;
                }
                if (attribute.numValues() == 1) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle unary " + string + "!"));
                    bl2 = false;
                    break;
                }
                if (attribute.numValues() == 2) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle binary " + string + "!"));
                    bl2 = false;
                    break;
                }
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle multi-valued nominal " + string + "!"));
                bl2 = false;
                break;
            }
            case 0: {
                Capability capability = bl ? Capability.NUMERIC_CLASS : Capability.NUMERIC_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle numeric " + string + "!"));
                bl2 = false;
                break;
            }
            case 3: {
                Capability capability = bl ? Capability.DATE_CLASS : Capability.DATE_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle date " + string + "!"));
                bl2 = false;
                break;
            }
            case 2: {
                Capability capability = bl ? Capability.STRING_CLASS : Capability.STRING_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle string " + string + "!"));
                bl2 = false;
                break;
            }
            case 4: {
                Capability capability = bl ? Capability.RELATIONAL_CLASS : Capability.RELATIONAL_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle relational " + string + "!"));
                bl2 = false;
                break;
            }
            default: {
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle unknown attribute type '" + attribute.type() + "'!"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean test(Instances instances) {
        return this.test(instances, 0, instances.numAttributes() - 1);
    }

    public boolean test(Instances instances, int n, int n2) {
        Capabilities capabilities;
        Attribute attribute;
        int n3;
        if (!this.m_InstancesTest) {
            return true;
        }
        if (this.m_Capabilities.size() == 0 || this.m_Capabilities.size() == 1 && this.handles(Capability.NO_CLASS)) {
            System.err.println(this.createMessage("No capabilities set!"));
        }
        if (n2 - n < 0) {
            this.m_FailReason = new WekaException(this.createMessage("No attributes!"));
            return false;
        }
        boolean bl = instances.classIndex() > -1 && instances.classIndex() >= n && instances.classIndex() <= n2;
        for (n3 = n; n3 <= n2; ++n3) {
            attribute = instances.attribute(n3);
            if (n3 == instances.classIndex() || this.test(attribute)) continue;
            return false;
        }
        if (!this.handles(Capability.NO_CLASS) && instances.classIndex() == -1) {
            this.m_FailReason = new UnassignedClassException(this.createMessage("Class attribute not set!"));
            return false;
        }
        if (this.handles(Capability.NO_CLASS) && instances.classIndex() > -1) {
            capabilities = this.getClassCapabilities();
            capabilities.disable(Capability.NO_CLASS);
            Iterator iterator = capabilities.capabilities();
            if (!iterator.hasNext()) {
                this.m_FailReason = new WekaException(this.createMessage("Cannot handle any class attribute!"));
                return false;
            }
        }
        if (bl && !this.handles(Capability.NO_CLASS)) {
            attribute = instances.classAttribute();
            if (!this.test(attribute, true)) {
                return false;
            }
            if (this.m_MissingClassValuesTest) {
                if (!this.handles(Capability.MISSING_CLASS_VALUES)) {
                    for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                        if (!instances.instance(n3).classIsMissing()) continue;
                        this.m_FailReason = new WekaException(this.createMessage("Cannot handle missing class values!"));
                        return false;
                    }
                } else if (this.m_MinimumNumberInstancesTest) {
                    int n4 = 0;
                    for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                        if (instances.instance(n3).classIsMissing()) continue;
                        ++n4;
                    }
                    if (n4 < this.getMinimumNumberInstances()) {
                        this.m_FailReason = new WekaException(this.createMessage("Not enough training instances with class labels (required: " + this.getMinimumNumberInstances() + ", provided: " + n4 + ")!"));
                        return false;
                    }
                }
            }
        }
        if (this.m_MissingValuesTest && !this.handles(Capability.MISSING_VALUES)) {
            boolean bl2 = false;
            for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                int n5;
                Instance instance = instances.instance(n3);
                if (instance instanceof SparseInstance) {
                    for (int i = 0; i < instance.numValues(); ++i) {
                        n5 = instance.index(i);
                        if (n5 < n) continue;
                        if (n5 > n2) break;
                        if (n5 == instance.classIndex() || !instance.isMissing(n5)) continue;
                        bl2 = true;
                        break;
                    }
                } else {
                    for (n5 = n; n5 <= n2; ++n5) {
                        if (n5 == instance.classIndex() || !instance.isMissing(n5)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) continue;
                this.m_FailReason = new NoSupportForMissingValuesException(this.createMessage("Cannot handle missing values!"));
                return false;
            }
        }
        if (this.m_MinimumNumberInstancesTest && instances.numInstances() < this.getMinimumNumberInstances()) {
            this.m_FailReason = new WekaException(this.createMessage("Not enough training instances (required: " + this.getMinimumNumberInstances() + ", provided: " + instances.numInstances() + ")!"));
            return false;
        }
        if (this.handles(Capability.ONLY_MULTIINSTANCE)) {
            if (instances.numAttributes() != 3) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'bag-id, bag, class'!"));
                return false;
            }
            if (!instances.attribute(0).isNominal() || !instances.attribute(1).isRelationValued() || instances.classIndex() != instances.numAttributes() - 1) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'NOMINAL att, RELATIONAL att, CLASS att'!"));
                return false;
            }
            if (this.getOwner() instanceof MultiInstanceCapabilitiesHandler) {
                MultiInstanceCapabilitiesHandler multiInstanceCapabilitiesHandler = (MultiInstanceCapabilitiesHandler)this.getOwner();
                capabilities = multiInstanceCapabilitiesHandler.getMultiInstanceCapabilities();
                boolean bl3 = instances.numInstances() > 0 ? capabilities.test(instances.attribute(1).relation(0)) : capabilities.test(instances.attribute(1).relation());
                if (!bl3) {
                    this.m_FailReason = capabilities.m_FailReason;
                    return false;
                }
            }
        }
        return true;
    }

    public void testWithFail(Attribute attribute) throws Exception {
        this.test(attribute, false);
    }

    public void testWithFail(Attribute attribute, boolean bl) throws Exception {
        if (!this.test(attribute, bl)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances instances, int n, int n2) throws Exception {
        if (!this.test(instances, n, n2)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances instances) throws Exception {
        if (!this.test(instances)) {
            throw this.m_FailReason;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector(this.m_Capabilities);
        Collections.sort(vector);
        stringBuffer.append("Capabilities: " + vector.toString() + "\n");
        vector = new Vector(this.m_Dependencies);
        Collections.sort(vector);
        stringBuffer.append("Dependencies: " + vector.toString() + "\n");
        stringBuffer.append("min # Instance: " + this.getMinimumNumberInstances() + "\n");
        return stringBuffer.toString();
    }

    public String toSource(String string) {
        return this.toSource(string, 0);
    }

    public String toSource(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Capabilities.class.getName();
        String string3 = Capability.class.getName().replaceAll("\\$", ".");
        String string4 = "";
        for (int i = 0; i < n; ++i) {
            string4 = string4 + " ";
        }
        stringBuffer.append(string4 + string2 + " " + string + " = new " + string2 + "(this);\n");
        stringBuffer.append("\n");
        for (Capability capability : Capability.values()) {
            if (this.handles(capability)) {
                stringBuffer.append(string4 + string + ".enable(" + string3 + "." + capability.name() + ");\n");
            }
            if (!this.hasDependency(capability)) continue;
            stringBuffer.append(string4 + string + ".enableDependency(" + string3 + "." + capability.name() + ");\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append(string4 + string + ".setMinimumNumberInstances(" + this.getMinimumNumberInstances() + ");\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static Capabilities forInstances(Instances instances) throws Exception {
        return Capabilities.forInstances(instances, false);
    }

    public static Capabilities forInstances(Instances instances, boolean bl) throws Exception {
        int n;
        Capabilities capabilities = new Capabilities(null);
        if (instances.classIndex() == -1) {
            capabilities.enable(Capability.NO_CLASS);
        } else {
            switch (instances.classAttribute().type()) {
                case 1: {
                    if (instances.classAttribute().numValues() == 1) {
                        capabilities.enable(Capability.UNARY_CLASS);
                        break;
                    }
                    if (instances.classAttribute().numValues() == 2) {
                        capabilities.enable(Capability.BINARY_CLASS);
                        break;
                    }
                    capabilities.enable(Capability.NOMINAL_CLASS);
                    break;
                }
                case 0: {
                    capabilities.enable(Capability.NUMERIC_CLASS);
                    break;
                }
                case 2: {
                    capabilities.enable(Capability.STRING_CLASS);
                    break;
                }
                case 3: {
                    capabilities.enable(Capability.DATE_CLASS);
                    break;
                }
                case 4: {
                    capabilities.enable(Capability.RELATIONAL_CLASS);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeTypeException("Unknown class attribute type '" + instances.classAttribute() + "'!");
                }
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!instances.instance(n).classIsMissing()) continue;
                capabilities.enable(Capability.MISSING_CLASS_VALUES);
                break;
            }
        }
        block15: for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            switch (instances.attribute(n).type()) {
                case 1: {
                    capabilities.enable(Capability.UNARY_ATTRIBUTES);
                    if (instances.attribute(n).numValues() == 2) {
                        capabilities.enable(Capability.BINARY_ATTRIBUTES);
                        continue block15;
                    }
                    if (instances.attribute(n).numValues() <= 2) continue block15;
                    capabilities.enable(Capability.NOMINAL_ATTRIBUTES);
                    continue block15;
                }
                case 0: {
                    capabilities.enable(Capability.NUMERIC_ATTRIBUTES);
                    continue block15;
                }
                case 3: {
                    capabilities.enable(Capability.DATE_ATTRIBUTES);
                    continue block15;
                }
                case 2: {
                    capabilities.enable(Capability.STRING_ATTRIBUTES);
                    continue block15;
                }
                case 4: {
                    capabilities.enable(Capability.RELATIONAL_ATTRIBUTES);
                    continue block15;
                }
                default: {
                    throw new UnsupportedAttributeTypeException("Unknown attribute type '" + instances.attribute(n).type() + "'!");
                }
            }
        }
        boolean bl2 = false;
        for (n = 0; n < instances.numInstances(); ++n) {
            int n2;
            Instance instance = instances.instance(n);
            if (instance instanceof SparseInstance) {
                for (int i = 0; i < instance.numValues(); ++i) {
                    n2 = instance.index(i);
                    if (n2 == instance.classIndex() || !instance.isMissing(n2)) continue;
                    bl2 = true;
                    break;
                }
            } else {
                for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                    if (n2 == instance.classIndex() || !instance.isMissing(n2)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (!bl2) continue;
            capabilities.enable(Capability.MISSING_VALUES);
            break;
        }
        if (bl && instances.numAttributes() == 3 && instances.attribute(0).isNominal() && instances.attribute(1).isRelationValued() && instances.classIndex() == instances.numAttributes() - 1) {
            Capabilities capabilities2 = new Capabilities(null);
            capabilities2.or(capabilities.getClassCapabilities());
            capabilities2.enable(Capability.NOMINAL_ATTRIBUTES);
            capabilities2.enable(Capability.RELATIONAL_ATTRIBUTES);
            capabilities2.enable(Capability.ONLY_MULTIINSTANCE);
            capabilities.assign(capabilities2);
        }
        return capabilities;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("\nUsage: " + Capabilities.class.getName() + " -file <dataset> [-c <class index>]\n");
            return;
        }
        String string = Utils.getOption("file", stringArray);
        if (string.length() == 0) {
            throw new Exception("No file provided with option '-file'!");
        }
        String string2 = string;
        string = Utils.getOption("c", stringArray);
        int n = string.length() != 0 ? (string.equals("first") ? 0 : (string.equals("last") ? -2 : Integer.parseInt(string) - 1)) : -3;
        ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(string2);
        Instances instances = n == -3 ? dataSource.getDataSet() : (n == -2 ? dataSource.getDataSet(dataSource.getStructure().numAttributes() - 1) : dataSource.getDataSet(n));
        Capabilities capabilities = Capabilities.forInstances(instances);
        System.out.println("File: " + string2);
        System.out.println("Class index: " + (instances.classIndex() == -1 ? "not set" : "" + (instances.classIndex() + 1)));
        System.out.println("Capabilities:");
        Iterator iterator = capabilities.capabilities();
        while (iterator.hasNext()) {
            System.out.println("- " + iterator.next());
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5502 $");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Capability {
        NOMINAL_ATTRIBUTES(5, "Nominal attributes"),
        BINARY_ATTRIBUTES(5, "Binary attributes"),
        UNARY_ATTRIBUTES(5, "Unary attributes"),
        EMPTY_NOMINAL_ATTRIBUTES(5, "Empty nominal attributes"),
        NUMERIC_ATTRIBUTES(5, "Numeric attributes"),
        DATE_ATTRIBUTES(5, "Date attributes"),
        STRING_ATTRIBUTES(5, "String attributes"),
        RELATIONAL_ATTRIBUTES(5, "Relational attributes"),
        MISSING_VALUES(4, "Missing values"),
        NO_CLASS(8, "No class"),
        NOMINAL_CLASS(10, "Nominal class"),
        BINARY_CLASS(10, "Binary class"),
        UNARY_CLASS(10, "Unary class"),
        EMPTY_NOMINAL_CLASS(10, "Empty nominal class"),
        NUMERIC_CLASS(10, "Numeric class"),
        DATE_CLASS(10, "Date class"),
        STRING_CLASS(10, "String class"),
        RELATIONAL_CLASS(10, "Relational class"),
        MISSING_CLASS_VALUES(8, "Missing class values"),
        ONLY_MULTIINSTANCE(16, "Only multi-Instance data");

        private int m_Flags = 0;
        private String m_Display;

        private Capability(int n2, String string2) {
            this.m_Flags = n2;
            this.m_Display = string2;
        }

        public boolean isAttribute() {
            return (this.m_Flags & 1) == 1;
        }

        public boolean isClass() {
            return (this.m_Flags & 2) == 2;
        }

        public boolean isAttributeCapability() {
            return (this.m_Flags & 4) == 4;
        }

        public boolean isOtherCapability() {
            return (this.m_Flags & 0x10) == 16;
        }

        public boolean isClassCapability() {
            return (this.m_Flags & 8) == 8;
        }

        public String toString() {
            return this.m_Display;
        }
    }
}

