/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.pmml.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInArithmetic
extends Function {
    private static final long serialVersionUID = 2275009453597279459L;
    protected Operator m_operator = Operator.ADDITION;

    public BuiltInArithmetic(Operator operator) {
        this.m_operator = operator;
        this.m_functionName = this.m_operator.toString();
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> arrayList) throws Exception {
        this.m_parameterDefs = arrayList;
        if (this.m_parameterDefs.size() != 2) {
            throw new Exception("[Arithmetic] wrong number of parameters. Recieved " + this.m_parameterDefs.size() + ", expected 2.");
        }
    }

    @Override
    public String[] getParameterNames() {
        String[] stringArray = new String[]{"A", "B"};
        return stringArray;
    }

    @Override
    public Attribute getOutputDef() {
        return new Attribute("BuiltInArithmeticResult:" + this.m_operator.toString());
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInArithmetic] incoming parameter structure has not been set!");
        }
        if (this.m_parameterDefs.size() != 2 || dArray.length != 2) {
            throw new Exception("[BuiltInArithmetic] wrong number of parameters!");
        }
        double d = this.m_operator.eval(dArray[0], dArray[1]);
        return d;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String string) {
        return string + ((Attribute)this.m_parameterDefs.get(0)).name() + this.m_functionName + ((Attribute)this.m_parameterDefs.get(1)).name();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        ADDITION(" + "){

            double eval(double d, double d2) {
                return d + d2;
            }
        }
        ,
        SUBTRACTION(" - "){

            double eval(double d, double d2) {
                return d - d2;
            }
        }
        ,
        MULTIPLICATION(" * "){

            double eval(double d, double d2) {
                return d * d2;
            }
        }
        ,
        DIVISION(" / "){

            double eval(double d, double d2) {
                return d / d2;
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3);

        private Operator(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

