/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JPanel;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

public class PredictionAppender
extends JPanel
implements DataSource,
TrainingSetProducer,
TestSetProducer,
Visible,
BeanCommon,
EventConstraints,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
Serializable {
    private static final long serialVersionUID = -2987740065058976673L;
    protected Vector m_dataSourceListeners = new Vector();
    protected Vector m_instanceListeners = new Vector();
    protected Vector m_trainingSetListeners = new Vector();
    protected Vector m_testSetListeners = new Vector();
    protected Object m_listenee = null;
    protected Instances m_format;
    protected BeanVisual m_visual = new BeanVisual("PredictionAppender", "weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    protected boolean m_appendProbabilities;
    protected transient Logger m_logger;
    protected InstanceEvent m_instanceEvent;

    public String globalInfo() {
        return "Accepts batch or incremental classifier events and produces a new data set with classifier predictions appended.";
    }

    public PredictionAppender() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String appendPredictedProbabilitiesTipText() {
        return "append probabilities rather than labels for discrete class predictions";
    }

    public boolean getAppendPredictedProbabilities() {
        return this.m_appendProbabilities;
    }

    public void setAppendPredictedProbabilities(boolean bl) {
        this.m_appendProbabilities = bl;
    }

    public void addTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingSetListeners.addElement(trainingSetListener);
        if (this.m_format != null) {
            TrainingSetEvent trainingSetEvent = new TrainingSetEvent(this, this.m_format);
            trainingSetListener.acceptTrainingSet(trainingSetEvent);
        }
    }

    public void removeTrainingSetListener(TrainingSetListener trainingSetListener) {
        this.m_trainingSetListeners.removeElement(trainingSetListener);
    }

    public void addTestSetListener(TestSetListener testSetListener) {
        this.m_testSetListeners.addElement(testSetListener);
        if (this.m_format != null) {
            TestSetEvent testSetEvent = new TestSetEvent(this, this.m_format);
            testSetListener.acceptTestSet(testSetEvent);
        }
    }

    public void removeTestSetListener(TestSetListener testSetListener) {
        this.m_testSetListeners.removeElement(testSetListener);
    }

    public synchronized void addDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataSourceListeners.addElement(dataSourceListener);
        if (this.m_format != null) {
            DataSetEvent dataSetEvent = new DataSetEvent(this, this.m_format);
            dataSourceListener.acceptDataSet(dataSetEvent);
        }
    }

    public synchronized void removeDataSourceListener(DataSourceListener dataSourceListener) {
        this.m_dataSourceListeners.remove(dataSourceListener);
    }

    public synchronized void addInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.addElement(instanceListener);
        if (this.m_format != null) {
            InstanceEvent instanceEvent = new InstanceEvent(this, this.m_format);
            instanceListener.acceptInstance(instanceEvent);
        }
    }

    public synchronized void removeInstanceListener(InstanceListener instanceListener) {
        this.m_instanceListeners.remove(instanceListener);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/PredictionAppender.gif", "weka/gui/beans/icons/PredictionAppender_animated.gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptClassifier(IncrementalClassifierEvent incrementalClassifierEvent) {
        Classifier classifier = incrementalClassifierEvent.getClassifier();
        Instance instance = incrementalClassifierEvent.getCurrentInstance();
        int n = incrementalClassifierEvent.getStatus();
        int n2 = 0;
        n2 = n == 0 ? incrementalClassifierEvent.getStructure().numAttributes() : instance.dataset().numAttributes();
        if (n == 0) {
            this.m_instanceEvent = new InstanceEvent(this, null, 0);
            Instances instances = new Instances(incrementalClassifierEvent.getStructure(), 0);
            String string = "_with predictions";
            if (!this.m_appendProbabilities || instances.classAttribute().isNumeric()) {
                try {
                    this.m_format = this.makeDataSetClass(instances, classifier, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    this.m_format = this.makeDataSetProbabilities(instances, classifier, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            this.m_instanceEvent.setStructure(this.m_format);
            this.notifyInstanceAvailable(this.m_instanceEvent);
            return;
        }
        double[] dArray = new double[this.m_format.numAttributes()];
        try {
            try {
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = instance.value(i);
                }
                if (!this.m_appendProbabilities || instance.dataset().classAttribute().isNumeric()) {
                    double d;
                    dArray[dArray.length - 1] = d = classifier.classifyInstance(instance);
                } else if (this.m_appendProbabilities) {
                    double[] dArray2 = classifier.distributionForInstance(instance);
                    for (int i = n2; i < dArray.length; ++i) {
                        dArray[i] = dArray2[i - n2];
                    }
                }
                Object var11_19 = null;
                Instance instance2 = new Instance(instance.weight(), dArray);
                instance2.setDataset(this.m_format);
                this.m_instanceEvent.setInstance(instance2);
                this.m_instanceEvent.setStatus(n);
                this.notifyInstanceAvailable(this.m_instanceEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var11_20 = null;
                Instance instance3 = new Instance(instance.weight(), dArray);
                instance3.setDataset(this.m_format);
                this.m_instanceEvent.setInstance(instance3);
                this.m_instanceEvent.setStatus(n);
                this.notifyInstanceAvailable(this.m_instanceEvent);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            Instance instance4 = new Instance(instance.weight(), dArray);
            instance4.setDataset(this.m_format);
            this.m_instanceEvent.setInstance(instance4);
            this.m_instanceEvent.setStatus(n);
            this.notifyInstanceAvailable(this.m_instanceEvent);
            throw throwable;
        }
        if (n == 2) {
            this.m_instanceEvent = null;
        }
    }

    public void acceptClassifier(BatchClassifierEvent batchClassifierEvent) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (batchClassifierEvent.getTestSet() == null) {
                return;
            }
            Instances instances = batchClassifierEvent.getTestSet().getDataSet();
            Instances instances2 = batchClassifierEvent.getTrainSet().getDataSet();
            int n = batchClassifierEvent.getSetNumber();
            int n2 = batchClassifierEvent.getMaxSetNumber();
            Classifier classifier = batchClassifierEvent.getClassifier();
            String string = "_set_" + batchClassifierEvent.getSetNumber() + "_of_" + batchClassifierEvent.getMaxSetNumber();
            if (!this.m_appendProbabilities || instances.classAttribute().isNumeric()) {
                try {
                    EventObject eventObject;
                    Instances instances3 = this.makeDataSetClass(instances, classifier, string);
                    Instances instances4 = this.makeDataSetClass(instances2, classifier, string);
                    if (this.m_trainingSetListeners.size() > 0) {
                        eventObject = new TrainingSetEvent(this, new Instances(instances4, 0));
                        eventObject.m_setNumber = n;
                        eventObject.m_maxSetNumber = n2;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)eventObject);
                        for (int i = 0; i < instances2.numInstances(); ++i) {
                            double d = classifier.classifyInstance(instances2.instance(i));
                            instances4.instance(i).setValue(instances4.numAttributes() - 1, d);
                        }
                        eventObject = new TrainingSetEvent(this, instances4);
                        eventObject.m_setNumber = n;
                        eventObject.m_maxSetNumber = n2;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)eventObject);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        eventObject = new TestSetEvent(this, new Instances(instances3, 0));
                        ((TestSetEvent)eventObject).m_setNumber = n;
                        ((TestSetEvent)eventObject).m_maxSetNumber = n2;
                        this.notifyTestSetAvailable((TestSetEvent)eventObject);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(instances3, 0)));
                    }
                    if (batchClassifierEvent.getTestSet().isStructureOnly()) {
                        this.m_format = instances3;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        for (int i = 0; i < instances.numInstances(); ++i) {
                            double d = classifier.classifyInstance(instances.instance(i));
                            instances3.instance(i).setValue(instances3.numAttributes() - 1, d);
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent testSetEvent = new TestSetEvent(this, instances3);
                        testSetEvent.m_setNumber = n;
                        testSetEvent.m_maxSetNumber = n2;
                        this.notifyTestSetAvailable(testSetEvent);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, instances3));
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.m_appendProbabilities) {
                try {
                    EventObject eventObject;
                    Instances instances5 = this.makeDataSetProbabilities(instances, classifier, string);
                    Instances instances6 = this.makeDataSetProbabilities(instances2, classifier, string);
                    if (this.m_trainingSetListeners.size() > 0) {
                        eventObject = new TrainingSetEvent(this, new Instances(instances6, 0));
                        eventObject.m_setNumber = n;
                        eventObject.m_maxSetNumber = n2;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)eventObject);
                        for (int i = 0; i < instances2.numInstances(); ++i) {
                            double[] dArray = classifier.distributionForInstance(instances2.instance(i));
                            for (int j = 0; j < instances2.classAttribute().numValues(); ++j) {
                                instances6.instance(i).setValue(instances2.numAttributes() + j, dArray[j]);
                            }
                        }
                        eventObject = new TrainingSetEvent(this, instances6);
                        eventObject.m_setNumber = n;
                        eventObject.m_maxSetNumber = n2;
                        this.notifyTrainingSetAvailable((TrainingSetEvent)eventObject);
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        eventObject = new TestSetEvent(this, new Instances(instances5, 0));
                        ((TestSetEvent)eventObject).m_setNumber = n;
                        ((TestSetEvent)eventObject).m_maxSetNumber = n2;
                        this.notifyTestSetAvailable((TestSetEvent)eventObject);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(instances5, 0)));
                    }
                    if (batchClassifierEvent.getTestSet().isStructureOnly()) {
                        this.m_format = instances5;
                    }
                    if (this.m_dataSourceListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
                        for (int i = 0; i < instances.numInstances(); ++i) {
                            double[] dArray = classifier.distributionForInstance(instances.instance(i));
                            for (int j = 0; j < instances.classAttribute().numValues(); ++j) {
                                instances5.instance(i).setValue(instances.numAttributes() + j, dArray[j]);
                            }
                        }
                    }
                    if (this.m_testSetListeners.size() > 0) {
                        TestSetEvent testSetEvent = new TestSetEvent(this, instances5);
                        testSetEvent.m_setNumber = n;
                        testSetEvent.m_maxSetNumber = n2;
                        this.notifyTestSetAvailable(testSetEvent);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, instances5));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void acceptClusterer(BatchClustererEvent batchClustererEvent) {
        if (this.m_dataSourceListeners.size() > 0 || this.m_trainingSetListeners.size() > 0 || this.m_testSetListeners.size() > 0) {
            if (batchClustererEvent.getTestSet().isStructureOnly()) {
                return;
            }
            Instances instances = batchClustererEvent.getTestSet().getDataSet();
            Clusterer clusterer = batchClustererEvent.getClusterer();
            String string = batchClustererEvent.getTestOrTrain() == 0 ? "test" : "training";
            String string2 = "_" + string + "_" + batchClustererEvent.getSetNumber() + "_of_" + batchClustererEvent.getMaxSetNumber();
            if (!this.m_appendProbabilities || !(clusterer instanceof DensityBasedClusterer)) {
                if (this.m_appendProbabilities && !(clusterer instanceof DensityBasedClusterer)) {
                    System.err.println("Only density based clusterers can append probabilities. Instead cluster will be assigned for each instance.");
                    if (this.m_logger != null) {
                        this.m_logger.logMessage("[PredictionAppender] " + this.statusMessagePrefix() + " Only density based clusterers can " + "append probabilities. Instead cluster will be assigned for each " + "instance.");
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: Only density based clusterers can append probabilities. " + "Instead cluster will be assigned for each instance.");
                    }
                }
                try {
                    EventObject eventObject;
                    Instances instances2 = this.makeClusterDataSetClass(instances, clusterer, string2);
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(instances2, 0)));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && batchClustererEvent.getTestOrTrain() > 0) {
                        eventObject = new TrainingSetEvent(this, new Instances(instances2, 0));
                        eventObject.m_setNumber = batchClustererEvent.getSetNumber();
                        eventObject.m_maxSetNumber = batchClustererEvent.getMaxSetNumber();
                        this.notifyTrainingSetAvailable((TrainingSetEvent)eventObject);
                    }
                    if (this.m_testSetListeners.size() > 0 && batchClustererEvent.getTestOrTrain() == 0) {
                        eventObject = new TestSetEvent(this, new Instances(instances2, 0));
                        ((TestSetEvent)eventObject).m_setNumber = batchClustererEvent.getSetNumber();
                        ((TestSetEvent)eventObject).m_maxSetNumber = batchClustererEvent.getMaxSetNumber();
                        this.notifyTestSetAvailable((TestSetEvent)eventObject);
                    }
                    for (int i = 0; i < instances.numInstances(); ++i) {
                        double d = clusterer.clusterInstance(instances.instance(i));
                        instances2.instance(i).setValue(instances2.numAttributes() - 1, d);
                    }
                    if (this.m_dataSourceListeners.size() > 0) {
                        this.notifyDataSetAvailable(new DataSetEvent(this, instances2));
                    }
                    if (this.m_trainingSetListeners.size() > 0 && batchClustererEvent.getTestOrTrain() > 0) {
                        TrainingSetEvent trainingSetEvent = new TrainingSetEvent(this, instances2);
                        trainingSetEvent.m_setNumber = batchClustererEvent.getSetNumber();
                        trainingSetEvent.m_maxSetNumber = batchClustererEvent.getMaxSetNumber();
                        this.notifyTrainingSetAvailable(trainingSetEvent);
                    }
                    if (this.m_testSetListeners.size() > 0 && batchClustererEvent.getTestOrTrain() == 0) {
                        TestSetEvent testSetEvent = new TestSetEvent(this, instances2);
                        testSetEvent.m_setNumber = batchClustererEvent.getSetNumber();
                        testSetEvent.m_maxSetNumber = batchClustererEvent.getMaxSetNumber();
                        this.notifyTestSetAvailable(testSetEvent);
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    Instances instances3 = this.makeClusterDataSetProbabilities(instances, clusterer, string2);
                    this.notifyDataSetAvailable(new DataSetEvent(this, new Instances(instances3, 0)));
                    for (int i = 0; i < instances.numInstances(); ++i) {
                        double[] dArray = clusterer.distributionForInstance(instances.instance(i));
                        for (int j = 0; j < clusterer.numberOfClusters(); ++j) {
                            instances3.instance(i).setValue(instances.numAttributes() + j, dArray[j]);
                        }
                    }
                    this.notifyDataSetAvailable(new DataSetEvent(this, instances3));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private Instances makeDataSetProbabilities(Instances instances, Classifier classifier, String string) throws Exception {
        String string2 = classifier.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        int n = instances.numAttributes();
        Instances instances2 = new Instances(instances);
        for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
            Add add = new Add();
            add.setAttributeIndex("last");
            add.setAttributeName(string2 + "_prob_" + instances.classAttribute().value(i));
            add.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, add);
        }
        instances2.setRelationName(instances.relationName() + string);
        return instances2;
    }

    private Instances makeDataSetClass(Instances instances, Classifier classifier, String string) throws Exception {
        Object object;
        Add add = new Add();
        add.setAttributeIndex("last");
        String string2 = classifier.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        add.setAttributeName("class_predicted_by: " + string2);
        if (instances.classAttribute().isNominal()) {
            object = "";
            Enumeration enumeration = instances.classAttribute().enumerateValues();
            object = (String)object + (String)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                object = (String)object + "," + (String)enumeration.nextElement();
            }
            add.setNominalLabels((String)object);
        }
        add.setInputFormat(instances);
        object = Filter.useFilter(instances, add);
        ((Instances)object).setRelationName(instances.relationName() + string);
        return object;
    }

    private Instances makeClusterDataSetProbabilities(Instances instances, Clusterer clusterer, String string) throws Exception {
        int n = instances.numAttributes();
        Instances instances2 = new Instances(instances);
        for (int i = 0; i < clusterer.numberOfClusters(); ++i) {
            Add add = new Add();
            add.setAttributeIndex("last");
            add.setAttributeName("prob_cluster" + i);
            add.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, add);
        }
        instances2.setRelationName(instances.relationName() + string);
        return instances2;
    }

    private Instances makeClusterDataSetClass(Instances instances, Clusterer clusterer, String string) throws Exception {
        Add add = new Add();
        add.setAttributeIndex("last");
        String string2 = clusterer.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
        add.setAttributeName("assigned_cluster: " + string2);
        String string3 = "0";
        for (int i = 1; i <= clusterer.numberOfClusters() - 1; ++i) {
            string3 = string3 + "," + i;
        }
        add.setNominalLabels(string3);
        add.setInputFormat(instances);
        Instances instances2 = Filter.useFilter(instances, add);
        instances2.setRelationName(instances.relationName() + string);
        return instances2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceAvailable(InstanceEvent instanceEvent) {
        Vector vector;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            vector = (Vector)this.m_instanceListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((InstanceListener)vector.elementAt(i)).acceptInstance(instanceEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetAvailable(DataSetEvent dataSetEvent) {
        Vector vector;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            vector = (Vector)this.m_dataSourceListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((DataSourceListener)vector.elementAt(i)).acceptDataSet(dataSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetAvailable(TestSetEvent testSetEvent) {
        Vector vector;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            vector = (Vector)this.m_testSetListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetAvailable(TrainingSetEvent trainingSetEvent) {
        Vector vector;
        PredictionAppender predictionAppender = this;
        synchronized (predictionAppender) {
            vector = (Vector)this.m_trainingSetListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TrainingSetListener)vector.elementAt(i)).acceptTrainingSet(trainingSetEvent);
            }
        }
    }

    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public boolean isBusy() {
        return false;
    }

    public boolean connectionAllowed(String string) {
        return this.m_listenee == null;
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public synchronized void connectionNotification(String string, Object object) {
        if (this.connectionAllowed(string)) {
            this.m_listenee = object;
        }
    }

    public synchronized void disconnectionNotification(String string, Object object) {
        if (this.m_listenee == object) {
            this.m_listenee = null;
            this.m_format = null;
        }
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            if (string.equals("instance") && !((EventConstraints)this.m_listenee).eventGeneratable("incrementalClassifier")) {
                return false;
            }
            if (string.equals("dataSet") || string.equals("trainingSet") || string.equals("testSet")) {
                if (((EventConstraints)this.m_listenee).eventGeneratable("batchClassifier")) {
                    return true;
                }
                return ((EventConstraints)this.m_listenee).eventGeneratable("batchClusterer");
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

