/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.ClassDiscovery;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.experiment.Experiment;
import weka.gui.ConverterFileChooser;
import weka.gui.JListHelper;
import weka.gui.ViewerDialog;
import weka.gui.experiment.ExperimenterDefaults;

public class DatasetListPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7068857852794405769L;
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton("Add new...");
    protected JButton m_EditBut = new JButton("Edit selected...");
    protected JButton m_DeleteBut = new JButton("Delete selected");
    protected JButton m_UpBut = new JButton("Up");
    protected JButton m_DownBut = new JButton("Down");
    protected JCheckBox m_relativeCheck = new JCheckBox("Use relative paths");
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(ExperimenterDefaults.getInitialDatasetsDirectory());

    public DatasetListPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public DatasetListPanel() {
        this.m_List = new JList();
        this.m_List.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DatasetListPanel.this.setButtons(listSelectionEvent);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = DatasetListPanel.this.m_List.locationToIndex(mouseEvent.getPoint())) > -1) {
                    DatasetListPanel.this.actionPerformed(new ActionEvent(DatasetListPanel.this.m_EditBut, 0, ""));
                }
            }
        };
        this.m_List.addMouseListener(mouseAdapter);
        this.m_FileChooser.setCoreConvertersOnly(true);
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_FileChooser.setFileSelectionMode(2);
        this.m_FileChooser.setAcceptAllFileFilterUsed(false);
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.m_EditBut.setEnabled(false);
        this.m_EditBut.addActionListener(this);
        this.m_UpBut.setEnabled(false);
        this.m_UpBut.addActionListener(this);
        this.m_DownBut.setEnabled(false);
        this.m_DownBut.addActionListener(this);
        this.m_relativeCheck.setSelected(ExperimenterDefaults.getUseRelativePaths());
        this.m_relativeCheck.setToolTipText("Store file paths relative to the start directory");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Datasets"));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_AddBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_EditBut, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_DeleteBut, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_relativeCheck, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.m_UpBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.m_DownBut, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
        this.add((Component)jPanel2, "South");
    }

    private void setButtons(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent == null || listSelectionEvent.getSource() == this.m_List) {
            this.m_DeleteBut.setEnabled(this.m_List.getSelectedIndex() > -1);
            this.m_EditBut.setEnabled(this.m_List.getSelectedIndices().length == 1);
            this.m_UpBut.setEnabled(JListHelper.canMoveUp(this.m_List));
            this.m_DownBut.setEnabled(JListHelper.canMoveDown(this.m_List));
        }
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_List.setModel(this.m_Exp.getDatasets());
        this.m_AddBut.setEnabled(true);
        this.setButtons(null);
    }

    protected void getFilesRecursively(File file, Vector vector) {
        try {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = file.getCanonicalPath() + File.separator + stringArray[i];
                File file2 = new File(stringArray[i]);
                if (!this.m_FileChooser.getFileFilter().accept(file2)) continue;
                if (file2.isDirectory()) {
                    this.getFilesRecursively(file2, vector);
                    continue;
                }
                vector.addElement(file2);
            }
        }
        catch (Exception exception) {
            System.err.println("IOError occured when reading list of files");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.m_relativeCheck.isSelected();
        if (actionEvent.getSource() == this.m_AddBut) {
            int n = this.m_FileChooser.showOpenDialog(this);
            if (n == 0) {
                if (this.m_FileChooser.isMultiSelectionEnabled()) {
                    File[] fileArray = this.m_FileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        Serializable serializable;
                        if (fileArray[i].isDirectory()) {
                            serializable = new Vector();
                            this.getFilesRecursively(fileArray[i], (Vector)serializable);
                            Collections.sort(serializable, new ClassDiscovery.StringCompare());
                            for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                                File file = (File)((Vector)serializable).elementAt(j);
                                if (bl) {
                                    try {
                                        file = Utils.convertToRelativePath(file);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                this.m_Exp.getDatasets().addElement(file);
                            }
                            continue;
                        }
                        serializable = fileArray[i];
                        if (bl) {
                            try {
                                serializable = Utils.convertToRelativePath(serializable);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(serializable);
                    }
                    this.setButtons(null);
                } else {
                    if (this.m_FileChooser.getSelectedFile().isDirectory()) {
                        Vector vector = new Vector();
                        this.getFilesRecursively(this.m_FileChooser.getSelectedFile(), vector);
                        Collections.sort(vector, new ClassDiscovery.StringCompare());
                        for (int i = 0; i < vector.size(); ++i) {
                            File file = (File)vector.elementAt(i);
                            if (bl) {
                                try {
                                    file = Utils.convertToRelativePath(file);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            this.m_Exp.getDatasets().addElement(file);
                        }
                    } else {
                        File file = this.m_FileChooser.getSelectedFile();
                        if (bl) {
                            try {
                                file = Utils.convertToRelativePath(file);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.m_Exp.getDatasets().addElement(file);
                    }
                    this.setButtons(null);
                }
            }
        } else if (actionEvent.getSource() == this.m_DeleteBut) {
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    this.m_Exp.getDatasets().removeElementAt(n);
                    if (this.m_Exp.getDatasets().size() > n) {
                        this.m_List.setSelectedIndex(n);
                        continue;
                    }
                    this.m_List.setSelectedIndex(n - 1);
                }
            }
            this.setButtons(null);
        } else if (actionEvent.getSource() == this.m_EditBut) {
            int n = this.m_List.getSelectedIndex();
            if (n != -1) {
                ViewerDialog viewerDialog = new ViewerDialog(null);
                String string = this.m_List.getSelectedValue().toString();
                try {
                    ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(string);
                    int n2 = viewerDialog.showDialog(dataSource.getDataSet());
                    dataSource = null;
                    System.gc();
                    if (n2 == 0 && viewerDialog.isChanged() && (n2 = JOptionPane.showConfirmDialog(this, "File was modified - save changes?")) == 0) {
                        AbstractFileSaver abstractFileSaver = ConverterUtils.getSaverForFile(string);
                        abstractFileSaver.setFile(new File(string));
                        abstractFileSaver.setInstances(viewerDialog.getInstances());
                        abstractFileSaver.writeBatch();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Error loading file '" + string + "':\n" + exception.toString(), "Error loading file", 1);
                }
            }
            this.setButtons(null);
        } else if (actionEvent.getSource() == this.m_UpBut) {
            JListHelper.moveUp(this.m_List);
        } else if (actionEvent.getSource() == this.m_DownBut) {
            JListHelper.moveDown(this.m_List);
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Dataset List Editor");
            jFrame.getContentPane().setLayout(new BorderLayout());
            DatasetListPanel datasetListPanel = new DatasetListPanel();
            jFrame.getContentPane().add((Component)datasetListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            System.err.println("Short nap");
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            datasetListPanel.setExperiment(new Experiment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

